/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AuthAccountRequest;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.signin.internal.AuthAccountResult;
import com.google.android.gms.signin.internal.CheckServerAuthResult;
import com.google.android.gms.signin.internal.zzd;
import com.google.android.gms.signin.internal.zze;
import com.google.android.gms.signin.internal.zzf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class zzh
extends zzi<zzf>
implements zzmd {
    private final com.google.android.gms.common.internal.zze zzQg;
    private final zzme zzSY;
    private Integer zzSZ;
    private final ExecutorService zzaBN;

    public zzh(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, zzme zzme2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ExecutorService executorService) {
        super(context, looper, 44, connectionCallbacks, onConnectionFailedListener, zze2);
        this.zzQg = zze2;
        this.zzSY = zzme2;
        this.zzSZ = zze2.zzlN();
        this.zzaBN = executorService;
    }

    @Override
    public void zza(zzr zzr2) {
        zzv.zzb(zzr2, (Object)"Expecting a valid IResolveAccountCallbacks");
        try {
            Account account = this.zzQg.zzlE();
            ((zzf)this.zzlX()).zza(new ResolveAccountRequest(account, this.zzSZ), zzr2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when resolveAccount is called");
            try {
                zzr2.zzb(new ResolveAccountResponse(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"IResolveAccountCallbacks#onAccountResolutionComplete should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    public void zza(zzo zzo2, boolean bl) {
        try {
            ((zzf)this.zzlX()).zza(zzo2, this.zzSZ, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzwe() {
        try {
            ((zzf)this.zzlX()).zzhB(this.zzSZ);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(zzo zzo2, Set<Scope> set, zze zze2) {
        zzv.zzb(zze2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ((zzf)this.zzlX()).zza(new AuthAccountRequest(zzo2, set), zze2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when authAccount is called");
            try {
                zze2.zza(new ConnectionResult(8, null), new AuthAccountResult());
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onAuthAccount should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    protected String zzeq() {
        return "com.google.android.gms.signin.service.START";
    }

    @Override
    protected String zzer() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zzf zzcI(IBinder iBinder) {
        return zzf.zza.zzcH(iBinder);
    }

    @Override
    protected Bundle zzka() {
        Bundle bundle = zzh.zza(this.zzSY, this.zzQg.zzlN(), this.zzaBN);
        String string = this.zzQg.zzlJ();
        if (!this.getContext().getPackageName().equals(string)) {
            bundle.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzQg.zzlJ());
        }
        return bundle;
    }

    public static Bundle zza(zzme zzme2, Integer n, ExecutorService executorService) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzme2.zzwf());
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzme2.zzwg());
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzme2.zzvx());
        if (zzme2.zzwh() != null) {
            IBinder iBinder = new zza(zzme2, executorService).asBinder();
            bundle.putParcelable("com.google.android.gms.signin.internal.signInCallbacks", (Parcelable)new BinderWrapper(iBinder));
        }
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface zzD(IBinder iBinder) {
        return this.zzcI(iBinder);
    }

    private static class zza
    extends zzd.zza {
        private final zzme zzSY;
        private final ExecutorService zzaBN;

        public zza(zzme zzme2, ExecutorService executorService) {
            this.zzSY = zzme2;
            this.zzaBN = executorService;
        }

        @Override
        public void zza(final String string, final List<Scope> list, final zzf zzf2) throws RemoteException {
            this.zzaBN.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        GoogleApiClient.ServerAuthCodeCallbacks serverAuthCodeCallbacks = zza.this.zzwh();
                        Set<Scope> set = Collections.unmodifiableSet(new HashSet(list));
                        GoogleApiClient.ServerAuthCodeCallbacks.CheckResult checkResult = serverAuthCodeCallbacks.onCheckServerAuthorization(string, set);
                        CheckServerAuthResult checkServerAuthResult = new CheckServerAuthResult(checkResult.zzkN(), checkResult.zzkO());
                        zzf2.zza(checkServerAuthResult);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing checkServerAuthorization callback", (Throwable)remoteException);
                    }
                }
            });
        }

        @Override
        public void zza(final String string, final String string2, final zzf zzf2) throws RemoteException {
            this.zzaBN.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean bl = zza.this.zzwh().onUploadServerAuthCode(string, string2);
                        zzf2.zzag(bl);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing uploadServerAuthCode callback", (Throwable)remoteException);
                    }
                }
            });
        }

        private GoogleApiClient.ServerAuthCodeCallbacks zzwh() throws RemoteException {
            return this.zzSY.zzwh();
        }
    }
}

