/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class zzhp<K, V> {
    private final LinkedHashMap<K, V> zzUj;
    private int size;
    private int zzUk;
    private int zzUl;
    private int zzUm;
    private int zzUn;
    private int zzUo;
    private int zzUp;

    public zzhp(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.zzUk = n;
        this.zzUj = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        zzhp<K, V> zzhp2 = this;
        synchronized (zzhp2) {
            object = this.zzUj.get(key);
            if (object != null) {
                ++this.zzUo;
                return object;
            }
            ++this.zzUp;
        }
        zzhp2 = this.create(key);
        if (zzhp2 == null) {
            return null;
        }
        zzhp zzhp3 = this;
        synchronized (zzhp3) {
            ++this.zzUm;
            object = this.zzUj.put(key, zzhp2);
            if (object != null) {
                this.zzUj.put(key, object);
            } else {
                this.size += this.zzc(key, zzhp2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, zzhp2, object);
            return object;
        }
        this.trimToSize(this.zzUk);
        return (V)zzhp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        zzhp zzhp2 = this;
        synchronized (zzhp2) {
            ++this.zzUl;
            this.size += this.zzc(key, value);
            v = this.zzUj.put(key, value);
            if (v != null) {
                this.size -= this.zzc(key, v);
            }
        }
        if (v != null) {
            this.entryRemoved(false, key, v, value);
        }
        this.trimToSize(this.zzUk);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v;
            K k;
            zzhp zzhp2 = this;
            synchronized (zzhp2) {
                if (this.size < 0 || this.zzUj.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.zzUj.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.zzUj.entrySet().iterator().next();
                k = entry.getKey();
                v = entry.getValue();
                this.zzUj.remove(k);
                this.size -= this.zzc(k, v);
                ++this.zzUn;
            }
            this.entryRemoved(true, k, v, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int zzc(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n = this.zzUo + this.zzUp;
        int n2 = n != 0 ? 100 * this.zzUo / n : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.zzUk, this.zzUo, this.zzUp, n2);
    }
}

