/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzl
extends zzk
implements Handler.Callback {
    private final HashMap<zza, zzb> zzTM = new HashMap();
    private final Context zzoh;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb zzTN;
    private final long zzTO;

    zzl(Context context) {
        this.zzoh = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzTN = com.google.android.gms.common.stats.zzb.zznb();
        this.zzTO = 5000L;
    }

    @Override
    public boolean zza(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2), serviceConnection, string3);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzv.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzTM;
        synchronized (hashMap) {
            zzb zzb2 = this.zzTM.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzbM(string2);
                this.zzTM.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    throw new IllegalStateException("Trying to bind a GmsServiceConnection that was already connected before.  config=" + zza2);
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzbM(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2), serviceConnection, string3);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzv.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzTM;
        synchronized (hashMap) {
            zzb zzb2 = this.zzTM.get(zza2);
            if (zzb2 == null) {
                throw new IllegalStateException("Nonexistent connection status for service config: " + zza2);
            }
            if (!zzb2.zza(serviceConnection)) {
                throw new IllegalStateException("Trying to unbind a GmsServiceConnection  that was not bound before.  config=" + zza2);
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzmj()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzTO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                zzb zzb2 = (zzb)msg.obj;
                HashMap<zza, zzb> hashMap = this.zzTM;
                synchronized (hashMap) {
                    if (zzb2.zzmj()) {
                        if (zzb2.isBound()) {
                            zzb2.zzbN("GmsClientSupervisor");
                        }
                        this.zzTM.remove(zzb2.zzTT);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzso;
        private final ComponentName zzTP;

        public zza(String string2) {
            this.zzso = zzv.zzbS(string2);
            this.zzTP = null;
        }

        public zza(ComponentName componentName) {
            this.zzso = null;
            this.zzTP = zzv.zzr(componentName);
        }

        public String toString() {
            return this.zzso == null ? this.zzTP.flattenToString() : this.zzso;
        }

        public Intent zzmi() {
            Intent intent = this.zzso != null ? new Intent(this.zzso).setPackage("com.google.android.gms") : new Intent().setComponent(this.zzTP);
            return intent;
        }

        public int hashCode() {
            return zzu.hashCode(this.zzso, this.zzTP);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return zzu.equal(this.zzso, zza2.zzso) && zzu.equal(this.zzTP, zza2.zzTP);
        }
    }

    private final class zzb {
        private final zza zzTQ;
        private final Set<ServiceConnection> zzTR;
        private int mState;
        private boolean zzTS;
        private IBinder zzSU;
        private final com.google.android.gms.common.internal.zzl$zza zzTT;
        private ComponentName zzTP;

        public zzb(com.google.android.gms.common.internal.zzl$zza zza2) {
            this.zzTT = zza2;
            this.zzTQ = new zza();
            this.zzTR = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        public void zzbM(String string2) {
            this.zzTS = zzl.this.zzTN.zza(zzl.this.zzoh, string2, this.zzTT.zzmi(), this.zzTQ, 129);
            if (this.zzTS) {
                this.mState = 3;
            } else {
                zzl.this.zzTN.zza(zzl.this.zzoh, this.zzTQ);
            }
        }

        public void zzbN(String string2) {
            zzl.this.zzTN.zza(zzl.this.zzoh, this.zzTQ);
            this.zzTS = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzl.this.zzTN.zza(zzl.this.zzoh, serviceConnection, string2, this.zzTT.zzmi());
            this.zzTR.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzl.this.zzTN.zzb(zzl.this.zzoh, serviceConnection);
            this.zzTR.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzTS;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzTR.contains(serviceConnection);
        }

        public boolean zzmj() {
            return this.zzTR.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzSU;
        }

        public ComponentName getComponentName() {
            return this.zzTP;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName component, IBinder binder) {
                HashMap hashMap = zzl.this.zzTM;
                synchronized (hashMap) {
                    zzb.this.zzSU = binder;
                    zzb.this.zzTP = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzTR) {
                        serviceConnection.onServiceConnected(component, binder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName component) {
                HashMap hashMap = zzl.this.zzTM;
                synchronized (hashMap) {
                    zzb.this.zzSU = null;
                    zzb.this.zzTP = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzTR) {
                        serviceConnection.onServiceDisconnected(component);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

