/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.ValidateAccountRequest;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzv;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public abstract class zzi<T extends IInterface>
implements Api.zza,
zzj.zza {
    private final Context mContext;
    private final com.google.android.gms.common.internal.zze zzQg;
    private final Looper zzPx;
    private final zzk zzTo;
    final Handler mHandler;
    private final Object zzoe = new Object();
    private zzq zzTp;
    private boolean zzTq = false;
    private GoogleApiClient.zza zzTr;
    private T zzTs;
    private final ArrayList<zzc<?>> zzTt = new ArrayList();
    private zze zzTu;
    private int zzTv = 1;
    private final Set<Scope> zzPP;
    private final Account zzJc;
    private final zzj zzQs;
    private final int zzTw;
    public static final String[] zzTx = new String[]{"service_esmobile", "service_googleme"};

    @Deprecated
    protected zzi(Context context, Looper looper, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = zzv.zzr(context);
        this.zzPx = zzv.zzb(looper, (Object)"Looper must not be null");
        this.zzTo = zzk.zzU(context);
        this.zzQs = new zzj(looper, this);
        this.mHandler = new zzb(looper);
        this.zzTw = n;
        this.zzJc = null;
        this.zzPP = Collections.emptySet();
        this.zzQg = new GoogleApiClient.Builder(context).zzkK();
        this.registerConnectionCallbacks(zzv.zzr(connectionCallbacks));
        this.registerConnectionFailedListener(zzv.zzr(onConnectionFailedListener));
    }

    protected zzi(Context context, Looper looper, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zze zze2) {
        this(context, looper, zzk.zzU(context), n, zze2, connectionCallbacks, onConnectionFailedListener);
    }

    protected zzi(Context context, Looper looper, zzk zzk2, int n, com.google.android.gms.common.internal.zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, zzk2, n, zze2);
        this.registerConnectionCallbacks(zzv.zzr(connectionCallbacks));
        this.registerConnectionFailedListener(zzv.zzr(onConnectionFailedListener));
    }

    protected zzi(Context context, Looper looper, zzk zzk2, int n, com.google.android.gms.common.internal.zze zze2) {
        this.mContext = zzv.zzb(context, (Object)"Context must not be null");
        this.zzPx = zzv.zzb(looper, (Object)"Looper must not be null");
        this.zzTo = zzv.zzb(zzk2, (Object)"Supervisor must not be null");
        this.zzQs = new zzj(looper, this);
        this.mHandler = new zzb(looper);
        this.zzTw = n;
        this.zzQg = zzv.zzr(zze2);
        this.zzJc = zze2.getAccount();
        this.zzPP = this.zzb(zze2.zzlH());
    }

    private Set<Scope> zzb(Set<Scope> set) {
        Set<Scope> set2 = this.zza(set);
        if (set2 == null) {
            return set2;
        }
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    protected Set<Scope> zza(Set<Scope> set) {
        return set;
    }

    protected abstract String zzeq();

    protected abstract String zzer();

    protected String zzlR() {
        return this.zzQg.zzlK();
    }

    protected abstract T zzD(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(int n, T t) {
        zzv.zzQ(n == 3 == (t != null));
        Object object = this.zzoe;
        synchronized (object) {
            this.zzTv = n;
            this.zzTs = t;
            switch (n) {
                case 2: {
                    this.zzlS();
                    break;
                }
                case 1: {
                    this.zzlT();
                }
            }
        }
    }

    private void zzlS() {
        if (this.zzTu != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.zzeq()));
            this.zzTo.zzb(this.zzeq(), (ServiceConnection)this.zzTu, this.zzlR());
        }
        this.zzTu = new zze();
        boolean bl = this.zzTo.zza(this.zzeq(), (ServiceConnection)this.zzTu, this.zzlR());
        if (!bl) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.zzeq()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
        }
    }

    private void zzlT() {
        if (this.zzTu != null) {
            this.zzTo.zzb(this.zzeq(), (ServiceConnection)this.zzTu, this.zzlR());
            this.zzTu = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzTv != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    @Override
    public void connect() {
        this.zzQs.zzmg();
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n));
            return;
        }
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzTv == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzTv == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzQs.zzmf();
        ArrayList<zzc<?>> arrayList = this.zzTt;
        synchronized (arrayList) {
            int n = this.zzTt.size();
            for (int i = 0; i < n; ++i) {
                this.zzTt.get(i).zzmd();
            }
            this.zzTt.clear();
        }
        this.zza(1, null);
    }

    public void zzaO(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzPx;
    }

    public final Account zzlE() {
        return this.zzJc != null ? this.zzJc : new Account("<<default account>>", "com.google");
    }

    protected final com.google.android.gms.common.internal.zze zzlU() {
        return this.zzQg;
    }

    protected Bundle zzka() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new zzf(n, iBinder, bundle)));
    }

    protected void zzb(int n, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, (Object)new zzh(n, bundle)));
    }

    protected void zzlV() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, (Object)new zzg()));
    }

    protected final void zzlW() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle zzjZ() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzlX() throws DeadObjectException {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzTv == 4) {
                throw new DeadObjectException();
            }
            this.zzlW();
            zzv.zza(this.zzTs != null, (Object)"Client is connected but service is null");
            return this.zzTs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void zza(zzc<?> zzc2) {
        ArrayList<zzc<?>> arrayList = this.zzTt;
        synchronized (arrayList) {
            this.zzTt.add(zzc2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, zzc2));
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzQs.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzQs.registerConnectionFailedListener(listener);
    }

    @Override
    public void zza(GoogleApiClient.zza zza2) {
        this.zzTr = zzv.zzb(zza2, (Object)"Must provide a non-null ConnectionStatusReportCallbacks");
        this.zzTq = true;
    }

    @Override
    public void zza(zzo zzo2) {
        Bundle bundle = this.zzlY();
        ValidateAccountRequest validateAccountRequest = new ValidateAccountRequest(zzo2, this.zzPP.toArray(new Scope[this.zzPP.size()]), this.mContext.getPackageName(), bundle);
        try {
            this.zzTp.zza((zzp)new zzd(this), validateAccountRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzaO(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    protected Bundle zzlY() {
        return null;
    }

    @Override
    public void zza(zzo zzo2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzka();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzTw).zzbL(this.mContext.getPackageName()).zzf(bundle);
            if (set != null) {
                getServiceRequest.zza(set.toArray(new Scope[set.size()]));
            }
            if (this.zzjM()) {
                getServiceRequest.zzb(this.zzlE()).zzc(zzo2);
            } else if (this.zzlZ()) {
                getServiceRequest.zzb(this.zzJc);
            }
            this.zzTp.zza((zzp)new zzd(this), getServiceRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzaO(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    @Override
    public boolean zzjM() {
        return false;
    }

    public boolean zzlZ() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        T t;
        int n;
        writer.append(prefix).println("GmsClient:");
        String string2 = prefix + "  ";
        writer.append(string2).append("mStartServiceAction=").println(this.zzeq());
        Object object = this.zzoe;
        synchronized (object) {
            n = this.zzTv;
            t = this.zzTs;
        }
        writer.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                writer.print("CONNECTING");
                break;
            }
            case 3: {
                writer.print("CONNECTED");
                break;
            }
            case 4: {
                writer.print("DISCONNECTING");
                break;
            }
            case 1: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mService=");
        if (t == null) {
            writer.println("null");
        } else {
            writer.append(this.zzer()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
    }

    public static final class zzd
    extends zzp.zza {
        private zzi zzTB;

        public zzd(zzi zzi2) {
            this.zzTB = zzi2;
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            zzv.zzb(this.zzTB, (Object)"onAccountValidationComplete can be called only once per call to validateAccount");
            this.zzTB.zzb(n, bundle);
            this.zzme();
        }

        @Override
        public void zzb(int n, IBinder iBinder, Bundle bundle) {
            zzv.zzb(this.zzTB, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzTB.zza(n, iBinder, bundle);
            this.zzme();
        }

        private void zzme() {
            this.zzTB = null;
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        public final int statusCode;
        public final Bundle zzTy;

        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzTy = bundle;
        }

        protected abstract boolean zzma();

        protected abstract void zzi(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzi.this.zza(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzma()) break;
                    zzi.this.zza(1, null);
                    this.zzi(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzi.this.zza(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzi.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzTy != null) {
                        pendingIntent = (PendingIntent)this.zzTy.getParcelable("pendingIntent");
                    }
                    this.zzi(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzmb() {
        }

        @Override
        protected /* synthetic */ void zzo(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzf
    extends zza {
        public final IBinder zzTC;

        public zzf(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzTC = iBinder;
        }

        @Override
        protected void zzi(ConnectionResult connectionResult) {
            zzi.this.zzQs.zzj(connectionResult);
        }

        @Override
        protected boolean zzma() {
            String string2;
            try {
                string2 = this.zzTC.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzi.this.zzer().equals(string2)) {
                Log.e((String)"GmsClient", (String)("service descriptor mismatch: " + zzi.this.zzer() + " vs. " + string2));
                return false;
            }
            Object t = zzi.this.zzD(this.zzTC);
            if (t != null && zzi.this.zza(2, 3, t)) {
                zzi.this.zzQs.zzmh();
                GooglePlayServicesUtil.zzQ(zzi.this.mContext);
                return true;
            }
            return false;
        }
    }

    protected final class zzh
    extends zza {
        public zzh(int n, Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzi(ConnectionResult connectionResult) {
            if (zzi.this.zzTq) {
                zzi.this.zzTr.zzb(connectionResult);
            } else {
                zzi.this.zzQs.zzj(connectionResult);
            }
        }

        @Override
        protected boolean zzma() {
            zzv.zza(zzi.this.zzTq && zzi.this.zzTr != null, (Object)"PostValidationCallback should not happen when mReportProgress is false ormConnectionProgressReportCallbacks is null");
            zzi.this.zzTr.zzb(ConnectionResult.zzOI);
            return true;
        }
    }

    protected final class zzg
    extends zza {
        public zzg() {
            super(0, null);
        }

        @Override
        protected void zzi(ConnectionResult connectionResult) {
            if (zzi.this.zzTq) {
                zzi.this.zzTr.zza(connectionResult);
            } else {
                zzi.this.zzQs.zzj(connectionResult);
            }
        }

        @Override
        protected boolean zzma() {
            if (zzi.this.zzTq) {
                zzv.zza(zzi.this.zzTr != null, (Object)"mConnectionProgressReportCallbacks should not be null if mReportProgress");
                zzi.this.zzTr.zza(ConnectionResult.zzOI);
            } else {
                zzi.this.zza(null, zzi.this.zzPP);
            }
            return true;
        }
    }

    protected abstract class zzc<TListener> {
        private TListener mListener;
        private boolean zzTA;

        public zzc(TListener TListener) {
            this.mListener = TListener;
            this.zzTA = false;
        }

        protected abstract void zzo(TListener var1);

        protected abstract void zzmb();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzmc() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.mListener;
                if (this.zzTA) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.zzo(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzmb();
                    throw runtimeException;
                }
            } else {
                this.zzmb();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzTA = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzmd();
            ArrayList arrayList = zzi.this.zzTt;
            synchronized (arrayList) {
                zzi.this.zzTt.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzmd() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.mListener = null;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (!(msg.what != 1 && msg.what != 5 && msg.what != 6 || zzi.this.isConnecting())) {
                zzc zzc2 = (zzc)msg.obj;
                zzc2.zzmb();
                zzc2.unregister();
                return;
            }
            if (msg.what == 3) {
                ConnectionResult connectionResult = new ConnectionResult((Integer)msg.obj, null);
                if (zzi.this.zzTq) {
                    zzi.this.zzTr.zza(connectionResult);
                } else {
                    zzi.this.zzQs.zzj(connectionResult);
                }
                return;
            }
            if (msg.what == 4) {
                zzi.this.zza(4, null);
                zzi.this.zzQs.zzaP((Integer)msg.obj);
                zzi.this.zza(4, 1, null);
                return;
            }
            if (msg.what == 2 && !zzi.this.isConnected()) {
                zzc zzc3 = (zzc)msg.obj;
                zzc3.zzmb();
                zzc3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1 || msg.what == 5 || msg.what == 6) {
                zzc zzc4 = (zzc)msg.obj;
                zzc4.zzmc();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    public final class zze
    implements ServiceConnection {
        public void onServiceConnected(ComponentName component, IBinder binder) {
            zzv.zzb(binder, (Object)"Expecting a valid IBinder");
            zzi.this.zzTp = zzq.zza.zzT(binder);
            zzi.this.zzlV();
        }

        public void onServiceDisconnected(ComponentName component) {
            zzi.this.mHandler.sendMessage(zzi.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

