/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final zze CREATOR = new zze();
    private final int zzzH;
    private final String[] zzRA;
    Bundle zzRB;
    private final CursorWindow[] zzRC;
    private final int zzOJ;
    private final Bundle zzRD;
    int[] zzRE;
    int zzRF;
    boolean mClosed = false;
    private Object zzRG;
    private boolean zzRH = true;
    private static final zza zzRI = new zza(new String[0], null){};

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.zzzH = versionCode;
        this.zzRA = columns;
        this.zzRC = windows;
        this.zzOJ = statusCode;
        this.zzRD = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.zzzH = 1;
        this.zzRA = zzv.zzr(columns);
        this.zzRC = zzv.zzr(windows);
        this.zzOJ = statusCode;
        this.zzRD = metadata;
        this.zzlq();
    }

    public void zzm(Object object) {
        this.zzRG = object;
    }

    private DataHolder(zza builder, int statusCode, Bundle metadata) {
        this(builder.zzRA, DataHolder.zza(builder, -1), statusCode, metadata);
    }

    public void zzlq() {
        int n;
        this.zzRB = new Bundle();
        for (n = 0; n < this.zzRA.length; ++n) {
            this.zzRB.putInt(this.zzRA[n], n);
        }
        this.zzRE = new int[this.zzRC.length];
        n = 0;
        for (int i = 0; i < this.zzRC.length; ++i) {
            this.zzRE[i] = n;
            int n2 = this.zzRC[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzRC[i].getNumRows() - n3;
        }
        this.zzRF = n;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags);
    }

    int getVersionCode() {
        return this.zzzH;
    }

    String[] zzlr() {
        return this.zzRA;
    }

    CursorWindow[] zzls() {
        return this.zzRC;
    }

    public int getStatusCode() {
        return this.zzOJ;
    }

    public Bundle zzlm() {
        return this.zzRD;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzRA.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.zzRJ.size() ? zza2.zzRJ : zza2.zzRJ.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzRA.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzRA.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (int j = 0; j < zza2.zzRA.length && bl2; ++j) {
                    String string2 = zza2.zzRA[j];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, j);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, j);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, j);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, j);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, j);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, j);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, j);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, j);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v);
                }
                if (!bl2) {
                    if (bl) {
                        String string3 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string3);
                    }
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzRA.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzf(String string2, int n) {
        if (this.zzRB == null || !this.zzRB.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzRF) {
            throw new CursorIndexOutOfBoundsException(n, this.zzRF);
        }
    }

    public boolean zzbF(String string2) {
        return this.zzRB.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzf(string2, n);
        return this.zzRC[n2].getLong(n, this.zzRB.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzf(string2, n);
        return this.zzRC[n2].getInt(n, this.zzRB.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzf(string2, n);
        return this.zzRC[n2].getString(n, this.zzRB.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzf(string2, n);
        Long l = this.zzRC[n2].getLong(n, this.zzRB.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzf(string2, n);
        return this.zzRC[n2].getFloat(n, this.zzRB.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzf(string2, n);
        return this.zzRC[n2].getBlob(n, this.zzRB.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzf(string2, n);
        this.zzRC[n2].copyStringToBuffer(n, this.zzRB.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzf(string2, n);
        return this.zzRC[n2].isNull(n, this.zzRB.getInt(string2));
    }

    public int getCount() {
        return this.zzRF;
    }

    public int zzaD(int n) {
        int n2;
        zzv.zzP(n >= 0 && n < this.zzRF);
        for (n2 = 0; n2 < this.zzRE.length; ++n2) {
            if (n >= this.zzRE[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzRE.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzRC.length; ++i) {
                    this.zzRC[i].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.zzRH && this.zzRC.length > 0 && !this.isClosed()) {
                String string2 = this.zzRG == null ? "internal object: " + this.toString() : this.zzRG.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static DataHolder zzaE(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(zzRI, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzRA;
        private final ArrayList<HashMap<String, Object>> zzRJ;
        private final String zzRK;
        private final HashMap<Object, Integer> zzRL;
        private boolean zzRM;
        private String zzRN;

        private zza(String[] stringArray, String string2) {
            this.zzRA = zzv.zzr(stringArray);
            this.zzRJ = new ArrayList();
            this.zzRK = string2;
            this.zzRL = new HashMap();
            this.zzRM = false;
            this.zzRN = null;
        }
    }
}

