/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzv;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzm
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean zzRa;
    private int zzRb = -1;
    private ConnectionResult zzRc;
    private final Handler zzRd = new Handler(Looper.getMainLooper());
    private final SparseArray<zzb> zzRe = new SparseArray();

    public static zzm zzb(FragmentActivity fragmentActivity) {
        zzm zzm2;
        zzv.zzbI("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzm2 = (zzm)fragmentManager.findFragmentByTag("GmsSupportLoaderLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLoaderLifecycleFragment is not a SupportLoaderLifecycleFragment", classCastException);
        }
        if (zzm2 == null || zzm2.isRemoving()) {
            zzm2 = new zzm();
            fragmentManager.beginTransaction().add((Fragment)zzm2, "GmsSupportLoaderLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return zzm2;
    }

    public GoogleApiClient zzay(int n) {
        zza zza2;
        if (this.getActivity() != null && (zza2 = this.zzaz(n)) != null) {
            return zza2.zzRg;
        }
        return null;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzv.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzv.zza(this.zzRe.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zzb zzb2 = new zzb(googleApiClient, onConnectionFailedListener);
        this.zzRe.put(n, (Object)zzb2);
        if (this.getActivity() != null) {
            LoaderManager.enableDebugLogging((boolean)false);
            this.getLoaderManager().initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void zzax(int n) {
        this.zzRe.remove(n);
        this.getLoaderManager().destroyLoader(n);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzRb, new ConnectionResult(13, null));
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i = 0; i < this.zzRe.size(); ++i) {
            int n = this.zzRe.keyAt(i);
            zza zza2 = this.zzaz(n);
            if (zza2 != null) {
                zzb zzb2 = (zzb)this.zzRe.valueAt(i);
                if (zzb2.zzRg != zza2.zzRg) {
                    this.getLoaderManager().restartLoader(n, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzRa = savedInstanceState.getBoolean("resolving_error", false);
            this.zzRb = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzRb >= 0) {
                this.zzRc = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzRa);
        if (this.zzRb >= 0) {
            outState.putInt("failed_client_id", this.zzRb);
            outState.putInt("failed_status", this.zzRc.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzRc.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.zzRa) {
            for (int i = 0; i < this.zzRe.size(); ++i) {
                this.getLoaderManager().initLoader(this.zzRe.keyAt(i), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl = true;
            }
        }
        if (bl) {
            this.zzlg();
        } else {
            this.zza(this.zzRb, this.zzRc);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id, Bundle args) {
        return new zza((Context)this.getActivity(), ((zzb)this.zzRe.get((int)id)).zzRg);
    }

    public void zza(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (!connectionResult.isSuccess()) {
            this.zzb(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
    }

    zza zzaz(int n) {
        try {
            return (zza)this.getLoaderManager().getLoader(n);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLoaderLifecycleFragment", classCastException);
        }
    }

    private void zzb(int n, ConnectionResult connectionResult) {
        if (!this.zzRa) {
            this.zzRa = true;
            this.zzRb = n;
            this.zzRc = connectionResult;
            this.zzRd.post((Runnable)new zzc(n, connectionResult));
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLoaderLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zzb zzb2 = (zzb)this.zzRe.get(n);
        if (zzb2 != null) {
            this.zzax(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zzb2.zzRh;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zzlg();
    }

    private void zzlg() {
        this.zzRa = false;
        this.zzRb = -1;
        this.zzRc = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i = 0; i < this.zzRe.size(); ++i) {
            int n = this.zzRe.keyAt(i);
            zza zza2 = this.zzaz(n);
            if (zza2 == null || !zza2.zzli()) continue;
            loaderManager.destroyLoader(n);
            loaderManager.initLoader(n, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.zza((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class zza
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient zzRg;
        private boolean zzRl;
        private ConnectionResult zzRm;

        public zza(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.zzRg = googleApiClient;
        }

        public boolean zzli() {
            return this.zzRl;
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.zzRg.registerConnectionCallbacks(this);
            this.zzRg.registerConnectionFailedListener(this);
            if (this.zzRm != null) {
                this.deliverResult(this.zzRm);
            }
            if (!(this.zzRg.isConnected() || this.zzRg.isConnecting() || this.zzRl)) {
                this.zzRg.connect();
            }
        }

        protected void onStopLoading() {
            this.zzRg.disconnect();
        }

        protected void onReset() {
            this.zzRm = null;
            this.zzRl = false;
            this.zzRg.unregisterConnectionCallbacks(this);
            this.zzRg.unregisterConnectionFailedListener(this);
            this.zzRg.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.zzRl = false;
            this.zzh(ConnectionResult.zzOI);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.zzRl = true;
            this.zzh(result);
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            this.zzRg.dump(prefix, fd, writer, args);
        }

        private void zzh(ConnectionResult connectionResult) {
            this.zzRm = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class zzb {
        public final GoogleApiClient zzRg;
        public final GoogleApiClient.OnConnectionFailedListener zzRh;

        private zzb(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzRg = googleApiClient;
            this.zzRh = onConnectionFailedListener;
        }
    }

    private class zzc
    implements Runnable {
        private final int zzRj;
        private final ConnectionResult zzRk;

        public zzc(int n, ConnectionResult connectionResult) {
            this.zzRj = n;
            this.zzRk = connectionResult;
        }

        @Override
        public void run() {
            if (this.zzRk.hasResolution()) {
                try {
                    int n = zzm.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzm.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzRk.startResolutionForResult((Activity)zzm.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzm.this.zzlg();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.zzRk.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzRk.getErrorCode(), (Activity)zzm.this.getActivity(), zzm.this, 2, zzm.this);
            } else {
                zzm.this.zza(this.zzRj, this.zzRk);
            }
        }
    }
}

