/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.api.zzm;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.zza, R extends Result, T extends zza.zza<R, A>> T zza(T var1);

    public <A extends Api.zza, T extends zza.zza<? extends Result, A>> T zzb(T var1);

    public <L> zzi<L> zzl(L var1);

    public <C extends Api.zza> C zza(Api.zzc<C> var1);

    public boolean zza(Api<?> var1);

    public boolean hasConnectedApi(Api<?> var1);

    public ConnectionResult getConnectionResult(Api<?> var1);

    public boolean zza(Scope var1);

    public Context getContext();

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public PendingResult<Status> clearDefaultAccountAndReconnect();

    public void stopAutoManage(FragmentActivity var1);

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public int getSessionId();

    public static final class Builder {
        private Account zzJc;
        private final Set<Scope> zzPz = new HashSet<Scope>();
        private int zzPA;
        private View zzPB;
        private String zzPC;
        private String zzPD;
        private final Map<Api<?>, zze.zza> zzPE = new HashMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzPF = new HashMap();
        private FragmentActivity zzPG;
        private int zzPH = -1;
        private int zzPI = -1;
        private OnConnectionFailedListener zzPJ;
        private Looper zzPx;
        private Api.zzb<? extends zzmd, zzme> zzPK;
        private final Set<ConnectionCallbacks> zzPL = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> zzPM = new HashSet<OnConnectionFailedListener>();
        private zzme.zza zzPN = new zzme.zza();

        public Builder(Context context) {
            this.mContext = context;
            this.zzPx = context.getMainLooper();
            this.zzPC = context.getPackageName();
            this.zzPD = context.getClass().getName();
            this.zzPK = zzmb.zzKi;
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            zzv.zzb(connectedListener, (Object)"Must provide a connected listener");
            this.zzPL.add(connectedListener);
            zzv.zzb(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzPM.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            zzv.zzb(handler, (Object)"Handler must not be null");
            this.zzPx = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.zzPL.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.zzPM.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.zzPB = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.zzPz.add(scope);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.zzPF.put(api, null);
            this.zzPz.addAll(api.zzkE());
            return this;
        }

        public Builder addApiIfAvailable(Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopes) {
            this.zzPF.put(api, null);
            this.zza(api, 1, scopes);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            zzv.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzPF.put(api, options);
            this.zzPz.addAll(api.zzkE());
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(Api<O> api, O options, Scope ... scopes) {
            zzv.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzPF.put(api, options);
            this.zza(api, 1, scopes);
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzJc = accountName == null ? null : new Account(accountName, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zzPA = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            zzv.zzb(clientId >= 0, (Object)"clientId must be non-negative");
            this.zzPH = clientId;
            this.zzPG = zzv.zzb(fragmentActivity, (Object)"Null activity is not permitted.");
            this.zzPJ = unresolvedConnectionFailedListener;
            return this;
        }

        public Builder requestServerAuthCode(String serverClientId, ServerAuthCodeCallbacks callbacks) {
            this.zzPN.zza(serverClientId, callbacks);
            return this;
        }

        public zze zzkK() {
            return new zze(this.zzJc, this.zzPz, this.zzPE, this.zzPA, this.zzPB, this.zzPC, this.zzPD, this.zzPN.zzwi());
        }

        public GoogleApiClient build() {
            zzv.zzb(!this.zzPF.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.zzPH >= 0) {
                return this.zzkL();
            }
            if (this.zzPI >= 0) {
                return this.zzkM();
            }
            return new zzg(this.mContext, this.zzPx, this.zzkK(), this.zzPK, this.zzPF, this.zzPL, this.zzPM, -1, -1);
        }

        private GoogleApiClient zzkL() {
            zzl zzl2 = zzl.zza(this.zzPG);
            zzg zzg2 = new zzg(this.mContext.getApplicationContext(), this.zzPx, this.zzkK(), this.zzPK, this.zzPF, this.zzPL, this.zzPM, this.zzPH, -1);
            zzl2.zza(this.zzPH, zzg2, this.zzPJ);
            return zzg2;
        }

        private GoogleApiClient zzkM() {
            zzm zzm2 = zzm.zzb(this.zzPG);
            GoogleApiClient googleApiClient = zzm2.zzay(this.zzPI);
            if (googleApiClient == null) {
                googleApiClient = new zzg(this.mContext.getApplicationContext(), this.zzPx, this.zzkK(), this.zzPK, this.zzPF, this.zzPL, this.zzPM, -1, this.zzPI);
            }
            zzm2.zza(this.zzPI, googleApiClient, this.zzPJ);
            return googleApiClient;
        }

        private void zza(Api<?> api, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException("Invalid resolution mode: '" + n + "', use a constant from GoogleApiClient.ResolutionMode");
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzkE());
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.zzPE.put(api, new zze.zza(hashSet, bl));
        }
    }

    public static interface zza {
        public void zza(ConnectionResult var1);

        public void zzb(ConnectionResult var1);
    }

    public static interface ServerAuthCodeCallbacks {
        public CheckResult onCheckServerAuthorization(String var1, Set<Scope> var2);

        public boolean onUploadServerAuthCode(String var1, String var2);

        public static class CheckResult {
            private boolean zzPO;
            private Set<Scope> zzPP;

            public static CheckResult newAuthNotRequiredResult() {
                return new CheckResult(false, null);
            }

            public static CheckResult newAuthRequiredResult(Set<Scope> requiredScopes) {
                zzv.zzb(requiredScopes != null && !requiredScopes.isEmpty(), (Object)"A non-empty scope set is required if further auth is needed.");
                return new CheckResult(true, requiredScopes);
            }

            private CheckResult(boolean requiresNewAuthCode, Set<Scope> requiredScopes) {
                this.zzPO = requiresNewAuthCode;
                this.zzPP = requiredScopes;
            }

            public boolean zzkN() {
                return this.zzPO;
            }

            public Set<Scope> zzkO() {
                return this.zzPP;
            }
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

