/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.zzv;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractPendingResult<R extends Result>
implements PendingResult<R> {
    private final Object zzPd = new Object();
    protected final CallbackHandler<R> mHandler;
    private final CountDownLatch zzns = new CountDownLatch(1);
    private final ArrayList<PendingResult.BatchCallback> zzPe = new ArrayList();
    private ResultCallback<R> zzPf;
    private volatile R zzPg;
    private volatile boolean zzPh;
    private boolean zzPi;
    private boolean zzPj;
    private ICancelToken zzPk;

    protected AbstractPendingResult(Looper looper) {
        this.mHandler = new CallbackHandler(looper);
    }

    protected AbstractPendingResult(CallbackHandler<R> callbackHandler) {
        this.mHandler = callbackHandler;
    }

    public final boolean isReady() {
        return this.zzns.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzv.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
        zzv.zza(!this.zzPh, (Object)"Result has already been consumed");
        try {
            this.zzns.await();
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.zzQV);
        }
        zzv.zza(this.isReady(), (Object)"Result is not ready.");
        return this.zzkB();
    }

    @Override
    public final R await(long time, TimeUnit units) {
        zzv.zza(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzv.zza(!this.zzPh, (Object)"Result has already been consumed.");
        try {
            boolean bl = this.zzns.await(time, units);
            if (!bl) {
                this.forceFailureUnlessReady(Status.zzQX);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.zzQV);
        }
        zzv.zza(this.isReady(), (Object)"Result is not ready.");
        return this.zzkB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback) {
        zzv.zza(!this.zzPh, (Object)"Result has already been consumed.");
        Object object = this.zzPd;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.mHandler.sendResultCallback(callback, this.zzkB());
            } else {
                this.zzPf = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
        zzv.zza(!this.zzPh, (Object)"Result has already been consumed.");
        zzv.zza(this.mHandler != null, (Object)"CallbackHandler has not been set before calling setResultCallback.");
        Object object = this.zzPd;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.mHandler.sendResultCallback(callback, this.zzkB());
            } else {
                this.zzPf = callback;
                this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addBatchCallback(PendingResult.BatchCallback callback) {
        zzv.zza(!this.zzPh, (Object)"Result has already been consumed.");
        Object object = this.zzPd;
        synchronized (object) {
            if (this.isReady()) {
                callback.zzl(this.zzPg.getStatus());
            } else {
                this.zzPe.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzPd;
        synchronized (object) {
            if (this.zzPi || this.zzPh) {
                return;
            }
            if (this.zzPk != null) {
                try {
                    this.zzPk.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            AbstractPendingResult.zzb(this.zzPg);
            this.zzPf = null;
            this.zzPi = true;
            this.zza(this.createFailedResult(Status.zzQY));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzPd;
        synchronized (object) {
            return this.zzPi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R result) {
        Object object = this.zzPd;
        synchronized (object) {
            if (this.zzPj || this.zzPi) {
                AbstractPendingResult.zzb(result);
                return;
            }
            zzv.zza(!this.isReady(), (Object)"Results have already been set");
            zzv.zza(!this.zzPh, (Object)"Result has already been consumed");
            this.zza(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceFailureUnlessReady(Status status) {
        Object object = this.zzPd;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zzPj = true;
            }
        }
    }

    protected abstract R createFailedResult(Status var1);

    protected void onResultConsumed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setCancelToken(ICancelToken cancelToken) {
        Object object = this.zzPd;
        synchronized (object) {
            this.zzPk = cancelToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R zzkB() {
        R r;
        Object object = this.zzPd;
        synchronized (object) {
            zzv.zza(!this.zzPh, (Object)"Result has already been consumed.");
            zzv.zza(this.isReady(), (Object)"Result is not ready.");
            r = this.zzPg;
            this.zzPg = null;
            this.zzPf = null;
            this.zzPh = true;
        }
        this.onResultConsumed();
        return r;
    }

    private void zza(R r) {
        this.zzPg = r;
        this.zzPk = null;
        this.zzns.countDown();
        Status status = this.zzPg.getStatus();
        if (this.zzPf != null) {
            this.mHandler.removeTimeoutMessages();
            if (!this.zzPi) {
                this.mHandler.sendResultCallback(this.zzPf, this.zzkB());
            }
        }
        for (PendingResult.BatchCallback batchCallback : this.zzPe) {
            batchCallback.zzl(status);
        }
        this.zzPe.clear();
    }

    static void zzb(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"AbstractPendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.forceFailureUnlessReady(Status.zzQX);
                    return;
                }
            }
            Log.wtf((String)"AbstractPendingResult", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                AbstractPendingResult.zzb(result);
                throw runtimeException;
            }
        }
    }
}

