/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.AbstractPendingResult;
import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends AbstractPendingResult<BatchResult> {
    private int zzLW;
    private boolean zzLX;
    private boolean zzLY;
    private final PendingResult<?>[] zzLZ;
    private final Object zznh = new Object();

    private Batch(List<PendingResult<?>> pendingResultList, Looper looper) {
        super(new AbstractPendingResult.CallbackHandler(looper));
        this.zzLW = pendingResultList.size();
        this.zzLZ = new PendingResult[this.zzLW];
        for (int i = 0; i < pendingResultList.size(); ++i) {
            PendingResult<?> pendingResult = pendingResultList.get(i);
            this.zzLZ[i] = pendingResult;
            pendingResult.addBatchCallback(new PendingResult.BatchCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzl(Status status) {
                    Object object = Batch.this.zznh;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzLY = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzLX = true;
                        }
                        Batch.this.zzLW--;
                        if (Batch.this.zzLW == 0) {
                            if (Batch.this.zzLY) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzLX ? new Status(13) : Status.zzNo;
                                Batch.this.setResult(new BatchResult(status2, Batch.this.zzLZ));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzLZ) {
            pendingResult.cancel();
        }
    }

    @Override
    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzLZ);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzMb = new ArrayList();
        private Looper zzMc;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzMc = googleApiClient.getLooper();
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzMb.size());
            this.zzMb.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzMb, this.zzMc);
        }
    }
}

