/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzlu;
import com.google.android.gms.internal.zzme;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;

public final class GooglePlayServicesUtil {
    public static final String GMS_ERROR_DIALOG = "GooglePlayServicesErrorDialog";
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = 7095000;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    public static boolean zzLD = false;
    public static boolean zzLE = false;
    private static int zzLF = -1;
    private static final Object zzLG = new Object();

    private GooglePlayServicesUtil() {
    }

    public static String getErrorString(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
        }
        return "UNKNOWN_ERROR_CODE";
    }

    public static int isGooglePlayServicesAvailable(Context context) {
        ApplicationInfo applicationInfo;
        Resources resources;
        PackageManager packageManager = context.getPackageManager();
        if (!zze.zzPq) {
            try {
                resources = context.getResources();
                resources.getString(R.string.common_google_play_services_unknown_issue);
            }
            catch (Throwable throwable) {
                Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
            }
        }
        if (!zze.zzPq) {
            GooglePlayServicesUtil.zzJ(context);
        }
        try {
            resources = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        zzc zzc2 = zzc.zzhP();
        if (zzlu.zzbd(resources.versionCode) || zzlu.zzQ(context)) {
            if (zzc2.zza((PackageInfo)resources, zzb.zzaq.zzLC) == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                return 9;
            }
        } else {
            PackageInfo packageInfo;
            try {
                packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 64);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is missing.");
                return 9;
            }
            zzb.zza zza2 = zzc2.zza(packageInfo, zzb.zzaq.zzLC);
            if (zza2 == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
                return 9;
            }
            if (zzc2.zza((PackageInfo)resources, zza2) == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                return 9;
            }
        }
        int n = zzlu.zzbb(7095000);
        int n2 = zzlu.zzbb(resources.versionCode);
        if (n2 < n) {
            Log.w((String)"GooglePlayServicesUtil", (String)("Google Play services out of date.  Requires 7095000 but found " + resources.versionCode));
            return 2;
        }
        try {
            applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.");
            nameNotFoundException.printStackTrace();
            return 1;
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    public static void zzI(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        if (n != 0) {
            Intent intent = GooglePlayServicesUtil.zzan(n);
            Log.e((String)"GooglePlayServicesUtil", (String)("GooglePlayServices not available due to error " + n));
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            throw new GooglePlayServicesRepairableException(n, "Google Play Services not available", intent);
        }
    }

    private static void zzJ(Context context) {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"GooglePlayServicesUtil", (String)"This should never happen.", (Throwable)nameNotFoundException);
        }
        Bundle bundle = applicationInfo.metaData;
        if (bundle != null) {
            int n = bundle.getInt("com.google.android.gms.version");
            if (n == 7095000) {
                return;
            }
            throw new IllegalStateException("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected 7095000 but found " + n + ".  You must have the" + " following declaration within the <application> element: " + "    <meta-data android:name=\"" + "com.google.android.gms.version" + "\" android:value=\"@integer/google_play_services_version\" />");
        }
        throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
    }

    public static boolean zzd(Context context, int n) {
        return GooglePlayServicesUtil.zza(context, n, GOOGLE_PLAY_SERVICES_PACKAGE) && GooglePlayServicesUtil.zzb(context.getPackageManager(), GOOGLE_PLAY_SERVICES_PACKAGE);
    }

    public static boolean zza(Context context, int n, String string2) {
        if (zzme.zzkj()) {
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
            try {
                appOpsManager.checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        PackageManager packageManager = context.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean zzb(PackageManager packageManager, String string2) {
        return zzc.zzhP().zzb(packageManager, string2);
    }

    public static Intent zzan(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return zzo.zzbl(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
            case 42: {
                return zzo.zzjl();
            }
            case 3: {
                return zzo.zzbj(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
        }
        return null;
    }

    public static boolean zzhO() {
        if (zzLD) {
            return zzLE;
        }
        return "user".equals(Build.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzb(PackageManager packageManager) {
        Object object = zzLG;
        synchronized (object) {
            if (zzLF == -1) {
                try {
                    PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                    zzLF = zzc.zzhP().zza(packageInfo, zzb.zzLv[1]) != null ? 1 : 0;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzLF = 0;
                }
            }
        }
        return zzLF != 0;
    }

    public static boolean zzc(PackageManager packageManager) {
        return GooglePlayServicesUtil.zzb(packageManager) || !GooglePlayServicesUtil.zzhO();
    }

    public static String zze(Context context, int n) {
        String string2;
        Resources resources = context.getResources();
        switch (n) {
            case 1: {
                String string3 = GooglePlayServicesUtil.zza(context.getResources()) ? resources.getString(R.string.common_google_play_services_install_text_tablet) : resources.getString(R.string.common_google_play_services_install_text_phone);
                string2 = string3;
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_enable_text);
                break;
            }
            case 2: {
                string2 = resources.getString(R.string.common_google_play_services_update_text);
                break;
            }
            case 42: {
                string2 = resources.getString(R.string.common_android_wear_update_text);
                break;
            }
            case 9: {
                string2 = resources.getString(R.string.common_google_play_services_unsupported_text);
                break;
            }
            case 7: {
                string2 = resources.getString(R.string.common_google_play_services_network_error_text);
                break;
            }
            case 5: {
                string2 = resources.getString(R.string.common_google_play_services_invalid_account_text);
                break;
            }
            case 16: {
                string2 = resources.getString(R.string.commono_google_play_services_api_unavailable_text);
                break;
            }
            case 17: {
                string2 = resources.getString(R.string.common_google_play_services_sign_in_failed_text);
                break;
            }
            default: {
                string2 = resources.getString(R.string.common_google_play_services_unknown_issue);
            }
        }
        return string2;
    }

    public static String zzf(Context context, int n) {
        String string2;
        Resources resources = context.getResources();
        switch (n) {
            case 1: {
                string2 = resources.getString(R.string.common_google_play_services_install_button);
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_enable_button);
                break;
            }
            case 2: 
            case 42: {
                string2 = resources.getString(R.string.common_google_play_services_update_button);
                break;
            }
            default: {
                string2 = resources.getString(17039370);
            }
        }
        return string2;
    }

    protected static int getErrorNotificationId(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 3: {
                return 10436;
            }
        }
        return 39789;
    }

    public static String zzg(Context context, int n) {
        String string2;
        Resources resources = context.getResources();
        switch (n) {
            case 1: {
                string2 = resources.getString(R.string.common_google_play_services_notification_needs_installation_title);
                break;
            }
            case 2: {
                string2 = resources.getString(R.string.common_google_play_services_notification_needs_update_title);
                break;
            }
            case 42: {
                string2 = resources.getString(R.string.common_android_wear_notification_needs_update_text);
                break;
            }
            case 3: {
                string2 = resources.getString(R.string.common_google_play_services_needs_enabling_title);
                break;
            }
            case 9: {
                string2 = resources.getString(R.string.common_google_play_services_unsupported_text);
                break;
            }
            case 7: {
                string2 = resources.getString(R.string.common_google_play_services_network_error_text);
                break;
            }
            case 5: {
                string2 = resources.getString(R.string.common_google_play_services_invalid_account_text);
                break;
            }
            case 16: {
                string2 = resources.getString(R.string.commono_google_play_services_api_unavailable_text);
                break;
            }
            case 17: {
                string2 = resources.getString(R.string.common_google_play_services_sign_in_failed_text);
                break;
            }
            default: {
                string2 = resources.getString(R.string.common_google_play_services_unknown_issue);
            }
        }
        return string2;
    }

    public static PendingIntent getErrorPendingIntent(int errorCode, Context context, int requestCode) {
        Intent intent = GooglePlayServicesUtil.zzan(errorCode);
        if (intent == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)0x10000000);
    }

    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.getErrorDialog(errorCode, activity, requestCode, null);
    }

    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.zza(errorCode, activity, null, requestCode, cancelListener);
    }

    private static Dialog zza(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Object object;
        TypedValue typedValue;
        if (zzlu.zzQ((Context)activity) && n == 2) {
            n = 42;
        }
        AlertDialog.Builder builder = null;
        if (zzme.zzkg()) {
            typedValue = new TypedValue();
            activity.getTheme().resolveAttribute(16843529, typedValue, true);
            object = activity.getResources().getResourceEntryName(typedValue.resourceId);
            if ("Theme.Dialog.Alert".equals(object)) {
                builder = new AlertDialog.Builder((Context)activity, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder((Context)activity);
        }
        builder.setMessage((CharSequence)GooglePlayServicesUtil.zze((Context)activity, n));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        typedValue = GooglePlayServicesUtil.zzan(n);
        object = fragment == null ? new zzg(activity, (Intent)typedValue, n2) : new zzg(fragment, (Intent)typedValue, n2);
        String string2 = GooglePlayServicesUtil.zzf((Context)activity, n);
        if (string2 != null) {
            builder.setPositiveButton((CharSequence)string2, (DialogInterface.OnClickListener)object);
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 4: 
            case 6: {
                return builder.create();
            }
            case 1: {
                return builder.setTitle(R.string.common_google_play_services_install_title).create();
            }
            case 3: {
                return builder.setTitle(R.string.common_google_play_services_enable_title).create();
            }
            case 2: {
                return builder.setTitle(R.string.common_google_play_services_update_title).create();
            }
            case 42: {
                return builder.setTitle(R.string.common_android_wear_update_title).create();
            }
            case 9: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Google Play services is invalid. Cannot recover.");
                return builder.setTitle(R.string.common_google_play_services_unsupported_title).create();
            }
            case 7: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Network error occurred. Please retry request later.");
                return builder.setTitle(R.string.common_google_play_services_network_error_title).create();
            }
            case 8: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Internal error occurred. Please see logs for detailed information");
                return builder.create();
            }
            case 10: {
                Log.e((String)"GooglePlayServicesUtil", (String)"Developer error occurred. Please see logs for detailed information");
                return builder.create();
            }
            case 5: {
                Log.e((String)"GooglePlayServicesUtil", (String)"An invalid account was specified when connecting. Please provide a valid account.");
                return builder.setTitle(R.string.common_google_play_services_invalid_account_title).create();
            }
            case 11: {
                Log.e((String)"GooglePlayServicesUtil", (String)"The application is not licensed to the user.");
                return builder.create();
            }
            case 16: {
                Log.e((String)"GooglePlayServicesUtil", (String)"One of the API components you attempted to connect to is not available.");
                return builder.create();
            }
            case 17: {
                Log.e((String)"GooglePlayServicesUtil", (String)"The specified account could not be signed in.");
                return builder.setTitle(R.string.common_google_play_services_sign_in_failed_title).create();
            }
        }
        Log.e((String)"GooglePlayServicesUtil", (String)("Unexpected error code " + n));
        return builder.create();
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, null, requestCode, cancelListener);
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, Fragment fragment, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        boolean bl;
        Dialog dialog = GooglePlayServicesUtil.zza(errorCode, activity, fragment, requestCode, cancelListener);
        if (dialog == null) {
            return false;
        }
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, cancelListener);
            supportErrorDialogFragment.show(fragmentManager, GMS_ERROR_DIALOG);
        } else if (zzme.zzkd()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, cancelListener);
            errorDialogFragment.show(fragmentManager, GMS_ERROR_DIALOG);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
        return true;
    }

    public static void showErrorNotification(int errorCode, Context context) {
        if (zzlu.zzQ(context) && errorCode == 2) {
            errorCode = 42;
        }
        if (GooglePlayServicesUtil.zzh(context, errorCode) || GooglePlayServicesUtil.zzi(context, errorCode)) {
            GooglePlayServicesUtil.zzK(context);
        } else {
            GooglePlayServicesUtil.zza(errorCode, context);
        }
    }

    private static void zzK(Context context) {
        zza zza2 = new zza(context);
        zza2.sendMessageDelayed(zza2.obtainMessage(1), 120000L);
    }

    private static void zza(int n, Context context) {
        GooglePlayServicesUtil.zza(n, context, null);
    }

    private static void zza(int n, Context context, String string2) {
        Notification notification;
        String string3;
        Resources resources = context.getResources();
        String string4 = GooglePlayServicesUtil.zzg(context, n);
        String string5 = resources.getString(R.string.common_google_play_services_error_notification_requested_by_msg, new Object[]{GooglePlayServicesUtil.zzM(context)});
        PendingIntent pendingIntent = GooglePlayServicesUtil.getErrorPendingIntent(n, context, 0);
        if (zzlu.zzQ(context)) {
            zzx.zzN(zzme.zzkh());
            string3 = new Notification.Builder(context).setSmallIcon(R.drawable.common_ic_googleplayservices).setPriority(2).setAutoCancel(true).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)(string4 + " " + string5))).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = string3.build();
        } else {
            string3 = resources.getString(R.string.common_google_play_services_notification_ticker);
            notification = new Notification(17301642, (CharSequence)string3, System.currentTimeMillis());
            notification.flags |= 0x10;
            if (Build.VERSION.SDK_INT >= 21) {
                notification.flags |= 0x100;
            } else if (Build.VERSION.SDK_INT >= 19) {
                notification.extras.putBoolean("android.support.localOnly", true);
            }
            notification.setLatestEventInfo(context, (CharSequence)string4, (CharSequence)string5, pendingIntent);
        }
        string3 = (NotificationManager)context.getSystemService("notification");
        if (string2 != null) {
            string3.notify(string2, GooglePlayServicesUtil.getErrorNotificationId(n), notification);
        } else {
            string3.notify(GooglePlayServicesUtil.getErrorNotificationId(n), notification);
        }
    }

    public static void zzL(Context context) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(10436);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, requestCode, null);
    }

    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        String string2;
        block9: {
            Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("oss_notice").build();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            try {
                string2 = new Scanner(inputStream).useDelimiter("\\A").next();
                if (inputStream == null) break block9;
            }
            catch (NoSuchElementException noSuchElementException) {
                String string3;
                block10: {
                    try {
                        string3 = null;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return string3;
            }
            inputStream.close();
        }
        return string2;
    }

    public static boolean zza(Resources resources) {
        if (resources == null) {
            return false;
        }
        boolean bl = (resources.getConfiguration().screenLayout & 0xF) > 3;
        return zzme.zzkd() && bl || GooglePlayServicesUtil.zzb(resources);
    }

    private static boolean zzb(Resources resources) {
        Configuration configuration = resources.getConfiguration();
        if (zzme.zzkf()) {
            return (configuration.screenLayout & 0xF) <= 3 && configuration.smallestScreenWidthDp >= 600;
        }
        return false;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static String zzM(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ApplicationInfo applicationInfo;
            string2 = context.getPackageName();
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                string2 = packageManager.getApplicationLabel(applicationInfo).toString();
            }
        }
        return string2;
    }

    public static boolean zzh(Context context, int n) {
        if (n == 1) {
            return GooglePlayServicesUtil.zzg(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    public static boolean zzi(Context context, int n) {
        if (n == 9) {
            return GooglePlayServicesUtil.zzg(context, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    private static boolean zzg(Context context, String string2) {
        if (zzme.zzkl()) {
            List list = context.getPackageManager().getPackageInstaller().getAllSessions();
            for (PackageInstaller.SessionInfo sessionInfo : list) {
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        } else {
            PackageManager packageManager = context.getPackageManager();
            try {
                if (packageManager.getApplicationInfo((String)string2, (int)8192).enabled) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private static class zza
    extends Handler {
        private final Context zznk;

        zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zznk = context.getApplicationContext();
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.zznk);
                    if (!GooglePlayServicesUtil.isUserRecoverableError(n)) break;
                    GooglePlayServicesUtil.zza(n, this.zznk);
                    break;
                }
                default: {
                    Log.w((String)"GooglePlayServicesUtil", (String)("Don't know how to handle this message: " + msg.what));
                }
            }
        }
    }
}

