/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

@KeepForSdk
public class DataBufferIterator<T>
implements Iterator<T> {
    @NonNull
    protected final DataBuffer zaa;
    protected int zab;

    @Override
    @NonNull
    public Object next() {
        if (!this.hasNext()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot advance the iterator beyond ");
            stringBuilder.append(this.zab);
            throw new NoSuchElementException(stringBuilder.toString());
        }
        return this.zaa.get(++this.zab);
    }

    public DataBufferIterator(@NonNull DataBuffer dataBuffer) {
        this.zaa = (DataBuffer)Preconditions.checkNotNull((Object)dataBuffer);
        this.zab = -1;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a DataBufferIterator");
    }

    @Override
    public final boolean hasNext() {
        DataBuffer dataBuffer = this.zaa;
        return this.zab < dataBuffer.getCount() + -1;
    }
}

