/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.zaad;
import com.google.android.gms.common.api.internal.zaae;
import com.google.android.gms.common.api.internal.zabm;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zac;
import com.google.android.gms.common.api.internal.zaci;
import com.google.android.gms.common.api.internal.zact;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zal;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class zabq
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zau {
    private final Queue zab = new LinkedList();
    @NotOnlyInitialized
    private final Api.Client zac;
    private final ApiKey zad;
    private final zaad zae;
    private final Set zaf = new HashSet();
    private final Map zag = new HashMap();
    private final int zah;
    @Nullable
    private final zact zai;
    private boolean zaj;
    private final List zak = new ArrayList();
    @Nullable
    private ConnectionResult zal = null;
    private int zam = 0;
    final /* synthetic */ GoogleApiManager zaa;

    public final int zab() {
        return this.zah;
    }

    @WorkerThread
    final int zac() {
        return this.zam;
    }

    @WorkerThread
    @Nullable
    public final ConnectionResult zad() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        return this.zal;
    }

    @WorkerThread
    @Nullable
    private final Feature zaC(@Nullable Feature[] featureArray) {
        if (featureArray == null || featureArray.length == 0) {
            return null;
        }
        Feature[] featureArray2 = featureArray2.zac.getAvailableFeatures();
        if (featureArray2 == null) {
            featureArray2 = new Feature[]{};
        }
        ArrayMap arrayMap = new ArrayMap(featureArray2.length);
        for (int i = 0; i < featureArray2.length; ++i) {
            Feature feature = featureArray2[i];
            arrayMap.put(feature.getName(), feature.getVersion());
        }
        for (Feature feature : featureArray) {
            Long l = (Long)arrayMap.get(feature.getName());
            if (l != null && l >= feature.getVersion()) continue;
            return feature;
        }
        return null;
    }

    static /* bridge */ /* synthetic */ Api.Client zae(zabq zabq2) {
        return zabq2.zac;
    }

    public final Api.Client zaf() {
        return this.zac;
    }

    static /* bridge */ /* synthetic */ ApiKey zag(zabq zabq2) {
        return zabq2.zad;
    }

    public final Map zah() {
        return this.zag;
    }

    static /* bridge */ /* synthetic */ void zai(zabq zabq2, Status status) {
        zabq2.zaE(status);
    }

    static /* bridge */ /* synthetic */ void zaj(zabq zabq2) {
        zabq2.zaH();
    }

    static /* bridge */ /* synthetic */ void zak(zabq zabq2, int n) {
        zabq2.zaI(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zal(zabq zabq2, zabs zabs2) {
        if (!zabq2.zak.contains(zabs2) || zabq2.zaj) {
            return;
        }
        if (!zabq2.zac.isConnected()) {
            zabq2.zao();
            return;
        }
        zabq2.zaG();
    }

    static /* bridge */ /* synthetic */ void zam(zabq zabq2, zabs iterator) {
        if (zabq2.zak.remove(iterator)) {
            Object[] objectArray;
            GoogleApiManager.zad(zabq2.zaa).removeMessages(15, (Object)iterator);
            GoogleApiManager.zad(zabq2.zaa).removeMessages(16, (Object)iterator);
            Feature feature = zabs.zaa((zabs)((Object)iterator));
            iterator = zabq2.zab;
            ArrayList<zai> arrayList = new ArrayList<zai>(iterator.size());
            for (zai zai2 : zabq2.zab) {
                if (!(zai2 instanceof zac) || (objectArray = ((zac)zai2).zab(zabq2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                arrayList.add(zai2);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                objectArray = (zai)arrayList.get(i);
                zabq2.zab.remove(objectArray);
                objectArray.zae((Exception)new UnsupportedApiCallException(feature));
            }
        }
    }

    @WorkerThread
    public zabq(GoogleApiManager googleApiManager, GoogleApi googleApi) {
        this.zaa = googleApiManager;
        this.zac = googleApi.zab(GoogleApiManager.zad(googleApiManager).getLooper(), this);
        this.zad = googleApi.getApiKey();
        this.zae = new zaad();
        this.zah = googleApi.zaa();
        if (this.zac.requiresSignIn()) {
            this.zai = googleApi.zac(GoogleApiManager.zac(googleApiManager), GoogleApiManager.zad(googleApiManager));
            return;
        }
        this.zai = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaD(ConnectionResult connectionResult) {
        Iterator iterator = this.zaf.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zaf.clear();
                return;
            }
            zal zal2 = (zal)iterator.next();
            String string2 = Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS) ? this.zac.getEndpointPackageName() : null;
            zal2.zac(this.zad, connectionResult, string2);
        }
    }

    @WorkerThread
    public final void zan() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zal = null;
    }

    @WorkerThread
    public final void zao() {
        Object object;
        block7: {
            int n;
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
            if (this.zac.isConnected() || this.zac.isConnecting()) {
                return;
            }
            try {
                GoogleApiManager googleApiManager = this.zaa;
                object = GoogleApiManager.zal(googleApiManager);
                n = ((com.google.android.gms.common.internal.zal)object).zab(GoogleApiManager.zac(googleApiManager), this.zac);
                if (n == 0) break block7;
            }
            catch (IllegalStateException illegalStateException) {
                this.zar(new ConnectionResult(10), illegalStateException);
                return;
            }
            object = new ConnectionResult(n, null);
            String string2 = this.zac.getClass().getName();
            String string3 = object.toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The service for ");
            stringBuilder.append(string2);
            stringBuilder.append(" is not available: ");
            stringBuilder.append(string3);
            Log.w((String)"GoogleApiManager", (String)stringBuilder.toString());
            this.zar((ConnectionResult)object, null);
            return;
        }
        GoogleApiManager googleApiManager = this.zaa;
        object = this.zac;
        ApiKey apiKey = this.zad;
        zabu zabu2 = new zabu(googleApiManager, (Api.Client)object, apiKey);
        if (object.requiresSignIn()) {
            ((zact)Preconditions.checkNotNull((Object)this.zai)).zae(zabu2);
        }
        try {
            this.zac.connect(zabu2);
            return;
        }
        catch (SecurityException securityException) {
            this.zar(new ConnectionResult(10), securityException);
            return;
        }
    }

    @WorkerThread
    public final void zap(zai zai2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (this.zac.isConnected()) {
            if (this.zaM(zai2)) {
                this.zaJ();
                return;
            }
            this.zab.add(zai2);
            return;
        }
        this.zab.add(zai2);
        zai2 = this.zal;
        if (zai2 != null && zai2.hasResolution()) {
            zabq zabq2 = this;
            zabq2.zar(zabq2.zal, null);
            return;
        }
        this.zao();
    }

    @WorkerThread
    private final void zaE(Status status) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaF(status, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaF(@Nullable Status status, @Nullable Exception exception, boolean bl) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(((zabq)((Object)iterator)).zaa));
        boolean bl2 = status == null;
        boolean bl3 = exception == null;
        if (bl2 == bl3) {
            throw new IllegalArgumentException("Status XOR exception should be null");
        }
        Iterator iterator = ((zabq)((Object)iterator)).zab.iterator();
        while (iterator.hasNext()) {
            zai zai2 = (zai)iterator.next();
            if (bl && zai2.zac != 2) continue;
            if (status != null) {
                zai2.zad(status);
            } else {
                zai2.zae(exception);
            }
            iterator.remove();
        }
        return;
    }

    @WorkerThread
    private final void zaG() {
        ArrayList arrayList = new ArrayList(this.zab);
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            zai zai2;
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    zai2 = (zai)arrayList.get(n2);
                    if (this.zac.isConnected()) break block6;
                }
                return;
            }
            if (this.zaM(zai2)) {
                this.zab.remove(zai2);
            }
            ++n2;
        }
    }

    @WorkerThread
    final void zaq() {
        ++this.zam;
    }

    @Override
    public final void onConnected(@Nullable Bundle object) {
        object = this.zaa;
        if (Looper.myLooper() == GoogleApiManager.zad((GoogleApiManager)object).getLooper()) {
            this.zaH();
            return;
        }
        GoogleApiManager.zad(this.zaa).post((Runnable)new zabm(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zaH() {
        this.zan();
        this.zaD(ConnectionResult.RESULT_SUCCESS);
        this.zaL();
        Iterator iterator = this.zag.values().iterator();
        while (iterator.hasNext()) {
            zaci zaci2 = (zaci)iterator.next();
            if (this.zaC(zaci2.zaa.getRequiredFeatures()) != null) {
                iterator.remove();
                continue;
            }
            try {
                zaci2.zaa.registerListener(this.zac, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(3);
                this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                break;
            }
            catch (RemoteException remoteException) {
                iterator.remove();
            }
        }
        this.zaG();
        this.zaJ();
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zar(connectionResult, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zar(@NonNull ConnectionResult object, @Nullable Exception exception) {
        void var2_3;
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(((zabq)((Object)apiKey)).zaa));
        Object object2 = ((zabq)((Object)apiKey)).zai;
        if (object2 != null) {
            ((zact)object2).zaf();
        }
        ((zabq)((Object)apiKey)).zan();
        GoogleApiManager.zal(((zabq)((Object)apiKey)).zaa).zac();
        ((zabq)((Object)apiKey)).zaD((ConnectionResult)object);
        if (((zabq)((Object)apiKey)).zac instanceof zap && object.getErrorCode() != 24) {
            GoogleApiManager.zat(((zabq)((Object)apiKey)).zaa, true);
            object2 = ((zabq)((Object)apiKey)).zaa;
            GoogleApiManager.zad((GoogleApiManager)object2).sendMessageDelayed(GoogleApiManager.zad((GoogleApiManager)object2).obtainMessage(19), 300000L);
        }
        if (object.getErrorCode() == 4) {
            ((zabq)((Object)apiKey)).zaE(GoogleApiManager.zaf());
            return;
        }
        if (((zabq)((Object)apiKey)).zab.isEmpty()) {
            ((zabq)((Object)apiKey)).zal = object;
            return;
        }
        if (var2_3 != null) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(((zabq)((Object)apiKey)).zaa));
            ((zabq)((Object)apiKey)).zaF(null, (Exception)var2_3, false);
            return;
        }
        if (!GoogleApiManager.zaC(((zabq)((Object)apiKey)).zaa)) {
            zabq zabq2 = apiKey;
            zabq2.zaE(GoogleApiManager.zag(zabq2.zad, object));
            return;
        }
        zabq zabq3 = apiKey;
        zabq3.zaF(GoogleApiManager.zag(zabq3.zad, object), null, true);
        if (((zabq)((Object)apiKey)).zab.isEmpty() || ((zabq)((Object)apiKey)).zaN((ConnectionResult)object) || ((zabq)((Object)apiKey)).zaa.zaE((ConnectionResult)object, ((zabq)((Object)apiKey)).zah)) {
            return;
        }
        if (object.getErrorCode() == 18) {
            ((zabq)((Object)apiKey)).zaj = true;
        }
        if (((zabq)((Object)apiKey)).zaj) {
            GoogleApiManager googleApiManager = ((zabq)((Object)apiKey)).zaa;
            ApiKey apiKey = ((zabq)((Object)apiKey)).zad;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)9, (Object)apiKey), 5000L);
            return;
        }
        zabq zabq4 = apiKey;
        zabq4.zaE(GoogleApiManager.zag(zabq4.zad, object));
    }

    @Override
    public final void zaa(ConnectionResult connectionResult, Api api, boolean bl) {
        throw null;
    }

    @Override
    public final void onConnectionSuspended(int n) {
        GoogleApiManager googleApiManager = this.zaa;
        if (Looper.myLooper() == GoogleApiManager.zad(googleApiManager).getLooper()) {
            this.zaI(n);
            return;
        }
        GoogleApiManager.zad(this.zaa).post((Runnable)new zabn(this, n));
    }

    @WorkerThread
    private final void zaI(int n) {
        ((zabq)((Object)iterator)).zan();
        ((zabq)((Object)iterator)).zaj = true;
        Object object = ((zabq)((Object)iterator)).zac.getLastDisconnectMessage();
        ((zabq)((Object)iterator)).zae.zae(n, (String)object);
        ApiKey apiKey = ((zabq)((Object)iterator)).zad;
        object = ((zabq)((Object)iterator)).zaa;
        GoogleApiManager.zad((GoogleApiManager)object).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad((GoogleApiManager)object), (int)9, (Object)apiKey), 5000L);
        apiKey = ((zabq)((Object)iterator)).zad;
        object = ((zabq)((Object)iterator)).zaa;
        GoogleApiManager.zad((GoogleApiManager)object).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad((GoogleApiManager)object), (int)11, (Object)apiKey), 120000L);
        GoogleApiManager.zal(((zabq)((Object)iterator)).zaa).zac();
        Iterator iterator = ((zabq)((Object)iterator)).zag.values().iterator();
        while (iterator.hasNext()) {
            ((zaci)iterator.next()).zac.run();
        }
    }

    @WorkerThread
    public final void zas(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        Api.Client client = this.zac;
        String string2 = client.getClass().getName();
        String string3 = String.valueOf(connectionResult);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("onSignInFailed for ");
        stringBuilder.append(string2);
        stringBuilder.append(" with ");
        stringBuilder.append(string3);
        client.disconnect(stringBuilder.toString());
        this.zar(connectionResult, null);
    }

    @WorkerThread
    public final void zat(zal zal2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaf.add(zal2);
    }

    private final void zaJ() {
        ApiKey apiKey = this.zad;
        GoogleApiManager.zad(this.zaa).removeMessages(12, (Object)apiKey);
        apiKey = this.zad;
        GoogleApiManager googleApiManager = this.zaa;
        GoogleApiManager.zad(googleApiManager).sendMessageDelayed(GoogleApiManager.zad(googleApiManager).obtainMessage(12, (Object)apiKey), GoogleApiManager.zab(this.zaa));
    }

    @WorkerThread
    public final void zau() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (this.zaj) {
            this.zao();
            return;
        }
    }

    @WorkerThread
    private final void zaK(zai zai2) {
        zai2.zag(this.zae, this.zaA());
        try {
            zai2.zaf(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
            return;
        }
    }

    @WorkerThread
    public final void zav() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaE(GoogleApiManager.zaa);
        this.zae.zaf();
        for (ListenerHolder.ListenerKey listenerKey : this.zag.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
            this.zap(new zah(listenerKey, new TaskCompletionSource()));
        }
        this.zaD(new ConnectionResult(4));
        if (this.zac.isConnected()) {
            this.zac.onUserSignOut(new zabp(this));
            return;
        }
    }

    @WorkerThread
    private final void zaL() {
        if (this.zaj) {
            ApiKey apiKey = this.zad;
            GoogleApiManager.zad(this.zaa).removeMessages(11, (Object)apiKey);
            apiKey = this.zad;
            GoogleApiManager.zad(this.zaa).removeMessages(9, (Object)apiKey);
            this.zaj = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zaw() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (!this.zaj) {
            return;
        }
        this.zaL();
        Object object = this.zaa;
        if (GoogleApiManager.zae((GoogleApiManager)object).isGooglePlayServicesAvailable(GoogleApiManager.zac((GoogleApiManager)object)) == 18) {
            object = "Connection timed out waiting for Google Play services update to complete.";
            object = new Status(21, (String)object);
        } else {
            object = "API failed to connect while resuming due to an unknown error.";
            object = new Status(22, (String)object);
        }
        this.zaE((Status)object);
        this.zac.disconnect("Timing out connection while resuming.");
    }

    static /* bridge */ /* synthetic */ boolean zax(zabq zabq2) {
        return zabq2.zaj;
    }

    static /* bridge */ /* synthetic */ boolean zay(zabq zabq2, boolean bl) {
        return zabq2.zaO(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final boolean zaM(zai object) {
        StringBuilder stringBuilder;
        if (!(object instanceof zac)) {
            ((zabq)((Object)googleApiManager)).zaK((zai)object);
            return true;
        }
        Object object2 = (zac)object;
        zabq zabq2 = googleApiManager;
        Feature feature = zabq2.zaC(((zac)object2).zab(zabq2));
        if (feature == null) {
            ((zabq)((Object)googleApiManager)).zaK((zai)object);
            return true;
        }
        object = ((zabq)((Object)googleApiManager)).zac.getClass().getName();
        String string2 = feature.getName();
        long l = feature.getVersion();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder2.append((String)object);
        StringBuilder stringBuilder3 = stringBuilder;
        stringBuilder3.append(" could not execute call because it requires feature (");
        stringBuilder3.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(l);
        stringBuilder.append(").");
        object = stringBuilder.toString();
        Log.w((String)"GoogleApiManager", (String)object);
        if (GoogleApiManager.zaC(((zabq)((Object)googleApiManager)).zaa) && ((zac)object2).zaa((zabq)((Object)googleApiManager))) {
            object = ((zabq)((Object)googleApiManager)).zad;
            object2 = new zabs((ApiKey)object, feature, null);
            int n = ((zabq)((Object)googleApiManager)).zak.indexOf(object2);
            if (n >= 0) {
                zabs zabs2 = (zabs)((zabq)((Object)googleApiManager)).zak.get(n);
                GoogleApiManager.zad(((zabq)((Object)googleApiManager)).zaa).removeMessages(15, (Object)zabs2);
                GoogleApiManager googleApiManager = ((zabq)((Object)googleApiManager)).zaa;
                GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)15, (Object)zabs2), 5000L);
                return false;
            }
            ((zabq)((Object)googleApiManager)).zak.add(object2);
            GoogleApiManager googleApiManager = ((zabq)((Object)googleApiManager)).zaa;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)15, (Object)object2), 5000L);
            googleApiManager = ((zabq)((Object)googleApiManager)).zaa;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)16, (Object)object2), 120000L);
            googleApiManager = new ConnectionResult(2, null);
            if (super.zaN((ConnectionResult)googleApiManager)) return false;
            ((zabq)((Object)googleApiManager)).zaa.zaE((ConnectionResult)googleApiManager, ((zabq)((Object)googleApiManager)).zah);
            return false;
        }
        ((zai)object2).zae((Exception)new UnsupportedApiCallException(feature));
        return true;
    }

    final boolean zaz() {
        return this.zac.isConnected();
    }

    public final boolean zaA() {
        return this.zac.requiresSignIn();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zaN(@NonNull ConnectionResult connectionResult) {
        Object object = GoogleApiManager.zaq();
        synchronized (object) {
            GoogleApiManager googleApiManager = this.zaa;
            zaae zaae2 = GoogleApiManager.zah(googleApiManager);
            if (zaae2 == null) return false;
            boolean bl = GoogleApiManager.zas(googleApiManager).contains(this.zad);
            if (!bl) return false;
            GoogleApiManager.zah(this.zaa).zah(connectionResult, this.zah);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @ResultIgnorabilityUnspecified
    @WorkerThread
    public final boolean zaB() {
        return this.zaO(true);
    }

    @WorkerThread
    private final boolean zaO(boolean bl) {
        block5: {
            block4: {
                Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
                if (!this.zac.isConnected() || !this.zag.isEmpty()) break block4;
                if (!this.zae.zag()) break block5;
                if (bl) {
                    this.zaJ();
                }
            }
            return false;
        }
        this.zac.disconnect("Timing out service connection.");
        return true;
    }
}

