/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

@KeepForSdk
public class ListenerHolders {
    private final Set zaa = Collections.newSetFromMap(new WeakHashMap());

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <L> ListenerHolder.ListenerKey<L> createListenerKey(@NonNull L listener, @NonNull String listenerType) {
        L l;
        void var1_1;
        Preconditions.checkNotNull(listener, (Object)"Listener must not be null");
        Preconditions.checkNotNull((Object)var1_1, (Object)"Listener type must not be null");
        Preconditions.checkNotEmpty((String)var1_1, (Object)"Listener type must not be empty");
        return new ListenerHolder.ListenerKey<L>(l, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <L> ListenerHolder<L> createListenerHolder(@NonNull L listener, @NonNull Looper looper, @NonNull String listenerType) {
        L l;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listener, (Object)"Listener must not be null");
        Preconditions.checkNotNull((Object)var1_1, (Object)"Looper must not be null");
        Preconditions.checkNotNull((Object)var2_2, (Object)"Listener type must not be null");
        return new ListenerHolder<L>((Looper)var1_1, l, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <L> ListenerHolder<L> createListenerHolder(@NonNull L listener, @NonNull Executor executor, @NonNull String listenerType) {
        L l;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listener, (Object)"Listener must not be null");
        Preconditions.checkNotNull((Object)var1_1, (Object)"Executor must not be null");
        Preconditions.checkNotNull((Object)var2_2, (Object)"Listener type must not be null");
        return new ListenerHolder<L>((Executor)var1_1, l, (String)var2_2);
    }

    @NonNull
    public final ListenerHolder zaa(@NonNull Object listenerHolder, @NonNull Looper looper, @NonNull String string2) {
        listenerHolder = ListenerHolders.createListenerHolder(listenerHolder, looper, "NO_TYPE");
        this.zaa.add(listenerHolder);
        return listenerHolder;
    }

    public final void zab() {
        Iterator iterator = this.zaa.iterator();
        while (iterator.hasNext()) {
            ((ListenerHolder)iterator.next()).clear();
        }
        this.zaa.clear();
    }
}

