/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zab;
import com.google.android.gms.common.data.zac;
import com.google.android.gms.common.data.zae;
import com.google.android.gms.common.data.zaf;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.sqlite.CursorWrapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@KeepName
@SafeParcelable.Class(creator="DataHolderCreator", validate=true)
@KeepForSdk
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<DataHolder> CREATOR;
    private static final Builder zaf;
    @SafeParcelable.VersionField(id=1000)
    final int zaa;
    @SafeParcelable.Field(id=1, getter="getColumns")
    private final String[] zag;
    Bundle zab;
    @SafeParcelable.Field(id=2, getter="getWindows")
    private final CursorWindow[] zah;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int zai;
    @SafeParcelable.Field(id=4, getter="getMetadata")
    @Nullable
    private final Bundle zaj;
    int[] zac;
    int zad;
    boolean zae;
    private boolean zak;

    @KeepForSdk
    public int getCount() {
        return this.zad;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public int getInteger(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getInt((int)var2_2, this.zab.getInt((String)var1_1));
    }

    @KeepForSdk
    public int getStatusCode() {
        return this.zai;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public int getWindowIndex(int row) {
        int n;
        int n2;
        block2: {
            int[] nArray;
            void var1_2;
            int n3 = row >= 0 ? (var1_2 < this.zad ? 1 : 0) : 0;
            Preconditions.checkState(n3 != 0);
            for (n3 = 0; n3 < (n2 = (nArray = this.zac).length); ++n3) {
                if (var1_2 >= nArray[n3]) continue;
                n = n3 + -1;
                break block2;
            }
            n = n3;
        }
        if (n == n2) {
            return n + -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public long getLong(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getLong((int)var2_2, this.zab.getInt((String)var1_1));
    }

    @KeepForSdk
    @Nullable
    public Bundle getMetadata() {
        return this.zaj;
    }

    @KeepForSdk
    @NonNull
    public static Builder builder(@NonNull String[] columns) {
        String[] stringArray;
        Builder builder = new Builder(stringArray, null, null);
        return builder;
    }

    @KeepForSdk
    @NonNull
    public static DataHolder empty(int statusCode) {
        int n;
        DataHolder dataHolder = new DataHolder(zaf, n, null);
        return dataHolder;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public String getString(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getString((int)var2_2, this.zab.getInt((String)var1_1));
    }

    static {
        Object object = new zaf();
        CREATOR = object;
        zaf = object = new zab(new String[0], null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public DataHolder(@NonNull Cursor cursor, int statusCode, @Nullable Bundle metadata) {
        void var3_6;
        void var2_5;
        CursorWindow cursorWindow;
        CursorWrapper cursorWrapper = new CursorWrapper((Cursor)cursorWindow);
        String[] stringArray = cursorWrapper.getColumnNames();
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n;
            int n2;
            int n3 = cursorWrapper.getCount();
            cursorWindow = cursorWrapper.getWindow();
            if (cursorWindow != null) {
                n2 = cursorWindow.getStartPosition();
                if (n2 == 0) {
                    cursorWindow.acquireReference();
                    cursorWrapper.setWindow(null);
                    arrayList.add(cursorWindow);
                    n = cursorWindow.getNumRows();
                } else {
                    n = 0;
                }
            } else {
                n = 0;
            }
            while (n < n3 && (n2 = (int)(cursorWrapper.moveToPosition(n) ? 1 : 0)) != 0) {
                CursorWindow cursorWindow2;
                CursorWindow cursorWindow3 = cursorWrapper.getWindow();
                if (cursorWindow3 != null) {
                    cursorWindow3.acquireReference();
                    cursorWrapper.setWindow(null);
                    cursorWindow2 = cursorWindow3;
                } else {
                    cursorWindow3 = new CursorWindow(false);
                    cursorWindow3.setStartPosition(n);
                    cursorWrapper.fillWindow(n, cursorWindow3);
                    cursorWindow2 = cursorWindow3;
                }
                if ((n2 = cursorWindow2.getNumRows()) != 0) {
                    arrayList.add(cursorWindow2);
                    n2 = cursorWindow2.getStartPosition();
                    n = cursorWindow2.getNumRows();
                    n = n2 + n;
                    continue;
                }
                break;
            }
        }
        finally {
            cursorWrapper.close();
        }
        this(stringArray, arrayList.toArray(new CursorWindow[arrayList.size()]), (int)var2_5, (Bundle)var3_6);
    }

    private DataHolder(Builder builder, int n, @Nullable Bundle bundle) {
        this(builder.zaa, DataHolder.zaf(builder, -1), n, null);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public DataHolder(@NonNull String[] columns, @NonNull CursorWindow[] windows, int statusCode, @Nullable Bundle metadata) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae = false;
        this.zak = true;
        this.zaa = 1;
        this.zag = (String[])Preconditions.checkNotNull((Object)var1_1);
        this.zah = (CursorWindow[])Preconditions.checkNotNull((Object)var2_2);
        this.zai = var3_3;
        this.zaj = var4_4;
        this.zad();
    }

    @SafeParcelable.Constructor
    DataHolder(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String[] stringArray, @SafeParcelable.Param(id=2) CursorWindow[] cursorWindowArray, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) @Nullable Bundle bundle) {
        this.zae = false;
        this.zak = true;
        this.zaa = n;
        this.zag = stringArray;
        this.zah = cursorWindowArray;
        this.zai = n2;
        this.zaj = bundle;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public void close() {
        synchronized (this) {
            CursorWindow[] cursorWindowArray;
            int n;
            int n2 = this.zae;
            if (n2 != 0) return;
            this.zae = true;
            for (n2 = 0; n2 < (n = (cursorWindowArray = this.zah).length); ++n2) {
                cursorWindowArray[n2].close();
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        block6: {
            int n = this.zak;
            if (n == 0) break block6;
            n = this.zah.length;
            if (n <= 0) break block6;
            n = this.isClosed() ? 1 : 0;
            if (n != 0) break block6;
            try {
                this.close();
                String string2 = this.toString();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ");
                stringBuilder.append(string2);
                stringBuilder.append(")");
                Log.e((String)"DataBuffer", (String)stringBuilder.toString());
            }
            finally {
                super.finalize();
            }
        }
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeStringArray((Parcel)parcel, (int)1, (String[])this.zag, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)2, (Parcelable[])this.zah, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.getStatusCode());
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)4, (Bundle)this.getMetadata(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1000, (int)this.zaa);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
        if ((n & 1) != 0) {
            this.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean getBoolean(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return Long.valueOf(this.zah[var3_3].getLong((int)var2_2, this.zab.getInt((String)var1_1))) == 1L;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean hasColumn(@NonNull String column) {
        void var1_1;
        return this.zab.containsKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean hasNull(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].isNull((int)var2_2, this.zab.getInt((String)var1_1));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isClosed() {
        synchronized (this) {
            return this.zae;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public byte[] getByteArray(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getBlob((int)var2_2, this.zab.getInt((String)var1_1));
    }

    public final double zaa(@NonNull String string2, int n, int n2) {
        this.zae(string2, n);
        return this.zah[n2].getDouble(n, this.zab.getInt(string2));
    }

    public final float zab(@NonNull String string2, int n, int n2) {
        this.zae(string2, n);
        return this.zah[n2].getFloat(n, this.zab.getInt(string2));
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, zae zae2) {
        this(builder, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, int n2, zae zae2) {
        this(builder.zaa, DataHolder.zaf(builder, -1), n, bundle);
    }

    private final void zae(String string2, int n) {
        Object object;
        Bundle bundle = ((DataHolder)object).zab;
        if (bundle == null || !bundle.containsKey(string2)) {
            object = new IllegalArgumentException("No such column: ".concat(String.valueOf(string2)));
            throw object;
        }
        if (((DataHolder)object).isClosed()) {
            object = new IllegalArgumentException("Buffer is closed.");
            throw object;
        }
        if (n < 0 || n >= ((DataHolder)object).zad) {
            string2 = new CursorIndexOutOfBoundsException(n, ((DataHolder)object).zad);
            throw string2;
        }
    }

    public final void zac(@NonNull String string2, int n, int n2, @NonNull CharArrayBuffer charArrayBuffer) {
        this.zae(string2, n);
        this.zah[n2].copyStringToBuffer(n, this.zab.getInt(string2), charArrayBuffer);
    }

    public final void zad() {
        CursorWindow cursorWindow;
        String[] stringArray;
        int n;
        Bundle bundle;
        this.zab = bundle = new Bundle();
        for (n = 0; n < (stringArray = this.zag).length; ++n) {
            this.zab.putInt(stringArray[n], n);
        }
        this.zac = new int[this.zah.length];
        n = 0;
        for (int i = 0; i < ((CursorWindow[])(cursorWindow = this.zah)).length; ++i) {
            this.zac[i] = n;
            cursorWindow = cursorWindow[i];
            int n2 = cursorWindow.getStartPosition();
            n += this.zah[i].getNumRows() - (n - n2);
        }
        this.zad = n;
    }

    /*
     * Exception decompiling
     */
    private static CursorWindow[] zaf(Builder var0, int var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 18[TRYBLOCK] [24 : 677->734)] java.lang.RuntimeException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @KeepForSdk
    public static class Builder {
        private final String[] zaa;
        private final ArrayList zab;
        private final HashMap zac;

        @KeepForSdk
        @NonNull
        public Builder withRow(@NonNull ContentValues values) {
            Iterator iterator;
            Asserts.checkNotNull((Object)values);
            HashMap hashMap = new HashMap(iterator.size());
            for (Map.Entry entry : iterator.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zaa(hashMap);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public DataHolder build(int statusCode) {
            void var1_1;
            DataHolder dataHolder = new DataHolder(this, (int)var1_1, null, null);
            return dataHolder;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public DataHolder build(int statusCode, @NonNull Bundle metadata) {
            void var2_2;
            void var1_1;
            DataHolder dataHolder = new DataHolder(this, (int)var1_1, (Bundle)var2_2, -1, null);
            return dataHolder;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder zaa(@NonNull HashMap hashMap) {
            Asserts.checkNotNull((Object)hashMap);
            this.zab.add(hashMap);
            return this;
        }

        static /* bridge */ /* synthetic */ ArrayList zab(Builder builder) {
            return builder.zab;
        }

        /* synthetic */ Builder(String[] object, String string2, zac zac2) {
            this.zaa = (String[])Preconditions.checkNotNull((Object)object);
            this.zab = object;
            super();
            this.zac = object;
        }
    }
}

