/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;

@KeepForSdk
public class Storage {
    private static final Lock zaa;
    @GuardedBy(value="sLk")
    @Nullable
    private static Storage zab;
    private final Lock zac;
    @GuardedBy(value="mLk")
    private final SharedPreferences zad;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    @KeepForSdk
    public GoogleSignInAccount getSavedDefaultGoogleSignInAccount() {
        void var0_2;
        String string = this.zaa("defaultGoogleSignInAccount");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return var0_2;
        }
        String string2 = this.zaa(Storage.zae("googleSignInAccount", string));
        if (string2 == null) return var0_2;
        try {
            GoogleSignInAccount googleSignInAccount = GoogleSignInAccount.zab(string2);
            return var0_2;
        }
        catch (JSONException jSONException) {
            return var0_2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    @KeepForSdk
    public GoogleSignInOptions getSavedDefaultGoogleSignInOptions() {
        String string = ((Storage)this).zaa("defaultGoogleSignInAccount");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if ((this = ((Storage)this).zaa(Storage.zae("googleSignInOptions", string))) == null) return null;
        try {
            return GoogleSignInOptions.zab((String)this);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @KeepForSdk
    @NonNull
    public static Storage getInstance(@NonNull Context context) {
        Object object;
        Preconditions.checkNotNull((Object)context);
        zaa.lock();
        try {
            Storage storage = zab;
            if (storage == null) {
                zab = storage = new Storage(object.getApplicationContext());
            }
            object = zab;
        }
        finally {
            zaa.unlock();
        }
        return object;
    }

    @Nullable
    @KeepForSdk
    public String getSavedRefreshToken() {
        return this.zaa("refreshToken");
    }

    static {
        ReentrantLock reentrantLock = new ReentrantLock();
        zaa = reentrantLock;
    }

    @VisibleForTesting
    Storage(Context context) {
        ReentrantLock reentrantLock = new ReentrantLock();
        this.zac = reentrantLock;
        this.zad = context.getSharedPreferences("com.google.android.gms.signin", 0);
    }

    @KeepForSdk
    public void clear() {
        this.zac.lock();
        try {
            this.zad.edit().clear().apply();
        }
        finally {
            this.zac.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void saveDefaultGoogleSignInAccount(@NonNull GoogleSignInAccount googleSignInAccount, @NonNull GoogleSignInOptions googleSignInOptions) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount));
        Preconditions.checkNotNull((Object)var2_2);
        this.zad("defaultGoogleSignInAccount", var1_1.zac());
        Preconditions.checkNotNull((Object)var1_1);
        Preconditions.checkNotNull((Object)var2_2);
        String string = var1_1.zac();
        this.zad(Storage.zae("googleSignInAccount", string), var1_1.zad());
        this.zad(Storage.zae("googleSignInOptions", string), var2_2.zaf());
    }

    @Nullable
    protected final String zaa(@NonNull String string) {
        this.zac.lock();
        try {
            string = this.zad.getString(string, null);
        }
        finally {
            this.zac.unlock();
        }
        return string;
    }

    protected final void zab(@NonNull String string) {
        this.zac.lock();
        try {
            this.zad.edit().remove(string).apply();
        }
        finally {
            this.zac.unlock();
        }
    }

    public final void zac() {
        String string = this.zaa("defaultGoogleSignInAccount");
        this.zab("defaultGoogleSignInAccount");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zab(Storage.zae("googleSignInAccount", string));
        this.zab(Storage.zae("googleSignInOptions", string));
    }

    protected final void zad(@NonNull String string, @NonNull String string2) {
        this.zac.lock();
        try {
            this.zad.edit().putString(string, string2).apply();
        }
        finally {
            this.zac.unlock();
        }
    }

    private static final String zae(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

