/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zah;
import com.google.android.gms.common.internal.zai;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;

@KeepForSdk
public abstract class GmsClient<T extends IInterface>
extends BaseGmsClient<T>
implements Api.Client,
zaj {
    @Nullable
    private static volatile Executor zaa;
    private final ClientSettings zab;
    private final Set<Scope> zac;
    @Nullable
    private final Account zad;

    @Nullable
    public final Account getAccount() {
        return this.zad;
    }

    @KeepForSdk
    @NonNull
    protected final ClientSettings getClientSettings() {
        return this.zab;
    }

    @KeepForSdk
    @NonNull
    protected final Set<Scope> getScopes() {
        return this.zac;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @KeepForSdk
    @NonNull
    public Set<Scope> getScopesForConnectionlessNonSignIn() {
        if (!this.requiresSignIn()) return Collections.emptySet();
        return ((GmsClient)((Object)this)).zac;
    }

    @NonNull
    @KeepForSdk
    protected Set<Scope> validateScopes(@NonNull Set<Scope> scopes) {
        return scopes;
    }

    @Nullable
    protected final Executor getBindServiceExecutor() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected GmsClient(@NonNull Context context, @NonNull Handler handler, int gCoreServiceId, @NonNull ClientSettings clientSettings) {
        super((Context)var1_1, (Handler)var2_2, GmsClientSupervisor.getInstance((Context)var1_1), (GoogleApiAvailabilityLight)GoogleApiAvailability.getInstance(), (int)var3_3, null, null);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zab = (ClientSettings)Preconditions.checkNotNull((Object)var4_4);
        this.zad = var4_4.getAccount();
        this.zac = this.zaa(var4_4.getAllRequestedScopes());
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected GmsClient(@NonNull Context context, @NonNull Looper looper, int gCoreServiceId, @NonNull ClientSettings clientSettings) {
        this((Context)var1_1, (Looper)var2_2, GmsClientSupervisor.getInstance((Context)var1_1), GoogleApiAvailability.getInstance(), (int)var3_3, (ClientSettings)var4_4, null, null);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    protected GmsClient(@NonNull Context context, @NonNull Looper looper, int gCoreServiceId, @NonNull ClientSettings clientSettings, @NonNull GoogleApiClient.ConnectionCallbacks connectedListener, @NonNull GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, (int)var3_3, (ClientSettings)var4_4, (ConnectionCallbacks)var5_5, (OnConnectionFailedListener)var6_6);
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected GmsClient(@NonNull Context context, @NonNull Looper looper, int gCoreServiceId, @NonNull ClientSettings clientSettings, @NonNull ConnectionCallbacks connectedListener, @NonNull OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, GmsClientSupervisor.getInstance((Context)var1_1), GoogleApiAvailability.getInstance(), (int)var3_3, (ClientSettings)var4_4, (ConnectionCallbacks)Preconditions.checkNotNull((Object)var5_5), (OnConnectionFailedListener)Preconditions.checkNotNull((Object)var6_6));
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    protected GmsClient(@NonNull Context context, @NonNull Looper looper, @NonNull GmsClientSupervisor gmsClientSupervisor, @NonNull GoogleApiAvailability googleApiAvailability, int n, @NonNull ClientSettings clientSettings, @Nullable ConnectionCallbacks object, @Nullable OnConnectionFailedListener object2) {
        Object object3;
        object = object == null ? null : (object3 = new zah((ConnectionCallbacks)object));
        object2 = object2 == null ? null : (object3 = new zai((OnConnectionFailedListener)object2));
        super(context, looper, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, (BaseGmsClient.BaseConnectionCallbacks)object, (BaseGmsClient.BaseOnConnectionFailedListener)object2, clientSettings.zac());
        this.zab = clientSettings;
        this.zad = clientSettings.getAccount();
        this.zac = this.zaa(clientSettings.getAllRequestedScopes());
    }

    @Override
    @KeepForSdk
    @NonNull
    public Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    private final Set<Scope> zaa(@NonNull Set<Scope> set) {
        Object object = ((GmsClient)object).validateScopes(set);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            if (set.contains((Scope)iterator.next())) continue;
            object = new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
            throw object;
        }
        return object;
    }
}

