/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zaa;
import com.google.android.gms.dynamic.zab;
import com.google.android.gms.dynamic.zac;
import com.google.android.gms.dynamic.zad;
import com.google.android.gms.dynamic.zae;
import com.google.android.gms.dynamic.zaf;
import com.google.android.gms.dynamic.zag;
import com.google.android.gms.dynamic.zah;
import java.util.LinkedList;

@KeepForSdk
public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private T zaa;
    @Nullable
    private Bundle zab;
    private LinkedList<zah> zac;
    private final OnDelegateCreatedListener<T> zad;

    @KeepForSdk
    public DeferredLifecycleHelper() {
        zaa zaa2;
        this.zad = zaa2 = new zaa(this);
    }

    @KeepForSdk
    @RecentlyNonNull
    public T getDelegate() {
        return this.zaa;
    }

    @KeepForSdk
    protected abstract void createDelegate(@RecentlyNonNull OnDelegateCreatedListener<T> var1);

    @KeepForSdk
    public void onInflate(@RecentlyNonNull Activity activity, @RecentlyNonNull Bundle bundle, @Nullable Bundle bundle2) {
        zab zab2 = new zab(this, activity, bundle, bundle2);
        this.zaf(bundle2, zab2);
    }

    @KeepForSdk
    public void onCreate(@Nullable Bundle bundle) {
        zac zac2 = new zac(this, bundle);
        this.zaf(bundle, zac2);
    }

    @KeepForSdk
    @RecentlyNonNull
    public View onCreateView(@RecentlyNonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        zad zad2 = new zad(this, frameLayout, layoutInflater, viewGroup, bundle);
        this.zaf(bundle, zad2);
        if (this.zaa == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    @KeepForSdk
    protected void handleGooglePlayUnavailable(@RecentlyNonNull FrameLayout frameLayout) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(frameLayout);
    }

    @KeepForSdk
    public static void showGooglePlayUnavailableMessage(@RecentlyNonNull FrameLayout frameLayout) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        Context context = frameLayout.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = com.google.android.gms.common.internal.zac.zac(context, n);
        String string3 = com.google.android.gms.common.internal.zac.zae(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        frameLayout.addView((View)linearLayout);
        layoutParams = new TextView(frameLayout.getContext());
        frameLayout = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.setLayoutParams((ViewGroup.LayoutParams)frameLayout);
        layoutParams.setText((CharSequence)string2);
        linearLayout.addView((View)layoutParams);
        frameLayout = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (frameLayout != null) {
            googleApiAvailability = new Button(context);
            googleApiAvailability.setId(16908313);
            Object object = new FrameLayout.LayoutParams(-2, -2);
            googleApiAvailability.setLayoutParams((ViewGroup.LayoutParams)object);
            googleApiAvailability.setText(string3);
            linearLayout.addView((View)googleApiAvailability);
            object = new zae(context, (Intent)frameLayout);
            googleApiAvailability.setOnClickListener((View.OnClickListener)object);
            return;
        }
    }

    @KeepForSdk
    public void onStart() {
        zaf zaf2 = new zaf(this);
        this.zaf(null, zaf2);
    }

    @KeepForSdk
    public void onResume() {
        zag zag2 = new zag(this);
        this.zaf(null, zag2);
    }

    @KeepForSdk
    public void onPause() {
        T t = this.zaa;
        if (t != null) {
            t.onPause();
            return;
        }
        this.zae(5);
    }

    @KeepForSdk
    public void onStop() {
        T t = this.zaa;
        if (t != null) {
            t.onStop();
            return;
        }
        this.zae(4);
    }

    @KeepForSdk
    public void onDestroyView() {
        T t = this.zaa;
        if (t != null) {
            t.onDestroyView();
            return;
        }
        this.zae(2);
    }

    @KeepForSdk
    public void onDestroy() {
        T t = this.zaa;
        if (t != null) {
            t.onDestroy();
            return;
        }
        this.zae(1);
    }

    @KeepForSdk
    public void onSaveInstanceState(@RecentlyNonNull Bundle bundle) {
        T t = deferredLifecycleHelper.zaa;
        if (t != null) {
            t.onSaveInstanceState(bundle);
            return;
        }
        DeferredLifecycleHelper deferredLifecycleHelper = deferredLifecycleHelper.zab;
        if (deferredLifecycleHelper != null) {
            bundle.putAll((Bundle)deferredLifecycleHelper);
            return;
        }
    }

    @KeepForSdk
    public void onLowMemory() {
        DeferredLifecycleHelper<T> deferredLifecycleHelper = deferredLifecycleHelper.zaa;
        if (deferredLifecycleHelper != null) {
            deferredLifecycleHelper.onLowMemory();
            return;
        }
    }

    private final void zae(int n) {
        while (!this.zac.isEmpty() && this.zac.getLast().zaa() >= n) {
            this.zac.removeLast();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zaf(@Nullable Bundle bundle, zah zah2) {
        T t = this.zaa;
        if (t != null) {
            zah2.zab((LifecycleDelegate)t);
            return;
        }
        if (this.zac == null) {
            LinkedList linkedList = new LinkedList();
            this.zac = linkedList;
        }
        this.zac.add(zah2);
        if (bundle != null) {
            zah2 = this.zab;
            if (zah2 == null) {
                this.zab = (Bundle)bundle.clone();
            } else {
                zah2.putAll(bundle);
            }
        }
        this.createDelegate(this.zad);
    }

    static /* synthetic */ LifecycleDelegate zaa(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zaa = lifecycleDelegate;
        return lifecycleDelegate;
    }

    static /* synthetic */ LinkedList zab(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zac;
    }

    static /* synthetic */ LifecycleDelegate zac(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zaa;
    }

    static /* synthetic */ Bundle zad(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zab = null;
        return null;
    }
}

