/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Iterator;

@ShowFirstParty
@KeepForSdk
public abstract class FastSafeParcelableJsonResponse
extends FastJsonResponse
implements SafeParcelable {
    @KeepForSdk
    public FastSafeParcelableJsonResponse() {
    }

    @Override
    @VisibleForTesting
    @RecentlyNullable
    public Object getValueObject(@RecentlyNonNull String string2) {
        return null;
    }

    @Override
    @VisibleForTesting
    public boolean isPrimitiveFieldSet(@RecentlyNonNull String string2) {
        return false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public byte[] toByteArray() {
        Parcel parcel = Parcel.obtain();
        object.writeToParcel(parcel, 0);
        Object object = parcel.marshall();
        parcel.recycle();
        return object;
    }

    public final int describeContents() {
        return 0;
    }

    @KeepForSdk
    public int hashCode() {
        Iterator<FastJsonResponse.Field<?, ?>> iterator = this.getFieldMappings().values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            FastJsonResponse.Field<?, ?> field = iterator.next();
            if (!this.isFieldSet(field)) continue;
            n = n * 31 + Preconditions.checkNotNull((Object)this.getFieldValue(field)).hashCode();
        }
        return n;
    }

    @KeepForSdk
    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        object = (FastJsonResponse)object;
        for (FastJsonResponse.Field<?, ?> field : this.getFieldMappings().values()) {
            if (this.isFieldSet(field)) {
                if (((FastJsonResponse)object).isFieldSet(field)) {
                    if (Objects.equal((Object)this.getFieldValue(field), (Object)((FastJsonResponse)object).getFieldValue(field))) continue;
                    return false;
                }
                return false;
            }
            if (!((FastJsonResponse)object).isFieldSet(field)) continue;
            return false;
        }
        return true;
    }
}

