/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.converter.zaa;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.server.response.zaj;
import com.google.android.gms.common.server.response.zan;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ShowFirstParty
@KeepForSdk
public abstract class FastJsonResponse {
    @KeepForSdk
    @RecentlyNonNull
    public abstract Map<String, Field<?, ?>> getFieldMappings();

    @KeepForSdk
    @RecentlyNullable
    protected abstract Object getValueObject(@RecentlyNonNull String var1);

    @KeepForSdk
    protected boolean isFieldSet(@RecentlyNonNull Field field) {
        if (field.zac == 11) {
            Object object;
            if (field.zad) {
                String cfr_ignored_0 = field.zae;
                object = new UnsupportedOperationException("Concrete type arrays not supported");
                throw object;
            }
            String cfr_ignored_1 = field.zae;
            object = new UnsupportedOperationException("Concrete types not supported");
            throw object;
        }
        return ((FastJsonResponse)object).isPrimitiveFieldSet(field.zae);
    }

    @KeepForSdk
    protected abstract boolean isPrimitiveFieldSet(@RecentlyNonNull String var1);

    @KeepForSdk
    protected void setIntegerInternal(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, int n) {
        Object object = new UnsupportedOperationException("Integer not supported");
        throw object;
    }

    @KeepForSdk
    protected void setLongInternal(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, long l) {
        Object object = new UnsupportedOperationException("Long not supported");
        throw object;
    }

    @KeepForSdk
    protected void setBooleanInternal(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, boolean bl) {
        Object object = new UnsupportedOperationException("Boolean not supported");
        throw object;
    }

    @KeepForSdk
    protected void setStringInternal(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable String string3) {
        Object object = new UnsupportedOperationException("String not supported");
        throw object;
    }

    @KeepForSdk
    protected void setStringsInternal(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<String> arrayList) {
        Object object = new UnsupportedOperationException("String list not supported");
        throw object;
    }

    @KeepForSdk
    protected void setDecodedBytesInternal(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable byte[] byArray) {
        Object object = new UnsupportedOperationException("byte[] not supported");
        throw object;
    }

    @KeepForSdk
    protected void setStringMapInternal(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable Map<String, String> map) {
        Object object = new UnsupportedOperationException("String map not supported");
        throw object;
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeInternal(@RecentlyNonNull Field field, @RecentlyNonNull String string2, @RecentlyNonNull T t) {
        Object object = new UnsupportedOperationException("Concrete type not supported");
        throw object;
    }

    @KeepForSdk
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(@RecentlyNonNull Field field, @RecentlyNonNull String string2, @Nullable ArrayList<T> arrayList) {
        Object object = new UnsupportedOperationException("Concrete type array not supported");
        throw object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @RecentlyNonNull
    public String toString() {
        Map<String, Field<?, ?>> map = this.getFieldMappings();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.isFieldSet(field)) continue;
            Object object = FastJsonResponse.zaD(field, this.getFieldValue(field));
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"");
            stringBuilder.append(string2);
            stringBuilder.append("\":");
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zac) {
                default: {
                    if (field.zab) {
                        object = (ArrayList)object;
                        stringBuilder.append("[");
                        int n = ((ArrayList)object).size();
                        for (int i = 0; i < n; ++i) {
                            Object e;
                            if (i > 0) {
                                stringBuilder.append(",");
                            }
                            if ((e = ((ArrayList)object).get(i)) == null) continue;
                            FastJsonResponse.zaF(stringBuilder, field, e);
                        }
                        stringBuilder.append("]");
                        continue block5;
                    }
                    FastJsonResponse.zaF(stringBuilder, field, object);
                    continue block5;
                }
                case 8: {
                    stringBuilder.append("\"");
                    stringBuilder.append(Base64Utils.encode((byte[])((byte[])object)));
                    stringBuilder.append("\"");
                    continue block5;
                }
                case 10: {
                    MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)((HashMap)object));
                    continue block5;
                }
                case 9: 
            }
            stringBuilder.append("\"");
            stringBuilder.append(Base64Utils.encodeUrlSafe((byte[])((byte[])object)));
            stringBuilder.append("\"");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        stringBuilder.append("{}");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNullable
    protected Object getFieldValue(@RecentlyNonNull Field object) {
        String string2;
        char c;
        String string3 = object.zae;
        if (object.zag == null) {
            return ((FastJsonResponse)this).getValueObject(string3);
        }
        boolean bl = ((FastJsonResponse)this).getValueObject(string3) == null;
        Object object2 = new Object[]{object.zae};
        Preconditions.checkState((boolean)bl, (String)"Concrete field shouldn't be value object: %s", (Object[])object2);
        boolean cfr_ignored_0 = object.zad;
        try {
            c = Character.toUpperCase(string3.charAt(0));
            string2 = string3.substring(1);
            int n = String.valueOf(string2).length();
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException(exception);
            throw runtimeException;
        }
        {
            object2 = new StringBuilder(n += 4);
            ((StringBuilder)object2).append("get");
            ((StringBuilder)object2).append(c);
            ((StringBuilder)object2).append(string2);
            return this.getClass().getMethod(((StringBuilder)object2).toString(), new Class[0]).invoke(this, new Object[0]);
        }
    }

    private final <I, O> void zaE(Field<I, O> object, @Nullable I object2) {
        String string2 = ((Field)((Object)object)).zae;
        object2 = ((Field)((Object)object)).zah(object2);
        int n = ((Field)((Object)object)).zac;
        switch (n) {
            case 8: 
            case 9: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).setDecodedBytesInternal((Field<?, ?>)((Object)object), string2, (byte[])object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 7: {
                ((FastJsonResponse)object3).setStringInternal((Field<?, ?>)((Object)object), string2, (String)object2);
                return;
            }
            case 6: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).setBooleanInternal((Field<?, ?>)((Object)object), string2, (Boolean)object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 5: {
                ((FastJsonResponse)object3).zaA((Field<?, ?>)((Object)object), string2, (BigDecimal)object2);
                return;
            }
            case 2: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).setLongInternal((Field<?, ?>)((Object)object), string2, (Long)object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 4: {
                if (object2 != null) {
                    ((FastJsonResponse)object3).zay((Field<?, ?>)((Object)object), string2, (Double)object2);
                    return;
                }
                FastJsonResponse.zaG(string2);
                return;
            }
            case 1: {
                ((FastJsonResponse)object3).zat((Field<?, ?>)((Object)object), string2, (BigInteger)object2);
                return;
            }
            case 0: {
                if (object2 == null) break;
                ((FastJsonResponse)object3).setIntegerInternal((Field<?, ?>)((Object)object), string2, (Integer)object2);
                return;
            }
            default: {
                object = new StringBuilder(44);
                ((StringBuilder)object).append("Unsupported type for conversion: ");
                ((StringBuilder)object).append(n);
                Object object3 = new IllegalStateException(((StringBuilder)object).toString());
                throw object3;
            }
        }
        FastJsonResponse.zaG(string2);
    }

    public final <O> void zaa(@RecentlyNonNull Field<Integer, O> field, int n) {
        if (((Field)field).zak != null) {
            this.zaE(field, n);
            return;
        }
        this.setIntegerInternal(field, field.zae, n);
    }

    public final <O> void zab(@RecentlyNonNull Field<ArrayList<Integer>, O> field, @Nullable ArrayList<Integer> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zas(field, field.zae, arrayList);
    }

    public final <O> void zac(@RecentlyNonNull Field<BigInteger, O> field, @Nullable BigInteger bigInteger) {
        if (((Field)field).zak != null) {
            this.zaE(field, bigInteger);
            return;
        }
        this.zat(field, field.zae, bigInteger);
    }

    public final <O> void zad(@RecentlyNonNull Field<ArrayList<BigInteger>, O> field, @Nullable ArrayList<BigInteger> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zau(field, field.zae, arrayList);
    }

    public final <O> void zae(@RecentlyNonNull Field<Long, O> field, long l) {
        if (((Field)field).zak != null) {
            this.zaE(field, l);
            return;
        }
        this.setLongInternal(field, field.zae, l);
    }

    public final <O> void zaf(@RecentlyNonNull Field<ArrayList<Long>, O> field, @Nullable ArrayList<Long> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zav(field, field.zae, arrayList);
    }

    public final <O> void zag(@RecentlyNonNull Field<Float, O> field, float f) {
        if (((Field)field).zak != null) {
            this.zaE(field, Float.valueOf(f));
            return;
        }
        this.zaw(field, field.zae, f);
    }

    public final <O> void zah(@RecentlyNonNull Field<ArrayList<Float>, O> field, @Nullable ArrayList<Float> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zax(field, field.zae, arrayList);
    }

    public final <O> void zai(@RecentlyNonNull Field<Double, O> field, double d) {
        if (((Field)field).zak != null) {
            this.zaE(field, d);
            return;
        }
        this.zay(field, field.zae, d);
    }

    public final <O> void zaj(@RecentlyNonNull Field<ArrayList<Double>, O> field, @Nullable ArrayList<Double> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zaz(field, field.zae, arrayList);
    }

    public final <O> void zak(@RecentlyNonNull Field<BigDecimal, O> field, @Nullable BigDecimal bigDecimal) {
        if (((Field)field).zak != null) {
            this.zaE(field, bigDecimal);
            return;
        }
        this.zaA(field, field.zae, bigDecimal);
    }

    public final <O> void zal(@RecentlyNonNull Field<ArrayList<BigDecimal>, O> field, @Nullable ArrayList<BigDecimal> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zaB(field, field.zae, arrayList);
    }

    public final <O> void zam(@RecentlyNonNull Field<Boolean, O> field, boolean bl) {
        if (((Field)field).zak != null) {
            this.zaE(field, bl);
            return;
        }
        this.setBooleanInternal(field, field.zae, bl);
    }

    public final <O> void zan(@RecentlyNonNull Field<ArrayList<Boolean>, O> field, @Nullable ArrayList<Boolean> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.zaC(field, field.zae, arrayList);
    }

    public final <O> void zao(@RecentlyNonNull Field<String, O> field, @Nullable String string2) {
        if (((Field)field).zak != null) {
            this.zaE(field, string2);
            return;
        }
        this.setStringInternal(field, field.zae, string2);
    }

    public final <O> void zap(@RecentlyNonNull Field<ArrayList<String>, O> field, @Nullable ArrayList<String> arrayList) {
        if (((Field)field).zak != null) {
            this.zaE(field, arrayList);
            return;
        }
        this.setStringsInternal(field, field.zae, arrayList);
    }

    public final <O> void zaq(@RecentlyNonNull Field<byte[], O> field, @Nullable byte[] byArray) {
        if (((Field)field).zak != null) {
            this.zaE(field, byArray);
            return;
        }
        this.setDecodedBytesInternal(field, field.zae, byArray);
    }

    public final <O> void zar(@RecentlyNonNull Field<Map<String, String>, O> field, @Nullable Map<String, String> map) {
        if (((Field)field).zak != null) {
            this.zaE(field, map);
            return;
        }
        this.setStringMapInternal(field, field.zae, map);
    }

    protected void zas(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Integer> arrayList) {
        Object object = new UnsupportedOperationException("Integer list not supported");
        throw object;
    }

    protected void zat(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable BigInteger bigInteger) {
        Object object = new UnsupportedOperationException("BigInteger not supported");
        throw object;
    }

    protected void zau(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<BigInteger> arrayList) {
        Object object = new UnsupportedOperationException("BigInteger list not supported");
        throw object;
    }

    protected void zav(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Long> arrayList) {
        Object object = new UnsupportedOperationException("Long list not supported");
        throw object;
    }

    protected void zaw(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, float f) {
        Object object = new UnsupportedOperationException("Float not supported");
        throw object;
    }

    protected void zax(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Float> arrayList) {
        Object object = new UnsupportedOperationException("Float list not supported");
        throw object;
    }

    protected void zay(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, double d) {
        Object object = new UnsupportedOperationException("Double not supported");
        throw object;
    }

    protected void zaz(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Double> arrayList) {
        Object object = new UnsupportedOperationException("Double list not supported");
        throw object;
    }

    protected void zaA(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable BigDecimal bigDecimal) {
        Object object = new UnsupportedOperationException("BigDecimal not supported");
        throw object;
    }

    protected void zaB(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<BigDecimal> arrayList) {
        Object object = new UnsupportedOperationException("BigDecimal list not supported");
        throw object;
    }

    protected void zaC(@RecentlyNonNull Field<?, ?> field, @RecentlyNonNull String string2, @Nullable ArrayList<Boolean> arrayList) {
        Object object = new UnsupportedOperationException("Boolean list not supported");
        throw object;
    }

    private static final void zaF(StringBuilder stringBuilder, Field object, Object object2) {
        int n = ((Field)((Object)object)).zaa;
        if (n != 11) {
            if (n == 7) {
                stringBuilder.append("\"");
                stringBuilder.append(JsonUtils.escapeString((String)((String)object2)));
                stringBuilder.append("\"");
                return;
            }
            stringBuilder.append(object2);
            return;
        }
        object = ((Field)((Object)object)).zag;
        Preconditions.checkNotNull((Object)object);
        stringBuilder.append(((FastJsonResponse)((Class)object).cast(object2)).toString());
    }

    @RecentlyNonNull
    protected static final <O, I> I zaD(@RecentlyNonNull Field<I, O> field, @Nullable Object object) {
        if (((Field)field).zak != null) {
            return field.zai(object);
        }
        return (I)object;
    }

    private static final <O> void zaG(String string2) {
        if (Log.isLoggable((String)"FastJsonResponse", (int)6)) {
            String string3 = String.valueOf(string2);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 58);
            stringBuilder.append("Output field (");
            stringBuilder.append(string2);
            stringBuilder.append(") has a null value, but expected a primitive");
            Log.e((String)"FastJsonResponse", (String)stringBuilder.toString());
            return;
        }
    }

    @ShowFirstParty
    public static interface FieldConverter<I, O> {
        public int zaa();

        public int zab();

        @RecentlyNullable
        public O zad(@RecentlyNonNull I var1);

        @RecentlyNonNull
        public I zac(@RecentlyNonNull O var1);
    }

    @VisibleForTesting
    @ShowFirstParty
    @SafeParcelable.Class(creator="FieldCreator")
    @KeepForSdk
    public static class Field<I, O>
    extends AbstractSafeParcelable {
        @SafeParcelable.VersionField(id=1, getter="getVersionCode")
        private final int zai;
        @SafeParcelable.Field(id=2, getter="getTypeIn")
        protected final int zaa;
        @SafeParcelable.Field(id=3, getter="isTypeInArray")
        protected final boolean zab;
        @SafeParcelable.Field(id=4, getter="getTypeOut")
        protected final int zac;
        @SafeParcelable.Field(id=5, getter="isTypeOutArray")
        protected final boolean zad;
        @SafeParcelable.Field(id=6, getter="getOutputFieldName")
        @RecentlyNonNull
        protected final String zae;
        @SafeParcelable.Field(id=7, getter="getSafeParcelableFieldId")
        protected final int zaf;
        @RecentlyNullable
        protected final Class<? extends FastJsonResponse> zag;
        @SafeParcelable.Field(id=8, getter="getConcreteTypeName")
        @RecentlyNullable
        protected final String zah;
        private zan zaj;
        @SafeParcelable.Field(id=9, getter="getWrappedConverter", type="com.google.android.gms.common.server.converter.ConverterWrapper")
        @Nullable
        private FieldConverter<I, O> zak;
        public static final zaj CREATOR;

        /*
         * Enabled aggressive block sorting
         */
        protected Field(int n, boolean bl, int n2, boolean bl2, @RecentlyNonNull String string2, int n3, @Nullable Class<? extends FastJsonResponse> clazz, @Nullable FieldConverter<I, O> fieldConverter) {
            this.zai = 1;
            this.zaa = n;
            this.zab = bl;
            this.zac = n2;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n3;
            this.zag = clazz;
            this.zah = clazz == null ? null : clazz.getCanonicalName();
            this.zak = fieldConverter;
        }

        @KeepForSdk
        public int getSafeParcelableFieldId() {
            return this.zaf;
        }

        @VisibleForTesting
        @KeepForSdk
        @RecentlyNonNull
        public static Field<Integer, Integer> forInteger(@RecentlyNonNull String string2, int n) {
            Field<Integer, Integer> field = new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field<Long, Long> forLong(@RecentlyNonNull String string2, int n) {
            Field<Long, Long> field = new Field<Long, Long>(2, false, 2, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field<Float, Float> forFloat(@RecentlyNonNull String string2, int n) {
            Field<Float, Float> field = new Field<Float, Float>(3, false, 3, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field<Double, Double> forDouble(@RecentlyNonNull String string2, int n) {
            Field<Double, Double> field = new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field<Boolean, Boolean> forBoolean(@RecentlyNonNull String string2, int n) {
            Field<Boolean, Boolean> field = new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field<String, String> forString(@RecentlyNonNull String string2, int n) {
            Field<String, String> field = new Field<String, String>(7, false, 7, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field<ArrayList<String>, ArrayList<String>> forStrings(@RecentlyNonNull String string2, int n) {
            Field<ArrayList<String>, ArrayList<String>> field = new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
            return field;
        }

        @VisibleForTesting
        @KeepForSdk
        @RecentlyNonNull
        public static Field<byte[], byte[]> forBase64(@RecentlyNonNull String string2, int n) {
            Field<byte[], byte[]> field = new Field<byte[], byte[]>(8, false, 8, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field<HashMap<String, String>, HashMap<String, String>> forStringMap(@RecentlyNonNull String string2, int n) {
            Field<HashMap<String, String>, HashMap<String, String>> field = new Field<HashMap<String, String>, HashMap<String, String>>(10, false, 10, false, string2, n, null, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static <T extends FastJsonResponse> Field<T, T> forConcreteType(@RecentlyNonNull String string2, int n, @RecentlyNonNull Class<T> clazz) {
            Field field = new Field(11, false, 11, false, string2, n, clazz, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> forConcreteTypeArray(@RecentlyNonNull String string2, int n, @RecentlyNonNull Class<T> clazz) {
            Field<ArrayList<T>, ArrayList<T>> field = new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
            return field;
        }

        @KeepForSdk
        @RecentlyNonNull
        public static Field withConverter(@RecentlyNonNull String string2, int n, @RecentlyNonNull FieldConverter<?, ?> fieldConverter, boolean bl) {
            fieldConverter.zaa();
            fieldConverter.zab();
            Field field = new Field(7, bl, 0, false, string2, n, null, fieldConverter);
            return field;
        }

        public final void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zai);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.zaa);
            SafeParcelWriter.writeBoolean((Parcel)parcel, (int)3, (boolean)this.zab);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zac);
            SafeParcelWriter.writeBoolean((Parcel)parcel, (int)5, (boolean)this.zad);
            SafeParcelWriter.writeString((Parcel)parcel, (int)6, (String)this.zae, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)parcel, (int)7, (int)this.getSafeParcelableFieldId());
            SafeParcelWriter.writeString((Parcel)parcel, (int)8, (String)this.zab(), (boolean)false);
            SafeParcelWriter.writeParcelable((Parcel)parcel, (int)9, (Parcelable)this.zae(), (int)n, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
        }

        @RecentlyNonNull
        public final String toString() {
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this).add("versionCode", (Object)((Field)((Object)this)).zai).add("typeIn", (Object)((Field)((Object)this)).zaa).add("typeInArray", (Object)((Field)((Object)this)).zab).add("typeOut", (Object)((Field)((Object)this)).zac).add("typeOutArray", (Object)((Field)((Object)this)).zad).add("outputFieldName", (Object)((Field)((Object)this)).zae).add("safeParcelFieldId", (Object)((Field)((Object)this)).zaf).add("concreteTypeName", (Object)((Field)((Object)this)).zab());
            Class<? extends FastJsonResponse> clazz = ((Field)((Object)this)).zag;
            if (clazz != null) {
                toStringHelper.add("concreteType.class", (Object)clazz.getCanonicalName());
            }
            if ((this = ((Field)((Object)this)).zak) != null) {
                toStringHelper.add("converterName", (Object)this.getClass().getCanonicalName());
            }
            return toStringHelper.toString();
        }

        static {
            zaj zaj2;
            CREATOR = zaj2 = new zaj();
        }

        /*
         * Enabled aggressive block sorting
         */
        @SafeParcelable.Constructor
        Field(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) int n3, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string2, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) @Nullable String string3, @SafeParcelable.Param(id=9) @Nullable zaa zaa2) {
            this.zai = n;
            this.zaa = n2;
            this.zab = bl;
            this.zac = n3;
            this.zad = bl2;
            this.zae = string2;
            this.zaf = n4;
            if (string3 == null) {
                this.zag = null;
                this.zah = null;
            } else {
                this.zag = SafeParcelResponse.class;
                this.zah = string3;
            }
            if (zaa2 == null) {
                this.zak = null;
                return;
            }
            this.zak = zaa2.zab();
        }

        @RecentlyNonNull
        public final Field<I, O> zaa() {
            Field<I, O> field = new Field<I, O>(this.zai, this.zaa, this.zab, this.zac, this.zad, this.zae, this.zaf, this.zah, this.zae());
            return field;
        }

        @Nullable
        final String zab() {
            Object object = object.zah;
            if (object == null) {
                return null;
            }
            return object;
        }

        public final boolean zac() {
            return this.zak != null;
        }

        public final void zad(zan zan2) {
            this.zaj = zan2;
        }

        @Nullable
        final zaa zae() {
            Object object = object.zak;
            if (object == null) {
                return null;
            }
            return com.google.android.gms.common.server.converter.zaa.zaa(object);
        }

        @RecentlyNonNull
        public final FastJsonResponse zaf() throws InstantiationException, IllegalAccessException {
            Preconditions.checkNotNull(this.zag);
            Object object = this.zag;
            if (object == SafeParcelResponse.class) {
                Preconditions.checkNotNull((Object)this.zah);
                Preconditions.checkNotNull((Object)((Object)this.zaj), (Object)"The field mapping dictionary must be set if the concrete type is a SafeParcelResponse object.");
                object = new SafeParcelResponse(this.zaj, this.zah);
                return object;
            }
            return ((Class)object).newInstance();
        }

        @RecentlyNonNull
        public final Map<String, Field<?, ?>> zag() {
            Preconditions.checkNotNull((Object)this.zah);
            Preconditions.checkNotNull((Object)((Object)this.zaj));
            return (Map)Preconditions.checkNotNull(this.zaj.zad(this.zah));
        }

        @RecentlyNonNull
        public final O zah(@Nullable I i) {
            Preconditions.checkNotNull(this.zak);
            return (O)Preconditions.checkNotNull(this.zak.zad(i));
        }

        @RecentlyNonNull
        public final I zai(@RecentlyNonNull O o) {
            Preconditions.checkNotNull(this.zak);
            return this.zak.zac(o);
        }
    }
}

