/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Response;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zao;
import com.google.android.gms.common.internal.zap;
import com.google.android.gms.common.internal.zaq;
import com.google.android.gms.common.internal.zar;
import com.google.android.gms.common.internal.zas;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

@KeepForSdk
public class PendingResultUtil {
    private static final zas zaa;

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result, T> Task<T> toTask(@RecentlyNonNull PendingResult<R> pendingResult, @RecentlyNonNull ResultConverter<R, T> resultConverter) {
        zas zas2 = zaa;
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zap zap2 = new zap(pendingResult, taskCompletionSource, resultConverter, zas2);
        pendingResult.addStatusListener(zap2);
        return taskCompletionSource.getTask();
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result, T extends Response<R>> Task<T> toResponseTask(@RecentlyNonNull PendingResult<R> pendingResult, @RecentlyNonNull T t) {
        zaq zaq2 = new zaq(t);
        return PendingResultUtil.toTask(pendingResult, zaq2);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <R extends Result> Task<Void> toVoidTask(@RecentlyNonNull PendingResult<R> pendingResult) {
        zar zar2 = new zar();
        return PendingResultUtil.toTask(pendingResult, zar2);
    }

    static {
        zao zao2 = new zao();
        zaa = zao2;
    }

    @KeepForSdk
    public static interface ResultConverter<R extends Result, T> {
        @KeepForSdk
        @RecentlyNullable
        public T convert(@RecentlyNonNull R var1);
    }
}

