/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;

public final class Size {
    private final int zaa;
    private final int zab;

    public Size(int n, int n2) {
        this.zaa = n;
        this.zab = n2;
    }

    public int getWidth() {
        return this.zaa;
    }

    public int getHeight() {
        return this.zab;
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Size) {
            object = (Size)object;
            return this.zaa == ((Size)object).zaa && this.zab == ((Size)object).zab;
        }
        return false;
    }

    @RecentlyNonNull
    public String toString() {
        int n = this.zaa;
        int n2 = this.zab;
        StringBuilder stringBuilder = new StringBuilder(23);
        stringBuilder.append(n);
        stringBuilder.append("x");
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    @RecentlyNonNull
    public static Size parseSize(@RecentlyNonNull String object) throws NumberFormatException {
        if (object == null) {
            object = new IllegalArgumentException("string must not be null");
            throw object;
        }
        int n = ((String)object).indexOf(42);
        if (n < 0) {
            n = ((String)object).indexOf(120);
        }
        if (n < 0) {
            throw Size.zaa((String)object);
        }
        try {
            Size size = new Size(Integer.parseInt(((String)object).substring(0, n)), Integer.parseInt(((String)object).substring(n + 1)));
            return size;
        }
        catch (NumberFormatException numberFormatException) {
            throw Size.zaa((String)object);
        }
    }

    public int hashCode() {
        int n = this.zab;
        int n2 = this.zaa;
        return n ^ (n2 << 16 | n2 >>> 16);
    }

    private static NumberFormatException zaa(String string2) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 16);
        stringBuilder.append("Invalid Size: \"");
        stringBuilder.append(string2);
        stringBuilder.append("\"");
        NumberFormatException numberFormatException = new NumberFormatException(stringBuilder.toString());
        throw numberFormatException;
    }
}

