/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferIterator;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.SingleRefDataBufferIterator;
import java.io.Closeable;
import java.util.Iterator;

public abstract class AbstractDataBuffer<T>
implements DataBuffer<T> {
    @RecentlyNullable
    @KeepForSdk
    protected final DataHolder mDataHolder;

    @KeepForSdk
    protected AbstractDataBuffer(@Nullable DataHolder dataHolder) {
        this.mDataHolder = dataHolder;
    }

    @Override
    public int getCount() {
        Closeable closeable = ((AbstractDataBuffer)closeable).mDataHolder;
        if (closeable == null) {
            return 0;
        }
        return ((DataHolder)closeable).getCount();
    }

    @Override
    @RecentlyNonNull
    public abstract T get(int var1);

    @Override
    public final void close() {
        this.release();
    }

    @Override
    @Deprecated
    public boolean isClosed() {
        Closeable closeable = ((AbstractDataBuffer)closeable).mDataHolder;
        return closeable == null || ((DataHolder)closeable).isClosed();
    }

    @Override
    @RecentlyNullable
    public final Bundle getMetadata() {
        Closeable closeable = ((AbstractDataBuffer)closeable).mDataHolder;
        if (closeable == null) {
            return null;
        }
        return ((DataHolder)closeable).getMetadata();
    }

    @Override
    @RecentlyNonNull
    public Iterator<T> iterator() {
        DataBufferIterator dataBufferIterator = new DataBufferIterator(this);
        return dataBufferIterator;
    }

    @Override
    @RecentlyNonNull
    public Iterator<T> singleRefIterator() {
        SingleRefDataBufferIterator singleRefDataBufferIterator = new SingleRefDataBufferIterator(this);
        return singleRefDataBufferIterator;
    }

    @Override
    public void release() {
        Closeable closeable = ((AbstractDataBuffer)closeable).mDataHolder;
        if (closeable != null) {
            ((DataHolder)closeable).close();
            return;
        }
    }
}

