/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.FragmentManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.core.app.NotificationCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.base.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabw;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zag;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.zaa;
import com.google.android.gms.common.zab;
import com.google.android.gms.common.zac;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class GoogleApiAvailability
extends GoogleApiAvailabilityLight {
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    private static final Object zaa;
    private static final GoogleApiAvailability zab;
    @GuardedBy(value="mLock")
    private String zac;

    @NonNull
    public static GoogleApiAvailability getInstance() {
        return zab;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @MainThread
    @NonNull
    public Task<Void> makeGooglePlayServicesAvailable(@RecentlyNonNull Activity object) {
        int n = GOOGLE_PLAY_SERVICES_VERSION_CODE;
        Preconditions.checkMainThread((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n2 = this.isGooglePlayServicesAvailable((Context)object, n);
        if (n2 == 0) {
            return Tasks.forResult(null);
        }
        object = zabw.zaa((Activity)object);
        ConnectionResult connectionResult = new ConnectionResult(n2, null);
        ((zap)((Object)object)).zaf(connectionResult, 0);
        return ((zabw)((Object)object)).zab();
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Fragment fragment, int n, int n2) {
        return this.getErrorDialog(fragment, n, n2, null);
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Activity activity, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        return this.zaf((Context)activity, n, zag.zab(activity, this.getErrorResolutionIntent((Context)activity, n, "d"), n2), onCancelListener);
    }

    @RecentlyNullable
    public Dialog getErrorDialog(@RecentlyNonNull Fragment fragment, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        Context context = fragment.requireContext();
        context = this.getErrorResolutionIntent(context, n, "d");
        return this.zaf(fragment.requireContext(), n, zag.zac(fragment, (Intent)context, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(@RecentlyNonNull Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public boolean showErrorDialogFragment(@RecentlyNonNull Activity activity, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        this.zag(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(@RecentlyNonNull Context context, int n) {
        this.zab(context, n, null, this.getErrorResolutionPendingIntent(context, n, 0, "n"));
    }

    public void showErrorNotification(@RecentlyNonNull Context context, @RecentlyNonNull ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        this.zab(context, connectionResult.getErrorCode(), null, pendingIntent);
    }

    @NonNull
    public Task<Void> checkApiAvailability(@RecentlyNonNull HasApiKey<?> hasApiKey, HasApiKey<?> ... hasApiKeyArray) {
        return GoogleApiAvailability.zai(hasApiKey, hasApiKeyArray).onSuccessTask(com.google.android.gms.common.zaa.zaa);
    }

    @NonNull
    public Task<Void> checkApiAvailability(@RecentlyNonNull GoogleApi<?> googleApi, GoogleApi<?> ... googleApiArray) {
        return GoogleApiAvailability.zai(googleApi, googleApiArray).onSuccessTask(com.google.android.gms.common.zab.zaa);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=26)
    public void setDefaultNotificationChannelId(@RecentlyNonNull Context object, @RecentlyNonNull String string2) {
        if (PlatformVersion.isAtLeastO()) {
            Preconditions.checkNotNull((Object)((NotificationManager)Preconditions.checkNotNull((Object)object.getSystemService("notification"))).getNotificationChannel(string2));
        }
        object = zaa;
        synchronized (object) {
            this.zac = string2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @HideFirstParty
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context, int n) {
        return super.isGooglePlayServicesAvailable(context, n);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, int n, @Nullable String string2) {
        return super.getErrorResolutionIntent(context, n, string2);
    }

    @RecentlyNullable
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @RecentlyNullable
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, @RecentlyNonNull ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        return this.getErrorResolutionPendingIntent(context, connectionResult.getErrorCode(), 0);
    }

    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(@RecentlyNonNull Context context) {
        return super.getClientVersion(context);
    }

    @NonNull
    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    static {
        Object object;
        zaa = object = new Object();
        object = new GoogleApiAvailability();
        zab = object;
        GOOGLE_PLAY_SERVICES_VERSION_CODE = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    public final boolean zaa(@RecentlyNonNull Activity activity, @RecentlyNonNull LifecycleFragment lifecycleFragment, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        if ((lifecycleFragment = this.zaf((Context)activity, n, zag.zad(lifecycleFragment, this.getErrorResolutionIntent((Context)activity, n, "d"), 2), onCancelListener)) == null) {
            return false;
        }
        this.zag(activity, (Dialog)lifecycleFragment, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TargetApi(value=20)
    final void zab(Context object, int n, @Nullable String objectArray, @Nullable PendingIntent object2) {
        int n2;
        objectArray = new Object[]{n, null};
        objectArray = String.format("GMS core API Availability. ConnectionResult=%s, tag=%s", objectArray);
        Object object3 = new IllegalArgumentException();
        Log.w((String)"GoogleApiAvailability", (String)objectArray, (Throwable)object3);
        if (n == 18) {
            object4.zah((Context)object);
            return;
        }
        if (object2 == null) {
            if (n != 6) return;
            Log.w((String)"GoogleApiAvailability", (String)"Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            return;
        }
        objectArray = com.google.android.gms.common.internal.zac.zab((Context)object, n);
        object3 = com.google.android.gms.common.internal.zac.zad((Context)object, n);
        Resources resources = object.getResources();
        NotificationManager notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)object.getSystemService("notification"));
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)object);
        builder = builder.setLocalOnly(true);
        builder = builder.setAutoCancel(true);
        objectArray = builder.setContentTitle((CharSequence)objectArray);
        builder = new NotificationCompat.BigTextStyle();
        objectArray = objectArray.setStyle((NotificationCompat.Style)builder.bigText((CharSequence)object3));
        if (DeviceProperties.isWearable((Context)object)) {
            Preconditions.checkState((boolean)PlatformVersion.isAtLeastKitKatWatch());
            objectArray.setSmallIcon(object.getApplicationInfo().icon).setPriority(2);
            if (DeviceProperties.isWearableWithoutPlayStore((Context)object)) {
                objectArray.addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), object2);
            } else {
                objectArray.setContentIntent(object2);
            }
        } else {
            objectArray.setSmallIcon(17301642).setTicker((CharSequence)resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setContentIntent(object2).setContentText((CharSequence)object3);
        }
        if (PlatformVersion.isAtLeastO()) {
            block18: {
                Preconditions.checkState((boolean)PlatformVersion.isAtLeastO());
                object2 = zaa;
                // MONITORENTER : object2
                Object object4 = object4.zac;
                // MONITOREXIT : object2
                if (object4 != null) break block18;
                object4 = "com.google.android.gms.availability";
                object2 = notificationManager.getNotificationChannel((String)object4);
                object = com.google.android.gms.common.internal.zac.zag((Context)object);
                if (object2 == null) {
                    object2 = new NotificationChannel((String)object4, (CharSequence)object, 4);
                    notificationManager.createNotificationChannel((NotificationChannel)object2);
                } else if (!((String)object).contentEquals(object2.getName())) {
                    object2.setName((CharSequence)object);
                    notificationManager.createNotificationChannel((NotificationChannel)object2);
                }
            }
            objectArray.setChannelId((String)object4);
        }
        object = objectArray.build();
        switch (n) {
            default: {
                n2 = 39789;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                GooglePlayServicesUtilLight.sCanceledAvailabilityNotification.set(false);
                n2 = 10436;
            }
        }
        notificationManager.notify(n2, (Notification)object);
        return;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object2
                throw throwable;
            }
        }
    }

    public final boolean zac(@RecentlyNonNull Context context, @RecentlyNonNull ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            this.zab(context, connectionResult.getErrorCode(), null, PendingIntent.getActivity((Context)context, (int)0, (Intent)GoogleApiActivity.zaa(context, pendingIntent, n, true), (int)0x8000000));
            return true;
        }
        return false;
    }

    @RecentlyNonNull
    public final Dialog zad(@RecentlyNonNull Activity activity, @RecentlyNonNull DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        builder.setMessage((CharSequence)com.google.android.gms.common.internal.zac.zac((Context)activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        progressBar = builder.create();
        this.zag(activity, (Dialog)progressBar, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return progressBar;
    }

    @Nullable
    public final zabr zae(Context context, zabq zabq2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zabr zabr2 = new zabr(zabq2);
        context.registerReceiver((BroadcastReceiver)zabr2, intentFilter);
        zabr2.zaa(context);
        if (!this.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zabq2.zaa();
            zabr2.zab();
            return null;
        }
        return zabr2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    final Dialog zaf(@NonNull Context object, int n, zag zag2, @Nullable DialogInterface.OnCancelListener object2) {
        String string2;
        String string3;
        void var4_8;
        void var2_5;
        if (var2_5 == false) {
            return null;
        }
        GoogleApiAvailability googleApiAvailability = new TypedValue();
        object.getTheme().resolveAttribute(16843529, (TypedValue)googleApiAvailability, true);
        googleApiAvailability = "Theme.Dialog.Alert".equals(object.getResources().getResourceEntryName(((TypedValue)googleApiAvailability).resourceId)) ? new AlertDialog.Builder((Context)object, 5) : null;
        if (googleApiAvailability == null) {
            googleApiAvailability = new AlertDialog.Builder((Context)object);
        }
        googleApiAvailability.setMessage(com.google.android.gms.common.internal.zac.zac((Context)object, (int)var2_5));
        if (var4_8 != null) {
            googleApiAvailability.setOnCancelListener((DialogInterface.OnCancelListener)var4_8);
        }
        if ((string3 = com.google.android.gms.common.internal.zac.zae((Context)object, (int)var2_5)) != null) {
            void var3_7;
            googleApiAvailability.setPositiveButton(string3, (DialogInterface.OnClickListener)var3_7);
        }
        if ((string2 = com.google.android.gms.common.internal.zac.zaa((Context)object, (int)var2_5)) != null) {
            googleApiAvailability.setTitle(string2);
        }
        Object[] objectArray = new Object[]{(int)var2_5};
        String string4 = String.format("Creating dialog for Google Play services availability issue. ConnectionResult=%s", objectArray);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
        Log.w((String)"GoogleApiAvailability", (String)string4, (Throwable)illegalArgumentException);
        return googleApiAvailability.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zag(Activity activity, Dialog dialog, String string2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        block2: {
            try {
                boolean bl = activity instanceof FragmentActivity;
                if (!bl) break block2;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                break block2;
            }
            FragmentActivity fragmentActivity = (FragmentActivity)activity;
            fragmentActivity = fragmentActivity.getSupportFragmentManager();
            SupportErrorDialogFragment.newInstance(dialog, onCancelListener).show((androidx.fragment.app.FragmentManager)fragmentActivity, string2);
            return;
        }
        FragmentManager fragmentManager = activity.getFragmentManager();
        ErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
    }

    final void zah(Context context) {
        zac zac2 = new zac(this, context);
        zac2.sendEmptyMessageDelayed(1, 120000L);
    }

    @NonNull
    public static final Task<Map<ApiKey<?>, String>> zai(@RecentlyNonNull HasApiKey<?> hasApiKey, HasApiKey<?> ... hasApiKeyArray) {
        Preconditions.checkNotNull(hasApiKey, (Object)"Requested API must not be null.");
        int n = hasApiKeyArray.length;
        for (int i = 0; i < n; ++i) {
            Preconditions.checkNotNull(hasApiKeyArray[i], (Object)"Requested API must not be null.");
        }
        ArrayList arrayList = new ArrayList(hasApiKeyArray.length + 1);
        arrayList.add(hasApiKey);
        arrayList.addAll(Arrays.asList(hasApiKeyArray));
        return GoogleApiManager.zab().zah(arrayList);
    }
}

