/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferIterator;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.SingleRefDataBufferIterator;
import java.util.Iterator;

public abstract class AbstractDataBuffer<T>
implements DataBuffer<T> {
    @RecentlyNullable
    @KeepForSdk
    protected final DataHolder mDataHolder;

    @KeepForSdk
    protected AbstractDataBuffer(@Nullable DataHolder dataHolder) {
        this.mDataHolder = dataHolder;
    }

    @Override
    @RecentlyNonNull
    public int getCount() {
        if (this.mDataHolder == null) {
            return 0;
        }
        return this.mDataHolder.getCount();
    }

    @Override
    @RecentlyNonNull
    public abstract T get(@RecentlyNonNull int var1);

    @Override
    public final void close() {
        this.release();
    }

    @Override
    @Deprecated
    @RecentlyNonNull
    public boolean isClosed() {
        return this.mDataHolder == null || this.mDataHolder.isClosed();
    }

    @Override
    @RecentlyNullable
    public Bundle getMetadata() {
        if (this.mDataHolder == null) {
            return null;
        }
        return this.mDataHolder.getMetadata();
    }

    @Override
    @RecentlyNonNull
    public Iterator<T> iterator() {
        return new DataBufferIterator(this);
    }

    @Override
    @RecentlyNonNull
    public Iterator<T> singleRefIterator() {
        return new SingleRefDataBufferIterator(this);
    }

    @Override
    public void release() {
        if (this.mDataHolder != null) {
            this.mDataHolder.close();
        }
    }
}

