/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;

@KeepForSdk
public class Storage {
    private static final Lock zaa = new ReentrantLock();
    @GuardedBy(value="sLk")
    @Nullable
    private static Storage zab;
    private final Lock zac = new ReentrantLock();
    @GuardedBy(value="mLk")
    private final SharedPreferences zad;

    @KeepForSdk
    @RecentlyNonNull
    public static Storage getInstance(@RecentlyNonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        zaa.lock();
        try {
            if (zab == null) {
                zab = new Storage(context.getApplicationContext());
            }
            Storage storage = zab;
            return storage;
        }
        finally {
            zaa.unlock();
        }
    }

    @VisibleForTesting
    private Storage(Context context) {
        this.zad = context.getSharedPreferences("com.google.android.gms.signin", 0);
    }

    @KeepForSdk
    public void saveDefaultGoogleSignInAccount(@RecentlyNonNull GoogleSignInAccount googleSignInAccount, @RecentlyNonNull GoogleSignInOptions googleSignInOptions) {
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount));
        Preconditions.checkNotNull((Object)googleSignInOptions);
        this.zaa("defaultGoogleSignInAccount", googleSignInAccount.zaa());
        GoogleSignInOptions googleSignInOptions2 = googleSignInOptions;
        GoogleSignInAccount googleSignInAccount2 = googleSignInAccount;
        Storage storage = this;
        Preconditions.checkNotNull((Object)((Object)googleSignInAccount2));
        Preconditions.checkNotNull((Object)googleSignInOptions2);
        String string = googleSignInAccount2.zaa();
        storage.zaa(Storage.zab("googleSignInAccount", string), googleSignInAccount2.zab());
        storage.zaa(Storage.zab("googleSignInOptions", string), googleSignInOptions2.zaa());
    }

    private final void zaa(String string, String string2) {
        this.zac.lock();
        try {
            this.zad.edit().putString(string, string2).apply();
            return;
        }
        finally {
            this.zac.unlock();
        }
    }

    @RecentlyNullable
    @KeepForSdk
    public GoogleSignInAccount getSavedDefaultGoogleSignInAccount() {
        String string = this.zac("defaultGoogleSignInAccount");
        return this.zaa(string);
    }

    @VisibleForTesting
    @Nullable
    private final GoogleSignInAccount zaa(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = this.zac(Storage.zab("googleSignInAccount", string));
        try {
            if (string2 != null) {
                return GoogleSignInAccount.zaa(string2);
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @RecentlyNullable
    @KeepForSdk
    public GoogleSignInOptions getSavedDefaultGoogleSignInOptions() {
        String string = this.zac("defaultGoogleSignInAccount");
        return this.zab(string);
    }

    @VisibleForTesting
    @Nullable
    private final GoogleSignInOptions zab(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = this.zac(Storage.zab("googleSignInOptions", string));
        try {
            if (string2 != null) {
                return GoogleSignInOptions.zaa(string2);
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @RecentlyNullable
    @KeepForSdk
    public String getSavedRefreshToken() {
        return this.zac("refreshToken");
    }

    @Nullable
    private final String zac(String string) {
        this.zac.lock();
        try {
            String string2 = this.zad.getString(string, null);
            return string2;
        }
        finally {
            this.zac.unlock();
        }
    }

    public final void zaa() {
        String string = this.zac("defaultGoogleSignInAccount");
        this.zad("defaultGoogleSignInAccount");
        String string2 = string;
        Storage storage = this;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            storage.zad(Storage.zab("googleSignInAccount", string2));
            storage.zad(Storage.zab("googleSignInOptions", string2));
        }
    }

    private final void zad(String string) {
        this.zac.lock();
        try {
            this.zad.edit().remove(string).apply();
            return;
        }
        finally {
            this.zac.unlock();
        }
    }

    @KeepForSdk
    public void clear() {
        this.zac.lock();
        try {
            this.zad.edit().clear().apply();
            return;
        }
        finally {
            this.zac.unlock();
        }
    }

    private static String zab(String string, String string2) {
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }
}

