/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.GoogleSignInOptionsExtensionParcelable;
import com.google.android.gms.auth.api.signin.internal.HashAccumulator;
import com.google.android.gms.auth.api.signin.zac;
import com.google.android.gms.auth.api.signin.zad;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInOptionsCreator")
public class GoogleSignInOptions
extends AbstractSafeParcelable
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zaa = new Scope("profile");
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zab = new Scope("email");
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zac = new Scope("openid");
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zad = new Scope("https://www.googleapis.com/auth/games_lite");
    @VisibleForTesting
    @RecentlyNonNull
    public static final Scope zae = new Scope("https://www.googleapis.com/auth/games");
    @RecentlyNonNull
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    @RecentlyNonNull
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(zad, new Scope[0]).build();
    @RecentlyNonNull
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zad();
    @SafeParcelable.VersionField(id=1)
    private final int zaf;
    @SafeParcelable.Field(id=2, getter="getScopes")
    private final ArrayList<Scope> zag;
    @SafeParcelable.Field(id=3, getter="getAccount")
    @Nullable
    private Account zah;
    @SafeParcelable.Field(id=4, getter="isIdTokenRequested")
    private boolean zai;
    @SafeParcelable.Field(id=5, getter="isServerAuthCodeRequested")
    private final boolean zaj;
    @SafeParcelable.Field(id=6, getter="isForceCodeForRefreshToken")
    private final boolean zak;
    @SafeParcelable.Field(id=7, getter="getServerClientId")
    @Nullable
    private String zal;
    @SafeParcelable.Field(id=8, getter="getHostedDomain")
    @Nullable
    private String zam;
    @SafeParcelable.Field(id=9, getter="getExtensions")
    private ArrayList<GoogleSignInOptionsExtensionParcelable> zan;
    @SafeParcelable.Field(id=10, getter="getLogSessionId")
    @Nullable
    private String zao;
    private Map<Integer, GoogleSignInOptionsExtensionParcelable> zap;
    private static Comparator<Scope> zaq = new zac();

    @RecentlyNullable
    public static GoogleSignInOptions zaa(@Nullable String string) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string2 = jSONObject.has("accountName") ? jSONObject.optString("accountName") : null;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            account = new Account(string2, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.has("serverClientId") ? jSONObject.optString("serverClientId") : null, jSONObject.has("hostedDomain") ? jSONObject.optString("hostedDomain") : null, new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>(), null);
    }

    @SafeParcelable.Constructor
    GoogleSignInOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ArrayList<Scope> arrayList, @SafeParcelable.Param(id=3) @Nullable Account account, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) boolean bl3, @SafeParcelable.Param(id=7) @Nullable String string, @SafeParcelable.Param(id=8) @Nullable String string2, @SafeParcelable.Param(id=9) ArrayList<GoogleSignInOptionsExtensionParcelable> arrayList2, @SafeParcelable.Param(id=10) @Nullable String string3) {
        this(n, arrayList, account, bl, bl2, bl3, string, string2, GoogleSignInOptions.zab(arrayList2), string3);
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, @Nullable Account account, boolean bl, boolean bl2, boolean bl3, @Nullable String string, @Nullable String string2, Map<Integer, GoogleSignInOptionsExtensionParcelable> map, @Nullable String string3) {
        this.zaf = n;
        this.zag = arrayList;
        this.zah = account;
        this.zai = bl;
        this.zaj = bl2;
        this.zak = bl3;
        this.zal = string;
        this.zam = string2;
        this.zan = new ArrayList<GoogleSignInOptionsExtensionParcelable>(map.values());
        this.zap = map;
        this.zao = string3;
    }

    @KeepForSdk
    @RecentlyNonNull
    public ArrayList<Scope> getScopes() {
        return new ArrayList<Scope>(this.zag);
    }

    @RecentlyNonNull
    public Scope[] getScopeArray() {
        return this.zag.toArray(new Scope[this.zag.size()]);
    }

    @KeepForSdk
    @RecentlyNullable
    public Account getAccount() {
        return this.zah;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean isIdTokenRequested() {
        return this.zai;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean isServerAuthCodeRequested() {
        return this.zaj;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean isForceCodeForRefreshToken() {
        return this.zak;
    }

    @KeepForSdk
    @RecentlyNullable
    public String getServerClientId() {
        return this.zal;
    }

    @KeepForSdk
    @RecentlyNullable
    public String getLogSessionId() {
        return this.zao;
    }

    @KeepForSdk
    @RecentlyNonNull
    public ArrayList<GoogleSignInOptionsExtensionParcelable> getExtensions() {
        return this.zan;
    }

    private static Map<Integer, GoogleSignInOptionsExtensionParcelable> zab(@Nullable List<GoogleSignInOptionsExtensionParcelable> list) {
        HashMap<Integer, GoogleSignInOptionsExtensionParcelable> hashMap = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        if (list == null) {
            return hashMap;
        }
        for (GoogleSignInOptionsExtensionParcelable googleSignInOptionsExtensionParcelable : list) {
            hashMap.put(googleSignInOptionsExtensionParcelable.getType(), googleSignInOptionsExtensionParcelable);
        }
        return hashMap;
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, @RecentlyNonNull int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)googleSignInOptions.zaf);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)2, googleSignInOptions.getScopes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.getAccount(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.isIdTokenRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.isServerAuthCodeRequested());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.isForceCodeForRefreshToken());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)googleSignInOptions.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)googleSignInOptions.zam, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)9, googleSignInOptions.getExtensions(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)googleSignInOptions.getLogSessionId(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @RecentlyNonNull
    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zan.size() > 0 || googleSignInOptions.zan.size() > 0) {
                return false;
            }
            if (this.zag.size() != googleSignInOptions.getScopes().size() || !this.zag.containsAll(googleSignInOptions.getScopes())) {
                return false;
            }
            return (this.zah == null ? googleSignInOptions.getAccount() == null : this.zah.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zal) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.getServerClientId()) : this.zal.equals(googleSignInOptions.getServerClientId())) && this.zak == googleSignInOptions.isForceCodeForRefreshToken() && this.zai == googleSignInOptions.isIdTokenRequested() && this.zaj == googleSignInOptions.isServerAuthCodeRequested() && TextUtils.equals((CharSequence)this.zao, (CharSequence)googleSignInOptions.getLogSessionId());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @RecentlyNonNull
    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zag;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.getScopeUri());
        }
        Collections.sort(arrayList);
        return new HashAccumulator().addObject(arrayList).addObject(this.zah).addObject(this.zal).zaa(this.zak).zaa(this.zai).zaa(this.zaj).addObject(this.zao).hash();
    }

    @RecentlyNonNull
    public final String zaa() {
        return this.zab().toString();
    }

    private final JSONObject zab() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zag, zaq);
            ArrayList<Scope> arrayList = this.zag;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.getScopeUri());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zah != null) {
                jSONObject.put("accountName", (Object)this.zah.name);
            }
            jSONObject.put("idTokenRequested", this.zai);
            jSONObject.put("forceCodeForRefreshToken", this.zak);
            jSONObject.put("serverAuthRequested", this.zaj);
            if (!TextUtils.isEmpty((CharSequence)this.zal)) {
                jSONObject.put("serverClientId", (Object)this.zal);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zam)) {
                jSONObject.put("hostedDomain", (Object)this.zam);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string, String string2, Map map, String string3, zac zac2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string, string2, map, string3);
    }

    public static final class Builder {
        private Set<Scope> zaa = new HashSet<Scope>();
        private boolean zab;
        private boolean zac;
        private boolean zad;
        @Nullable
        private String zae;
        @Nullable
        private Account zaf;
        @Nullable
        private String zag;
        private Map<Integer, GoogleSignInOptionsExtensionParcelable> zah = new HashMap<Integer, GoogleSignInOptionsExtensionParcelable>();
        @Nullable
        private String zai;

        public Builder() {
        }

        public Builder(@RecentlyNonNull GoogleSignInOptions googleSignInOptions) {
            Preconditions.checkNotNull((Object)googleSignInOptions);
            this.zaa = new HashSet<Scope>(googleSignInOptions.zag);
            this.zab = googleSignInOptions.zaj;
            this.zac = googleSignInOptions.zak;
            this.zad = googleSignInOptions.zai;
            this.zae = googleSignInOptions.zal;
            this.zaf = googleSignInOptions.zah;
            this.zag = googleSignInOptions.zam;
            this.zah = GoogleSignInOptions.zab(googleSignInOptions.zan);
            this.zai = googleSignInOptions.zao;
        }

        @RecentlyNonNull
        public final Builder requestId() {
            this.zaa.add(zac);
            return this;
        }

        @RecentlyNonNull
        public final Builder requestEmail() {
            this.zaa.add(zab);
            return this;
        }

        @RecentlyNonNull
        public final Builder requestProfile() {
            this.zaa.add(zaa);
            return this;
        }

        @RecentlyNonNull
        public final Builder requestScopes(@RecentlyNonNull Scope scope, Scope ... scopeArray) {
            this.zaa.add(scope);
            this.zaa.addAll(Arrays.asList(scopeArray));
            return this;
        }

        @RecentlyNonNull
        public final Builder requestIdToken(@RecentlyNonNull String string) {
            this.zad = true;
            this.zae = this.zaa(string);
            return this;
        }

        @RecentlyNonNull
        public final Builder requestServerAuthCode(@RecentlyNonNull String string) {
            return this.requestServerAuthCode(string, false);
        }

        @RecentlyNonNull
        public final Builder requestServerAuthCode(@RecentlyNonNull String string, @RecentlyNonNull boolean bl) {
            this.zab = true;
            this.zae = this.zaa(string);
            this.zac = bl;
            return this;
        }

        @RecentlyNonNull
        public final Builder setAccountName(@RecentlyNonNull String string) {
            this.zaf = new Account(Preconditions.checkNotEmpty((String)string), "com.google");
            return this;
        }

        @RecentlyNonNull
        public final Builder setHostedDomain(@RecentlyNonNull String string) {
            this.zag = Preconditions.checkNotEmpty((String)string);
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public final Builder setLogSessionId(@RecentlyNonNull String string) {
            this.zai = string;
            return this;
        }

        @RecentlyNonNull
        public final Builder addExtension(@RecentlyNonNull GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zah.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            List<Scope> list = googleSignInOptionsExtension.getImpliedScopes();
            if (list != null) {
                this.zaa.addAll(list);
            }
            this.zah.put(googleSignInOptionsExtension.getExtensionType(), new GoogleSignInOptionsExtensionParcelable(googleSignInOptionsExtension));
            return this;
        }

        @RecentlyNonNull
        public final GoogleSignInOptions build() {
            if (this.zaa.contains(zae) && this.zaa.contains(zad)) {
                this.zaa.remove(zad);
            }
            if (this.zad && (this.zaf == null || !this.zaa.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zaa), this.zaf, this.zad, this.zab, this.zac, this.zae, this.zag, this.zah, this.zai, null);
        }

        private final String zaa(String string) {
            Preconditions.checkNotEmpty((String)string);
            Preconditions.checkArgument((this.zae == null || this.zae.equals(string) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string;
        }
    }
}

