/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FastSafeParcelableJsonResponse;
import com.google.android.gms.common.server.response.zak;
import com.google.android.gms.common.server.response.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.MapUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@VisibleForTesting
@SafeParcelable.Class(creator="SafeParcelResponseCreator")
@KeepForSdk
public class SafeParcelResponse
extends FastSafeParcelableJsonResponse {
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int zalf;
    @SafeParcelable.Field(id=2, getter="getParcel")
    private final Parcel zarb;
    private final int zarc;
    @SafeParcelable.Field(id=3, getter="getFieldMappingDictionary")
    private final zak zapz;
    private final String mClassName;
    private int zard;
    private int zare;
    @KeepForSdk
    public static final Parcelable.Creator<SafeParcelResponse> CREATOR = new zap();

    public SafeParcelResponse(zak zak2, String string2) {
        this.zalf = 1;
        this.zarb = Parcel.obtain();
        this.zarc = 0;
        this.zapz = (zak)((Object)Preconditions.checkNotNull((Object)((Object)zak2)));
        this.mClassName = (String)Preconditions.checkNotNull((Object)string2);
        this.zard = 0;
    }

    private SafeParcelResponse(SafeParcelable safeParcelable, zak zak2, String string2) {
        this.zalf = 1;
        this.zarb = Parcel.obtain();
        safeParcelable.writeToParcel(this.zarb, 0);
        this.zarc = 1;
        this.zapz = (zak)((Object)Preconditions.checkNotNull((Object)((Object)zak2)));
        this.mClassName = (String)Preconditions.checkNotNull((Object)string2);
        this.zard = 2;
    }

    @KeepForSdk
    public static <T extends FastJsonResponse> SafeParcelResponse from(T t) {
        String string2 = t.getClass().getCanonicalName();
        T t2 = t;
        zak zak2 = new zak(t2.getClass());
        SafeParcelResponse.zaa(zak2, t2);
        zak2.zacs();
        zak2.zacr();
        zak zak3 = zak2;
        return new SafeParcelResponse((SafeParcelable)t, zak3, string2);
    }

    private static void zaa(zak zak2, FastJsonResponse fastJsonResponse) {
        Class<?> clazz = fastJsonResponse.getClass();
        if (!zak2.zaa(clazz)) {
            Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.getFieldMappings();
            zak2.zaa(clazz, map);
            for (String string2 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string2);
                Class<? extends FastJsonResponse> clazz2 = field.zapx;
                if (clazz2 == null) continue;
                try {
                    FastJsonResponse fastJsonResponse2 = clazz2.newInstance();
                    SafeParcelResponse.zaa(zak2, fastJsonResponse2);
                }
                catch (InstantiationException instantiationException) {
                    String string3 = String.valueOf(field.zapx.getCanonicalName());
                    throw new IllegalStateException(string3.length() != 0 ? "Could not instantiate an object of type ".concat(string3) : new String("Could not instantiate an object of type "), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    String string4 = String.valueOf(field.zapx.getCanonicalName());
                    throw new IllegalStateException(string4.length() != 0 ? "Could not access object of type ".concat(string4) : new String("Could not access object of type "), illegalAccessException);
                }
            }
        }
    }

    @SafeParcelable.Constructor
    SafeParcelResponse(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) Parcel parcel, @SafeParcelable.Param(id=3) zak zak2) {
        this.zalf = n;
        this.zarb = (Parcel)Preconditions.checkNotNull((Object)parcel);
        this.zarc = 2;
        this.zapz = zak2;
        this.mClassName = this.zapz == null ? null : this.zapz.zact();
        this.zard = 2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zak zak2;
        Parcel parcel2 = parcel;
        SafeParcelResponse safeParcelResponse = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)safeParcelResponse.zalf);
        SafeParcelWriter.writeParcel((Parcel)parcel2, (int)2, (Parcel)safeParcelResponse.zacu(), (boolean)false);
        SafeParcelResponse safeParcelResponse2 = safeParcelResponse;
        switch (safeParcelResponse2.zarc) {
            case 0: {
                zak2 = null;
                break;
            }
            case 1: {
                zak2 = safeParcelResponse2.zapz;
                break;
            }
            case 2: {
                zak2 = safeParcelResponse2.zapz;
                break;
            }
            default: {
                int n3 = safeParcelResponse2.zarc;
                throw new IllegalStateException(new StringBuilder(34).append("Invalid creation type: ").append(n3).toString());
            }
        }
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)zak2, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final Parcel zacu() {
        switch (this.zard) {
            case 0: {
                this.zare = SafeParcelWriter.beginObjectHeader((Parcel)this.zarb);
            }
            case 1: {
                SafeParcelWriter.finishObjectHeader((Parcel)this.zarb, (int)this.zare);
                this.zard = 2;
            }
        }
        return this.zarb;
    }

    @Override
    public Map<String, FastJsonResponse.Field<?, ?>> getFieldMappings() {
        if (this.zapz == null) {
            return null;
        }
        return this.zapz.zai(this.mClassName);
    }

    @Override
    public Object getValueObject(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public boolean isPrimitiveFieldSet(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    private final void zab(FastJsonResponse.Field<?, ?> field) {
        if (!(field.zapw != -1)) {
            throw new IllegalStateException("Field does not have a valid safe parcelable field id.");
        }
        if (this.zarb == null) {
            throw new IllegalStateException("Internal Parcel object is null.");
        }
        switch (this.zard) {
            case 0: {
                this.zare = SafeParcelWriter.beginObjectHeader((Parcel)this.zarb);
                this.zard = 1;
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                throw new IllegalStateException("Attempted to parse JSON with a SafeParcelResponse object that is already filled with data.");
            }
        }
        throw new IllegalStateException("Unknown parse state in SafeParcelResponse.");
    }

    @Override
    protected void setIntegerInternal(FastJsonResponse.Field<?, ?> field, String string2, int n) {
        this.zab(field);
        SafeParcelWriter.writeInt((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (int)n);
    }

    @Override
    protected final void zaa(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Integer> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeIntArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (int[])nArray, (boolean)true);
    }

    @Override
    protected final void zaa(FastJsonResponse.Field<?, ?> field, String string2, BigInteger bigInteger) {
        this.zab(field);
        SafeParcelWriter.writeBigInteger((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (BigInteger)bigInteger, (boolean)true);
    }

    @Override
    protected final void zab(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<BigInteger> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        BigInteger[] bigIntegerArray = new BigInteger[n];
        for (int i = 0; i < n; ++i) {
            bigIntegerArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBigIntegerArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (BigInteger[])bigIntegerArray, (boolean)true);
    }

    @Override
    protected void setLongInternal(FastJsonResponse.Field<?, ?> field, String string2, long l) {
        this.zab(field);
        SafeParcelWriter.writeLong((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (long)l);
    }

    @Override
    protected final void zac(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Long> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeLongArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (long[])lArray, (boolean)true);
    }

    @Override
    protected final void zaa(FastJsonResponse.Field<?, ?> field, String string2, float f) {
        this.zab(field);
        SafeParcelWriter.writeFloat((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (float)f);
    }

    @Override
    protected final void zad(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Float> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = arrayList.get(i).floatValue();
        }
        SafeParcelWriter.writeFloatArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (float[])fArray, (boolean)true);
    }

    @Override
    protected final void zaa(FastJsonResponse.Field<?, ?> field, String string2, double d) {
        this.zab(field);
        SafeParcelWriter.writeDouble((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (double)d);
    }

    @Override
    protected final void zae(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Double> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeDoubleArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (double[])dArray, (boolean)true);
    }

    @Override
    protected final void zaa(FastJsonResponse.Field<?, ?> field, String string2, BigDecimal bigDecimal) {
        this.zab(field);
        SafeParcelWriter.writeBigDecimal((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (BigDecimal)bigDecimal, (boolean)true);
    }

    @Override
    protected final void zaf(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<BigDecimal> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        for (int i = 0; i < n; ++i) {
            bigDecimalArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBigDecimalArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (BigDecimal[])bigDecimalArray, (boolean)true);
    }

    @Override
    protected void setBooleanInternal(FastJsonResponse.Field<?, ?> field, String string2, boolean bl) {
        this.zab(field);
        SafeParcelWriter.writeBoolean((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (boolean)bl);
    }

    @Override
    protected final void zag(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<Boolean> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeBooleanArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (boolean[])blArray, (boolean)true);
    }

    @Override
    protected void setStringInternal(FastJsonResponse.Field<?, ?> field, String string2, String string3) {
        this.zab(field);
        SafeParcelWriter.writeString((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (String)string3, (boolean)true);
    }

    @Override
    protected void setStringsInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<String> arrayList) {
        this.zab(field);
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = arrayList.get(i);
        }
        SafeParcelWriter.writeStringArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (String[])stringArray, (boolean)true);
    }

    @Override
    protected void setDecodedBytesInternal(FastJsonResponse.Field<?, ?> field, String string2, byte[] byArray) {
        this.zab(field);
        SafeParcelWriter.writeByteArray((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (byte[])byArray, (boolean)true);
    }

    @Override
    protected final void zaa(FastJsonResponse.Field<?, ?> field, String string2, Map<String, String> map) {
        this.zab(field);
        Bundle bundle = new Bundle();
        for (String string3 : map.keySet()) {
            bundle.putString(string3, map.get(string3));
        }
        SafeParcelWriter.writeBundle((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (Bundle)bundle, (boolean)true);
    }

    @Override
    public <T extends FastJsonResponse> void addConcreteTypeInternal(FastJsonResponse.Field<?, ?> field, String string2, T t) {
        this.zab(field);
        Parcel parcel = ((SafeParcelResponse)t).zacu();
        SafeParcelWriter.writeParcel((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), (Parcel)parcel, (boolean)true);
    }

    @Override
    public <T extends FastJsonResponse> void addConcreteTypeArrayInternal(FastJsonResponse.Field<?, ?> field, String string2, ArrayList<T> arrayList) {
        this.zab(field);
        ArrayList<Parcel> arrayList2 = new ArrayList<Parcel>();
        arrayList.size();
        ArrayList<T> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            T t = arrayList3.get(i);
            FastJsonResponse fastJsonResponse = (FastJsonResponse)t;
            arrayList2.add(((SafeParcelResponse)fastJsonResponse).zacu());
        }
        SafeParcelWriter.writeParcelList((Parcel)this.zarb, (int)field.getSafeParcelableFieldId(), arrayList2, (boolean)true);
    }

    @Override
    public String toString() {
        Preconditions.checkNotNull((Object)((Object)this.zapz), (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.zacu();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zaa(stringBuilder, this.zapz.zai(this.mClassName), parcel);
        return stringBuilder.toString();
    }

    private final void zaa(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        Object object = map;
        Object object2 = new SparseArray();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> object3 : object.entrySet()) {
            object2.put(object3.getValue().getSafeParcelableFieldId(), object3);
        }
        SparseArray sparseArray = object2;
        stringBuilder.append('{');
        int n = SafeParcelReader.validateObjectHeader((Parcel)parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            block51: {
                Object object3;
                Object object4;
                Object object5;
                FastJsonResponse.Field field;
                Parcel parcel2;
                int n2;
                FastJsonResponse.Field field2;
                Parcel parcel3;
                int n3;
                block50: {
                    int n4 = SafeParcelReader.readHeader((Parcel)parcel);
                    int n5 = SafeParcelReader.getFieldId((int)n4);
                    Map.Entry entry = (Map.Entry)sparseArray.get(n5);
                    if (entry == null) continue;
                    if (bl) {
                        stringBuilder.append(",");
                    }
                    n3 = n4;
                    parcel3 = parcel;
                    field2 = (FastJsonResponse.Field)((Object)entry.getValue());
                    String string2 = (String)entry.getKey();
                    object2 = stringBuilder;
                    object = this;
                    ((StringBuilder)object2).append("\"").append(string2).append("\":");
                    if (!field2.zacn()) break block50;
                    n2 = n3;
                    parcel2 = parcel3;
                    field = field2;
                    object5 = object2;
                    object4 = object;
                    switch (field.zapt) {
                        case 0: {
                            int l = SafeParcelReader.readInt((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, l));
                            break block51;
                        }
                        case 1: {
                            BigInteger f = SafeParcelReader.createBigInteger((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, f));
                            break block51;
                        }
                        case 2: {
                            long d = SafeParcelReader.readLong((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, d));
                            break block51;
                        }
                        case 3: {
                            float bigDecimal = SafeParcelReader.readFloat((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, Float.valueOf(bigDecimal)));
                            break block51;
                        }
                        case 4: {
                            double bl2 = SafeParcelReader.readDouble((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, bl2));
                            break block51;
                        }
                        case 5: {
                            BigDecimal string3 = SafeParcelReader.createBigDecimal((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, string3));
                            break block51;
                        }
                        case 6: {
                            boolean byArray = SafeParcelReader.readBoolean((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, byArray));
                            break block51;
                        }
                        case 7: {
                            String n7 = SafeParcelReader.createString((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, n7));
                            break block51;
                        }
                        case 8: 
                        case 9: {
                            byte[] objectArray = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, objectArray));
                            break block51;
                        }
                        case 10: {
                            Bundle bundle = SafeParcelReader.createBundle((Parcel)parcel2, (int)n2);
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            for (String string3 : bundle.keySet()) {
                                hashMap.put(string3, bundle.getString(string3));
                            }
                            object3 = hashMap;
                            super.zab((StringBuilder)object5, field, SafeParcelResponse.zab(field, object3));
                            break block51;
                        }
                        case 11: {
                            throw new IllegalArgumentException("Method does not accept concrete type.");
                        }
                        default: {
                            int n9 = field.zapt;
                            throw new IllegalArgumentException(new StringBuilder(36).append("Unknown field out type = ").append(n9).toString());
                        }
                    }
                }
                n2 = n3;
                parcel2 = parcel3;
                field = field2;
                object5 = object2;
                object4 = object;
                if (field.zapu) {
                    ((StringBuilder)object5).append("[");
                    switch (field.zapt) {
                        case 0: {
                            Object[] bigInteger = SafeParcelReader.createIntArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (int[])bigInteger);
                            break;
                        }
                        case 1: {
                            Object[] bigInteger = SafeParcelReader.createBigIntegerArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (Object[])bigInteger);
                            break;
                        }
                        case 2: {
                            Object[] bigInteger = SafeParcelReader.createLongArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (long[])bigInteger);
                            break;
                        }
                        case 3: {
                            Object[] bigInteger = SafeParcelReader.createFloatArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (float[])bigInteger);
                            break;
                        }
                        case 4: {
                            Object[] bigInteger = SafeParcelReader.createDoubleArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (double[])bigInteger);
                            break;
                        }
                        case 5: {
                            Object[] bigInteger = SafeParcelReader.createBigDecimalArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (Object[])bigInteger);
                            break;
                        }
                        case 6: {
                            Object[] bigInteger = SafeParcelReader.createBooleanArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeArray((StringBuilder)object5, (boolean[])bigInteger);
                            break;
                        }
                        case 7: {
                            Object[] bigInteger = SafeParcelReader.createStringArray((Parcel)parcel2, (int)n2);
                            ArrayUtils.writeStringArray((StringBuilder)object5, (String[])bigInteger);
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                        }
                        case 11: {
                            Parcel[] parcelArray = SafeParcelReader.createParcelArray((Parcel)parcel2, (int)n2);
                            Object[] bigInteger = parcelArray;
                            int n6 = parcelArray.length;
                            for (int i = 0; i < n6; ++i) {
                                if (i > 0) {
                                    ((StringBuilder)object5).append(",");
                                }
                                bigInteger[i].setDataPosition(0);
                                super.zaa((StringBuilder)object5, field.zacq(), (Parcel)bigInteger[i]);
                            }
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown field type out.");
                        }
                    }
                    ((StringBuilder)object5).append("]");
                } else {
                    switch (field.zapt) {
                        case 0: {
                            int l = SafeParcelReader.readInt((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(l);
                            break;
                        }
                        case 1: {
                            BigInteger f = SafeParcelReader.createBigInteger((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(f);
                            break;
                        }
                        case 2: {
                            long d = SafeParcelReader.readLong((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(d);
                            break;
                        }
                        case 3: {
                            float bigDecimal = SafeParcelReader.readFloat((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(bigDecimal);
                            break;
                        }
                        case 4: {
                            double bl3 = SafeParcelReader.readDouble((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(bl3);
                            break;
                        }
                        case 5: {
                            BigDecimal string5 = SafeParcelReader.createBigDecimal((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(string5);
                            break;
                        }
                        case 6: {
                            boolean byArray = SafeParcelReader.readBoolean((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append(byArray);
                            break;
                        }
                        case 7: {
                            String byArray = SafeParcelReader.createString((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(JsonUtils.escapeString((String)byArray)).append("\"");
                            break;
                        }
                        case 8: {
                            byte[] bundle = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(Base64Utils.encode((byte[])bundle)).append("\"");
                            break;
                        }
                        case 9: {
                            byte[] parcel4 = SafeParcelReader.createByteArray((Parcel)parcel2, (int)n2);
                            ((StringBuilder)object5).append("\"").append(Base64Utils.encodeUrlSafe((byte[])parcel4));
                            ((StringBuilder)object5).append("\"");
                            break;
                        }
                        case 10: {
                            Bundle bundle = SafeParcelReader.createBundle((Parcel)parcel2, (int)n2);
                            object3 = bundle.keySet();
                            object3.size();
                            ((StringBuilder)object5).append("{");
                            boolean bl2 = true;
                            Iterator iterator = object3.iterator();
                            while (iterator.hasNext()) {
                                String string3;
                                string3 = (String)iterator.next();
                                if (!bl2) {
                                    ((StringBuilder)object5).append(",");
                                }
                                bl2 = false;
                                ((StringBuilder)object5).append("\"").append(string3).append("\"");
                                ((StringBuilder)object5).append(":");
                                ((StringBuilder)object5).append("\"").append(JsonUtils.escapeString((String)bundle.getString(string3))).append("\"");
                            }
                            ((StringBuilder)object5).append("}");
                            break;
                        }
                        case 11: {
                            Parcel parcel4 = SafeParcelReader.createParcel((Parcel)parcel2, (int)n2);
                            parcel4.setDataPosition(0);
                            super.zaa((StringBuilder)object5, field.zacq(), parcel4);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown field type out");
                        }
                    }
                }
            }
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new SafeParcelReader.ParseException(new StringBuilder(37).append("Overread allowed size end=").append(n).toString(), parcel);
        }
        stringBuilder.append('}');
    }

    private final void zab(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.zaps) {
            ArrayList arrayList = (ArrayList)object;
            FastJsonResponse.Field<?, ?> field2 = field;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append("[");
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuilder2.append(",");
                }
                SafeParcelResponse.zaa(stringBuilder2, field2.zapr, arrayList.get(i));
            }
            stringBuilder2.append("]");
            return;
        }
        SafeParcelResponse.zaa(stringBuilder, field.zapr, object);
    }

    private static void zaa(StringBuilder stringBuilder, int n, Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                return;
            }
            case 7: {
                stringBuilder.append("\"").append(JsonUtils.escapeString((String)object.toString())).append("\"");
                return;
            }
            case 8: {
                stringBuilder.append("\"").append(Base64Utils.encode((byte[])((byte[])object))).append("\"");
                return;
            }
            case 9: {
                stringBuilder.append("\"").append(Base64Utils.encodeUrlSafe((byte[])((byte[])object)));
                stringBuilder.append("\"");
                return;
            }
            case 10: {
                MapUtils.writeStringMapToJson((StringBuilder)stringBuilder, (HashMap)((HashMap)object));
                return;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
        }
        throw new IllegalArgumentException(new StringBuilder(26).append("Unknown type = ").append(n).toString());
    }
}

