/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabt;
import com.google.android.gms.common.api.internal.zacm;
import com.google.android.gms.common.api.internal.zacp;
import com.google.android.gms.common.api.internal.zaj;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zas;
import com.google.android.gms.common.api.internal.zax;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientEventManager;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zaaw
extends GoogleApiClient
implements zabt {
    private final Lock zaeo;
    private boolean zach;
    private final GmsClientEventManager zags;
    private zabs zagt = null;
    private final int zacb;
    private final Context mContext;
    private final Looper zabj;
    @VisibleForTesting
    final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zafc = new LinkedList();
    private volatile boolean zagu;
    private long zagv = ClientLibraryUtils.isPackageSide() ? 10000L : 120000L;
    private long zagw = 5000L;
    private final zabb zagx;
    private final GoogleApiAvailability zacd;
    @VisibleForTesting
    private zabq zagy;
    final Map<Api.AnyClientKey<?>, Api.Client> zagz;
    Set<Scope> zaha = new HashSet<Scope>();
    private final ClientSettings zaet;
    private final Map<Api<?>, Boolean> zaew;
    private final Api.AbstractClientBuilder<? extends zad, SignInOptions> zace;
    private final ListenerHolders zahb = new ListenerHolders();
    private final ArrayList<zaq> zahc;
    private Integer zahd = null;
    Set<zacm> zahe = null;
    final zacp zahf;
    private final GmsClientEventManager.GmsClientEventState zahg = new zaax(this);

    public zaaw(Context context, Lock lock, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.AnyClientKey<?>, Api.Client> map2, int n, int n2, ArrayList<zaq> arrayList, boolean bl) {
        this.mContext = context;
        this.zaeo = lock;
        this.zach = false;
        this.zags = new GmsClientEventManager(looper, this.zahg);
        this.zabj = looper;
        this.zagx = new zabb(this, looper);
        this.zacd = googleApiAvailability;
        this.zacb = n;
        if (this.zacb >= 0) {
            this.zahd = n2;
        }
        this.zaew = map;
        this.zagz = map2;
        this.zahc = arrayList;
        this.zahf = new zacp(this.zagz);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zags.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zags.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zaet = clientSettings;
        this.zace = abstractClientBuilder;
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zagz.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zaeo.lock();
        try {
            if (this.zagt == null) {
                this.zafc.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zagt.enqueue(t);
            return (T)string2;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zagz.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zaeo.lock();
        try {
            if (this.zagt == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zagu) {
                this.zafc.add(t);
                while (!this.zafc.isEmpty()) {
                    object = this.zafc.remove();
                    this.zahf.zab((BasePendingResult<? extends Result>)object);
                    ((BaseImplementation.ApiMethodImpl)object).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                object = t;
                return (T)object;
            }
            object = this.zagt.execute(t);
            return (T)object;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L l) {
        this.zaeo.lock();
        try {
            Looper looper = this.zabj;
            L l2 = l;
            ListenerHolder<L> listenerHolder = this.zahb.zaa(l2, looper, "NO_TYPE");
            return listenerHolder;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = this.zagz.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zagz.containsKey(api.getClientKey());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.Client client = this.zagz.get(api.getClientKey());
        return client != null && client.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zaeo.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zagu) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zagz.containsKey(api.getClientKey())) break block6;
                    connectionResult = this.zagt.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zagu) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.RESULT_SUCCESS;
                    this.zaeo.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zaay());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zaeo.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zaeo.lock();
        try {
            if (this.zacb >= 0) {
                Preconditions.checkState((this.zahd != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahd == null) {
                this.zahd = zaaw.zaa(this.zagz.values(), false);
            } else if (this.zahd == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zahd);
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zaeo.lock();
        try {
            Preconditions.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zae(n);
            this.zaau();
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zaeo.lock();
        try {
            if (this.zacb >= 0) {
                Preconditions.checkState((this.zahd != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zahd == null) {
                this.zahd = zaaw.zaa(this.zagz.values(), false);
            } else if (this.zahd == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahd);
            this.zags.enableCallbacks();
            ConnectionResult connectionResult = this.zagt.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zaeo.lock();
        try {
            if (this.zahd == null) {
                this.zahd = zaaw.zaa(this.zagz.values(), false);
            } else if (this.zahd == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zae(this.zahd);
            this.zags.enableCallbacks();
            ConnectionResult connectionResult = this.zagt.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zaeo.lock();
        try {
            this.zahf.release();
            if (this.zagt != null) {
                this.zagt.disconnect();
            }
            this.zahb.release();
            for (BaseImplementation.ApiMethodImpl apiMethodImpl : this.zafc) {
                apiMethodImpl.zaa(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zafc.clear();
            if (this.zagt == null) {
                return;
            }
            this.zaaw();
            this.zags.disableCallbacks();
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Preconditions.checkState((this.zahd != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zagz.containsKey(Common.CLIENT_KEY)) {
            this.zaa(this, statusPendingResult, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zaay zaay2 = new zaay(this, atomicReference, statusPendingResult);
            zaaz zaaz2 = new zaaz(this, statusPendingResult);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(Common.API).addConnectionCallbacks(zaay2).addOnConnectionFailedListener(zaaz2).setHandler(this.zagx).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return statusPendingResult;
    }

    private final void zaa(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.zapi.zaa(googleApiClient).setResultCallback(new zaba(this, statusPendingResult, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        zaaw zaaw2 = this;
        if (zaaw2.zacb >= 0) {
            zaj.zaa(lifecycleActivity).zaa(zaaw2.zacb);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zagt != null && this.zagt.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zagt != null && this.zagt.isConnecting();
    }

    private final void zae(int n) {
        if (this.zahd == null) {
            this.zahd = n;
        } else if (this.zahd != n) {
            String string2 = zaaw.zaf(n);
            String string3 = zaaw.zaf(this.zahd);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zagt != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.Client client : this.zagz.values()) {
            if (client.requiresSignIn()) {
                bl = true;
            }
            if (!client.providesSignIn()) continue;
            bl2 = true;
        }
        switch (this.zahd) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zach) {
                    this.zagt = new zax(this.mContext, this.zaeo, this.zabj, this.zacd, this.zagz, this.zaet, this.zaew, this.zace, this.zahc, this, true);
                    return;
                }
                this.zagt = zas.zaa(this.mContext, this, this.zaeo, this.zabj, this.zacd, this.zagz, this.zaet, this.zaew, this.zace, this.zahc);
                return;
            }
        }
        if (this.zach && !bl2) {
            this.zagt = new zax(this.mContext, this.zaeo, this.zabj, this.zacd, this.zagz, this.zaet, this.zaew, this.zace, this.zahc, this, false);
            return;
        }
        this.zagt = new zabe(this.mContext, this, this.zaeo, this.zabj, this.zacd, this.zagz, this.zaet, this.zaew, this.zace, this.zahc, this);
    }

    @GuardedBy(value="mLock")
    private final void zaau() {
        this.zags.enableCallbacks();
        this.zagt.connect();
    }

    private final void resume() {
        this.zaeo.lock();
        try {
            if (this.zagu) {
                this.zaau();
            }
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    private final void zaav() {
        this.zaeo.lock();
        try {
            if (this.zaaw()) {
                this.zaau();
            }
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @GuardedBy(value="mLock")
    final boolean zaaw() {
        if (!this.zagu) {
            return false;
        }
        this.zagu = false;
        this.zagx.removeMessages(2);
        this.zagx.removeMessages(1);
        if (this.zagy != null) {
            this.zagy.unregister();
            this.zagy = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zags.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zags.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zags.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zags.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zags.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zags.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(Bundle bundle) {
        while (!this.zafc.isEmpty()) {
            ((GoogleApiClient)this).execute(this.zafc.remove());
        }
        this.zags.onConnectionSuccess(bundle);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zac(ConnectionResult connectionResult) {
        if (!this.zacd.isPlayServicesPossiblyUpdating(this.mContext, connectionResult.getErrorCode())) {
            this.zaaw();
        }
        if (!this.zagu) {
            this.zags.onConnectionFailure(connectionResult);
            this.zags.disableCallbacks();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zab(int n, boolean bl) {
        if (n == 1 && !bl) {
            zaaw zaaw2 = this;
            if (!zaaw2.zagu) {
                zaaw2.zagu = true;
                if (zaaw2.zagy == null && !ClientLibraryUtils.isPackageSide()) {
                    zaaw2.zagy = zaaw2.zacd.zaa(zaaw2.mContext.getApplicationContext(), new zabc(zaaw2));
                }
                zaaw2.zagx.sendMessageDelayed(zaaw2.zagx.obtainMessage(1), zaaw2.zagv);
                zaaw2.zagx.sendMessageDelayed(zaaw2.zagx.obtainMessage(2), zaaw2.zagw);
            }
        }
        this.zahf.zabx();
        this.zags.onUnintentionalDisconnection(n);
        this.zags.disableCallbacks();
        if (n == 2) {
            this.zaau();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zabj;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return this.zagt != null && this.zagt.maybeSignIn(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        if (this.zagt != null) {
            this.zagt.maybeSignOut();
        }
    }

    @Override
    public final void zaa(zacm zacm2) {
        this.zaeo.lock();
        try {
            if (this.zahe == null) {
                this.zahe = new HashSet<zacm>();
            }
            this.zahe.add(zacm2);
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final void zab(zacm zacm2) {
        this.zaeo.lock();
        try {
            if (this.zahe == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zahe.remove(zacm2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zaax()) {
                this.zagt.zaw();
            }
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    final boolean zaax() {
        this.zaeo.lock();
        try {
            if (this.zahe == null) {
                return false;
            }
            boolean bl = !this.zahe.isEmpty();
            return bl;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    final String zaay() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zagu);
        printWriter.append(" mWorkQueue.size()=").print(this.zafc.size());
        PrintWriter printWriter2 = printWriter;
        zacp zacp2 = this.zahf;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zacp2.zakz.size());
        if (this.zagt != null) {
            this.zagt.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zaa(Iterable<Api.Client> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.Client client : iterable) {
            if (client.requiresSignIn()) {
                bl2 = true;
            }
            if (!client.providesSignIn()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zaf(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zaa(zaaw zaaw2) {
        zaaw2.resume();
    }

    static /* synthetic */ void zab(zaaw zaaw2) {
        zaaw2.zaav();
    }

    static /* synthetic */ void zaa(zaaw zaaw2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zaaw2.zaa(googleApiClient, statusPendingResult, true);
    }

    static /* synthetic */ Context zac(zaaw zaaw2) {
        return zaaw2.mContext;
    }
}

