/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.base.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.SignInButtonCreator;
import com.google.android.gms.common.internal.SignInButtonImpl;
import com.google.android.gms.dynamic.RemoteCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int COLOR_AUTO = 2;
    private int mSize;
    private int mColor;
    private View zaas;
    private View.OnClickListener zaat = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SignInButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        AttributeSet attributeSet2 = attributeSet;
        Context context2 = context;
        SignInButton signInButton = this;
        TypedArray typedArray = context2.getTheme().obtainStyledAttributes(attributeSet2, R.styleable.SignInButton, 0, 0);
        try {
            signInButton.mSize = typedArray.getInt(R.styleable.SignInButton_buttonSize, 0);
            signInButton.mColor = typedArray.getInt(R.styleable.SignInButton_colorScheme, 2);
        }
        finally {
            typedArray.recycle();
        }
        this.setStyle(this.mSize, this.mColor);
    }

    public final void setSize(int n) {
        this.setStyle(n, this.mColor);
    }

    public final void setColorScheme(int n) {
        this.setStyle(this.mSize, n);
    }

    @Deprecated
    public final void setScopes(Scope[] scopeArray) {
        this.setStyle(this.mSize, this.mColor);
    }

    public final void setStyle(int n, int n2) {
        this.mSize = n;
        this.mColor = n2;
        Context context = this.getContext();
        SignInButton signInButton = this;
        if (signInButton.zaas != null) {
            signInButton.removeView(signInButton.zaas);
        }
        try {
            signInButton.zaas = SignInButtonCreator.createView(context, signInButton.mSize, signInButton.mColor);
        }
        catch (RemoteCreator.RemoteCreatorException remoteCreatorException) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            int n3 = signInButton.mColor;
            int n4 = signInButton.mSize;
            Context context2 = context;
            SignInButtonImpl signInButtonImpl = new SignInButtonImpl(context2);
            signInButtonImpl.configure(context2.getResources(), n4, n3);
            signInButton.zaas = signInButtonImpl;
        }
        signInButton.addView(signInButton.zaas);
        signInButton.zaas.setEnabled(signInButton.isEnabled());
        signInButton.zaas.setOnClickListener((View.OnClickListener)signInButton);
    }

    @Deprecated
    public final void setStyle(int n, int n2, Scope[] scopeArray) {
        this.setStyle(n, n2);
    }

    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zaat = onClickListener;
        if (this.zaas != null) {
            this.zaas.setOnClickListener((View.OnClickListener)this);
        }
    }

    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.zaas.setEnabled(bl);
    }

    public final void onClick(View view) {
        if (this.zaat != null && view == this.zaas) {
            this.zaat.onClick((View)this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }
}

