/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.zaa;
import com.google.android.gms.auth.api.signin.zab;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="GoogleSignInAccountCreator")
public class GoogleSignInAccount
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zab();
    @VisibleForTesting
    private static Clock zae = DefaultClock.getInstance();
    @SafeParcelable.VersionField(id=1)
    private final int versionCode;
    @SafeParcelable.Field(id=2, getter="getId")
    private String mId;
    @SafeParcelable.Field(id=3, getter="getIdToken")
    private String zaf;
    @SafeParcelable.Field(id=4, getter="getEmail")
    private String zag;
    @SafeParcelable.Field(id=5, getter="getDisplayName")
    private String zah;
    @SafeParcelable.Field(id=6, getter="getPhotoUrl")
    private Uri zai;
    @SafeParcelable.Field(id=7, getter="getServerAuthCode")
    private String zaj;
    @SafeParcelable.Field(id=8, getter="getExpirationTimeSecs")
    private long zak;
    @SafeParcelable.Field(id=9, getter="getObfuscatedIdentifier")
    private String zal;
    @SafeParcelable.Field(id=10)
    private List<Scope> zam;
    @SafeParcelable.Field(id=11, getter="getGivenName")
    private String zan;
    @SafeParcelable.Field(id=12, getter="getFamilyName")
    private String zao;
    private Set<Scope> zap = new HashSet<Scope>();

    @Nullable
    public static GoogleSignInAccount zaa(@Nullable String string) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string);
        Uri uri = null;
        String string2 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            uri = Uri.parse((String)string2);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        String string3 = jSONObject.optString("serverAuthCode", null);
        GoogleSignInAccount googleSignInAccount = GoogleSignInAccount.zaa(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet);
        GoogleSignInAccount.zaa(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zaj = string3;
        return googleSignInAccount;
    }

    private static GoogleSignInAccount zaa(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Uri uri, @Nullable Long l, @NonNull String string7, @NonNull Set<Scope> set) {
        if (l == null) {
            l = zae.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(3, string, string2, string3, string4, uri, null, l, Preconditions.checkNotEmpty((String)string7), new ArrayList<Scope>((Collection)Preconditions.checkNotNull(set)), string5, string6);
    }

    @KeepForSdk
    public static GoogleSignInAccount createDefault() {
        HashSet<Scope> hashSet = new HashSet<Scope>();
        Account account = new Account("<<default account>>", "com.google");
        return GoogleSignInAccount.zaa(null, null, account.name, null, null, null, null, 0L, account.name, hashSet);
    }

    @SafeParcelable.Constructor
    GoogleSignInAccount(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) Uri uri, @SafeParcelable.Param(id=7) String string5, @SafeParcelable.Param(id=8) long l, @SafeParcelable.Param(id=9) String string6, @SafeParcelable.Param(id=10) List<Scope> list, @SafeParcelable.Param(id=11) String string7, @SafeParcelable.Param(id=12) String string8) {
        this.versionCode = n;
        this.mId = string;
        this.zaf = string2;
        this.zag = string3;
        this.zah = string4;
        this.zai = uri;
        this.zaj = string5;
        this.zak = l;
        this.zal = string6;
        this.zam = list;
        this.zan = string7;
        this.zao = string8;
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    @Nullable
    public String getIdToken() {
        return this.zaf;
    }

    @Nullable
    public String getEmail() {
        return this.zag;
    }

    @Nullable
    public Account getAccount() {
        if (this.zag == null) {
            return null;
        }
        return new Account(this.zag, "com.google");
    }

    @Nullable
    public String getDisplayName() {
        return this.zah;
    }

    @Nullable
    public String getGivenName() {
        return this.zan;
    }

    @Nullable
    public String getFamilyName() {
        return this.zao;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zai;
    }

    @KeepForSdk
    public GoogleSignInAccount requestExtraScopes(Scope ... scopeArray) {
        if (scopeArray != null) {
            Collections.addAll(this.zap, scopeArray);
        }
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zaj;
    }

    @KeepForSdk
    public boolean isExpired() {
        return zae.currentTimeMillis() / 1000L >= this.zak - 300L;
    }

    @NonNull
    public final String zab() {
        return this.zal;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zam);
    }

    @NonNull
    @KeepForSdk
    public Set<Scope> getRequestedScopes() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zam);
        hashSet.addAll(this.zap);
        return hashSet;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInAccount googleSignInAccount = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)googleSignInAccount.versionCode);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)googleSignInAccount.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)googleSignInAccount.getIdToken(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)googleSignInAccount.getEmail(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)googleSignInAccount.getDisplayName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)6, (Parcelable)googleSignInAccount.getPhotoUrl(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)googleSignInAccount.getServerAuthCode(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)8, (long)googleSignInAccount.zak);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)googleSignInAccount.zal, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)10, googleSignInAccount.zam, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)11, (String)googleSignInAccount.getGivenName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)12, (String)googleSignInAccount.getFamilyName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return (527 + this.zal.hashCode()) * 31 + this.getRequestedScopes().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zal.equals(this.zal) && googleSignInAccount.getRequestedScopes().equals(this.getRequestedScopes());
    }

    public final String zac() {
        JSONObject jSONObject = this.zad();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private final JSONObject zad() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zak);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zal);
            JSONArray jSONArray = new JSONArray();
            Scope[] scopeArray = this.zam.toArray(new Scope[this.zam.size()]);
            Arrays.sort(scopeArray, zaa.zaq);
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                jSONArray.put((Object)scope.getScopeUri());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    static final /* synthetic */ int zaa(Scope scope, Scope scope2) {
        return scope.getScopeUri().compareTo(scope2.getScopeUri());
    }
}

