/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzp;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.auth.api.signin.zze;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zzbfm
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzehi = new Scope("profile");
    public static final Scope zzehj = new Scope("email");
    public static final Scope zzehk = new Scope("openid");
    public static final Scope SCOPE_GAMES_LITE = new Scope("https://www.googleapis.com/auth/games_lite");
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES_LITE, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zze();
    private int versionCode;
    private final ArrayList<Scope> zzehl;
    private Account zzebz;
    private boolean zzefl;
    private final boolean zzehm;
    private final boolean zzehn;
    private String zzefm;
    private String zzeho;
    private ArrayList<zzn> zzehp;
    private Map<Integer, zzn> zzehq;
    private static Comparator<Scope> zzehr = new zzd();

    @Nullable
    public static GoogleSignInOptions zzev(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzx(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzehl = arrayList;
        this.zzebz = account;
        this.zzefl = bl;
        this.zzehm = bl2;
        this.zzehn = bl3;
        this.zzefm = string2;
        this.zzeho = string3;
        this.zzehp = new ArrayList<zzn>(map.values());
        this.zzehq = map;
    }

    public final ArrayList<Scope> zzabe() {
        return new ArrayList<Scope>(this.zzehl);
    }

    public Scope[] getScopeArray() {
        return this.zzehl.toArray(new Scope[this.zzehl.size()]);
    }

    public final Account getAccount() {
        return this.zzebz;
    }

    public final boolean isIdTokenRequested() {
        return this.zzefl;
    }

    public final boolean zzabf() {
        return this.zzehm;
    }

    public final String getServerClientId() {
        return this.zzefm;
    }

    private static Map<Integer, zzn> zzx(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        zzbfp.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzabe(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzebz, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzefl);
        zzbfp.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzehm);
        zzbfp.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzehn);
        zzbfp.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzefm, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzeho, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzehp, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzehp.size() > 0 || googleSignInOptions.zzehp.size() > 0) {
                return false;
            }
            if (this.zzehl.size() != googleSignInOptions.zzabe().size() || !this.zzehl.containsAll(googleSignInOptions.zzabe())) {
                return false;
            }
            return (this.zzebz == null ? googleSignInOptions.zzebz == null : this.zzebz.equals((Object)googleSignInOptions.zzebz)) && (TextUtils.isEmpty((CharSequence)this.zzefm) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzefm) : this.zzefm.equals(googleSignInOptions.zzefm)) && this.zzehn == googleSignInOptions.zzehn && this.zzefl == googleSignInOptions.zzefl && this.zzehm == googleSignInOptions.zzehm;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzehl;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzagw());
        }
        Collections.sort(arrayList);
        return new zzp().zzs(arrayList).zzs(this.zzebz).zzs(this.zzefm).zzar(this.zzehn).zzar(this.zzefl).zzar(this.zzehm).zzabn();
    }

    public final String zzabg() {
        return this.toJsonObject().toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzehl, zzehr);
            ArrayList<Scope> arrayList = this.zzehl;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzagw());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzebz != null) {
                jSONObject.put("accountName", (Object)this.zzebz.name);
            }
            jSONObject.put("idTokenRequested", this.zzefl);
            jSONObject.put("forceCodeForRefreshToken", this.zzehn);
            jSONObject.put("serverAuthRequested", this.zzehm);
            if (!TextUtils.isEmpty((CharSequence)this.zzefm)) {
                jSONObject.put("serverClientId", (Object)this.zzefm);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzeho)) {
                jSONObject.put("hostedDomain", (Object)this.zzeho);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzd zzd2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzehs = new HashSet<Scope>();
        private boolean zzehm;
        private boolean zzehn;
        private boolean zzefl;
        private String zzefm;
        private Account zzebz;
        private String zzeho;
        private Map<Integer, zzn> zzeht = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbq.checkNotNull((Object)googleSignInOptions);
            this.zzehs = new HashSet<Scope>(googleSignInOptions.zzehl);
            this.zzehm = googleSignInOptions.zzehm;
            this.zzehn = googleSignInOptions.zzehn;
            this.zzefl = googleSignInOptions.zzefl;
            this.zzefm = googleSignInOptions.zzefm;
            this.zzebz = googleSignInOptions.zzebz;
            this.zzeho = googleSignInOptions.zzeho;
            this.zzeht = GoogleSignInOptions.zzx(googleSignInOptions.zzehp);
        }

        public final Builder requestId() {
            this.zzehs.add(zzehk);
            return this;
        }

        public final Builder requestEmail() {
            this.zzehs.add(zzehj);
            return this;
        }

        public final Builder requestProfile() {
            this.zzehs.add(zzehi);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzehs.add(scope);
            this.zzehs.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzefl = true;
            this.zzefm = this.zzew(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzehm = true;
            this.zzefm = this.zzew(string2);
            this.zzehn = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzebz = new Account(zzbq.zzgm((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzeho = zzbq.zzgm((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzeht.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            if (googleSignInOptionsExtension.getImpliedScopes() != null) {
                this.zzehs.addAll(googleSignInOptionsExtension.getImpliedScopes());
            }
            this.zzeht.put(googleSignInOptionsExtension.getExtensionType(), new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzehs.contains(SCOPE_GAMES) && this.zzehs.contains(SCOPE_GAMES_LITE)) {
                this.zzehs.remove(SCOPE_GAMES_LITE);
            }
            if (this.zzefl && (this.zzebz == null || !this.zzehs.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzehs), this.zzebz, this.zzefl, this.zzehm, this.zzehn, this.zzefm, this.zzeho, this.zzeht, null);
        }

        private final String zzew(String string2) {
            zzbq.zzgm((String)string2);
            zzbq.checkArgument((this.zzefm == null || this.zzefm.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

