/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzaq;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzs<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzfly = new zzt();
    private final Object zzflz = new Object();
    private zzu<R> zzfma;
    private WeakReference<GoogleApiClient> zzfmb;
    private final CountDownLatch zzaoi = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzfmc = new ArrayList();
    private ResultCallback<? super R> zzfmd;
    private final AtomicReference<zzdo> zzfme = new AtomicReference();
    private R zzfkk;
    private Status mStatus;
    private zzv zzfmf;
    private volatile boolean zzfmg;
    private boolean zzaj;
    private boolean zzfmh;
    private zzaq zzfmi;
    private volatile zzdi<R> zzfmj;
    private boolean zzfmk = false;

    @Deprecated
    zzs() {
        this.zzfma = new zzu(Looper.getMainLooper());
        this.zzfmb = new WeakReference<Object>(null);
    }

    protected zzs(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfma = new zzu(looper);
        this.zzfmb = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzs(Looper looper) {
        this.zzfma = new zzu(looper);
        this.zzfmb = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzaoi.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzbq.zza((!this.zzfmg ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbq.zza((this.zzfmj == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzaoi.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzv(Status.zzfkp);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzbq.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzbq.zza((!this.zzfmg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbq.zza((this.zzfmj == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzaoi.await(l, timeUnit)) {
                this.zzv(Status.zzfkr);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzv(Status.zzfkp);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzflz;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfmd = null;
                return;
            }
            zzbq.zza((!this.zzfmg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfmj == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfma.zza(resultCallback, (R)this.get());
            } else {
                this.zzfmd = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzflz;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfmd = null;
                return;
            }
            zzbq.zza((!this.zzfmg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfmj == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfma.zza(resultCallback, (R)this.get());
            } else {
                this.zzfmd = resultCallback;
                long l2 = timeUnit.toMillis(l);
                zzs zzs2 = this;
                zzu<R> zzu2 = this.zzfma;
                zzu2.sendMessageDelayed(zzu2.obtainMessage(2, zzs2), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbq.checkArgument((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzflz;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzr(this.mStatus);
            } else {
                this.zzfmc.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzflz;
        synchronized (object) {
            if (this.zzaj || this.zzfmg) {
                return;
            }
            if (this.zzfmi != null) {
                try {
                    this.zzfmi.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzs.zzd(this.zzfkk);
            this.zzaj = true;
            this.zzc(this.zzb(Status.zzfks));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzagv() {
        Object object = this.zzflz;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfmb.get() == null || !this.zzfmk) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzflz;
        synchronized (object) {
            return this.zzaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbq.zza((!this.zzfmg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzflz;
        synchronized (object) {
            zzbq.zza((this.zzfmj == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzfmd == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbq.zza((!this.zzaj ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfmk = true;
            this.zzfmj = new zzdi(this.zzfmb);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfmj).then(resultTransform);
            if (this.isReady()) {
                this.zzfma.zza(this.zzfmj, this.get());
            } else {
                this.zzfmd = this.zzfmj;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzflz;
        synchronized (object) {
            if (!this.zzfmh && !this.zzaj) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzs.zzd(r);
                return;
            }
            zzbq.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbq.zza((!this.zzfmg ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzv(Status status) {
        Object object = this.zzflz;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzfmh = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzdo zzdo2) {
        this.zzfme.set(zzdo2);
    }

    @Override
    public final Integer zzagi() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzaq zzaq2) {
        Object object = this.zzflz;
        synchronized (object) {
            this.zzfmi = zzaq2;
            return;
        }
    }

    public final void zzagw() {
        this.zzfmk = this.zzfmk || zzfly.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzflz;
        synchronized (object) {
            zzbq.zza((!this.zzfmg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzfkk;
            this.zzfkk = null;
            this.zzfmd = null;
            this.zzfmg = true;
        }
        zzs zzs2 = this;
        zzdo zzdo2 = zzs2.zzfme.getAndSet(null);
        if (zzdo2 != null) {
            zzdo2.zzc(zzs2);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzfkk = r;
        this.zzfmi = null;
        this.zzaoi.countDown();
        this.mStatus = this.zzfkk.getStatus();
        if (this.zzaj) {
            this.zzfmd = null;
        } else if (this.zzfmd == null) {
            if (this.zzfkk instanceof Releasable) {
                this.zzfmf = new zzv(this, null);
            }
        } else {
            this.zzfma.removeMessages(2);
            this.zzfma.zza(this.zzfmd, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzfmc;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzr(this.mStatus);
        }
        this.zzfmc.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ Result zza(zzs zzs2) {
        return zzs2.zzfkk;
    }
}

