/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzo;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.internal.zzbq;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzi
extends zzo {
    private final SparseArray<zza> zzfld = new SparseArray();

    public static zzi zza(zzch zzch2) {
        zzci zzci2 = zzi.zzb((zzch)zzch2);
        zzi zzi2 = (zzi)zzci2.zza("AutoManageHelper", zzi.class);
        if (zzi2 != null) {
            return zzi2;
        }
        return new zzi(zzci2);
    }

    private zzi(zzci zzci2) {
        super(zzci2);
        this.zzfrj.zza("AutoManageHelper", (LifecycleCallback)this);
    }

    public final void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzbq.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzbq.zza((this.zzfld.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        zzp zzp2 = (zzp)this.zzflq.get();
        boolean bl = this.mStarted;
        String string = String.valueOf(zzp2);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(49 + String.valueOf(string).length()).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(string).toString());
        zza zza2 = new zza(this, n, googleApiClient, onConnectionFailedListener);
        this.zzfld.put(n, (Object)zza2);
        if (this.mStarted && zzp2 == null) {
            string = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string).length()).append("connecting ").append(string).toString());
            googleApiClient.connect();
        }
    }

    public final void zzbr(int n) {
        zza zza2 = (zza)this.zzfld.get(n);
        this.zzfld.remove(n);
        if (zza2 != null) {
            zza zza3 = zza2;
            zza3.zzflf.unregisterConnectionFailedListener(zza3);
            zza3.zzflf.disconnect();
        }
    }

    @Override
    public final void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzfld);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (this.zzflq.get() == null) {
            for (n = 0; n < this.zzfld.size(); ++n) {
                object = this.zzbs(n);
                if (object == null) continue;
                ((zza)object).zzflf.connect();
            }
        }
    }

    @Override
    public final void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzfld.size(); ++i) {
            zza zza2 = this.zzbs(i);
            if (zza2 == null) continue;
            zza2.zzflf.disconnect();
        }
    }

    public final void dump(String string, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzfld.size(); ++i) {
            zza zza2 = this.zzbs(i);
            if (zza2 == null) continue;
            String[] stringArray2 = stringArray;
            PrintWriter printWriter2 = printWriter;
            FileDescriptor fileDescriptor2 = fileDescriptor;
            String string2 = string;
            zza zza3 = zza2;
            printWriter2.append(string2).append("GoogleApiClient #").print(zza3.zzfle);
            printWriter2.println(":");
            zza3.zzflf.dump(String.valueOf(string2).concat("  "), fileDescriptor2, printWriter2, stringArray2);
        }
    }

    @Override
    protected final void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzfld.get(n);
        if (zza2 != null) {
            this.zzbr(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzflg;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected final void zzagm() {
        for (int i = 0; i < this.zzfld.size(); ++i) {
            zza zza2 = this.zzbs(i);
            if (zza2 == null) continue;
            zza2.zzflf.connect();
        }
    }

    @Nullable
    private final zza zzbs(int n) {
        if (this.zzfld.size() <= n) {
            return null;
        }
        return (zza)this.zzfld.get(this.zzfld.keyAt(n));
    }

    final class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzfle;
        public final GoogleApiClient zzflf;
        public final GoogleApiClient.OnConnectionFailedListener zzflg;
        private /* synthetic */ zzi zzflh;

        public zza(zzi zzi2, int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzflh = zzi2;
            this.zzfle = n;
            this.zzflf = googleApiClient;
            this.zzflg = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string).length()).append("beginFailureResolution for ").append(string).toString());
            this.zzflh.zzb(connectionResult, this.zzfle);
        }
    }
}

