/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArraySet;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzak;
import com.google.android.gms.common.api.internal.zzbq;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzc;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzct;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzd;
import com.google.android.gms.common.api.internal.zzdb;
import com.google.android.gms.common.api.internal.zzdf;
import com.google.android.gms.common.api.internal.zzdp;
import com.google.android.gms.common.api.internal.zze;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzbp
implements Handler.Callback {
    public static final Status zzfqe = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzfqf = new Status(4, "The user must be signed in to make this API call.");
    private long zzfpe = 5000L;
    private long zzfpd = 120000L;
    private long zzfqg = 10000L;
    private static final Object sLock = new Object();
    private static zzbp zzfqh;
    private final Context mContext;
    private final GoogleApiAvailability zzfke;
    private int zzfqi = -1;
    private final AtomicInteger zzfqj = new AtomicInteger(1);
    private final AtomicInteger zzfqk = new AtomicInteger(0);
    private final Map<zzh<?>, zzbr<?>> zzfne = new ConcurrentHashMap(5, 0.75f, 1);
    private zzak zzfql = null;
    private final Set<zzh<?>> zzfqm = new ArraySet();
    private final Set<zzh<?>> zzfqn = new ArraySet();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbp zzch(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzfqh == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzfqh = new zzbp(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzfqh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbp zzaie() {
        Object object = sLock;
        synchronized (object) {
            com.google.android.gms.common.internal.zzbq.checkNotNull((Object)zzfqh, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzfqh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzaif() {
        Object object = sLock;
        synchronized (object) {
            if (zzfqh != null) {
                zzbp zzbp2 = zzfqh;
                zzbp2.zzfqk.incrementAndGet();
                zzbp2.mHandler.sendMessageAtFrontOfQueue(zzbp2.mHandler.obtainMessage(10));
            }
            return;
        }
    }

    private zzbp(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzfke = googleApiAvailability;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
    }

    public final int zzaig() {
        return this.zzfqj.getAndIncrement();
    }

    public final void zza(GoogleApi<?> googleApi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzb(GoogleApi<?> googleApi) {
        zzh<?> zzh2 = googleApi.zzaga();
        zzbr<Object> zzbr2 = this.zzfne.get(zzh2);
        if (zzbr2 == null) {
            zzbr2 = new zzbr(this, googleApi);
            this.zzfne.put(zzh2, zzbr2);
        }
        if (zzbr2.zzaam()) {
            this.zzfqn.add(zzh2);
        }
        zzbr2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzak zzak2) {
        Object object = sLock;
        synchronized (object) {
            if (this.zzfql != zzak2) {
                this.zzfql = zzak2;
                this.zzfqm.clear();
                this.zzfqm.addAll((Collection<zzh<?>>)zzak2.zzahl());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzak zzak2) {
        Object object = sLock;
        synchronized (object) {
            if (this.zzfql == zzak2) {
                this.zzfql = null;
                this.zzfqm.clear();
            }
            return;
        }
    }

    public final Task<Void> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzj zzj2 = new zzj(iterable);
        for (GoogleApi<?> googleApi : iterable) {
            zzbr<?> zzbr2 = this.zzfne.get(googleApi.zzaga());
            if (zzbr2 != null && zzbr2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)zzj2));
            return zzj2.getTask();
        }
        zzj2.zzago();
        return zzj2.getTask();
    }

    public final void zzagm() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    final void zzagf() {
        this.zzfqk.incrementAndGet();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
    }

    @WorkerThread
    private final void zzaih() {
        for (zzh<?> zzh2 : this.zzfqn) {
            this.zzfne.remove(zzh2).signOut();
        }
        this.zzfqn.clear();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, zzm<? extends Result, Api.zzb> zzm2) {
        zzc<zzm<? extends Result, Api.zzb>> zzc2 = new zzc<zzm<? extends Result, Api.zzb>>(n, zzm2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzcs(zzc2, this.zzfqk.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, TResult> void zza(GoogleApi<O> googleApi, int n, zzdf<Api.zzb, TResult> zzdf2, TaskCompletionSource<TResult> taskCompletionSource, zzdb zzdb2) {
        zze<TResult> zze2 = new zze<TResult>(n, zzdf2, taskCompletionSource, zzdb2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzcs(zze2, this.zzfqk.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzct<Api.zzb, ?> zzct2, @NonNull zzdp<Api.zzb, ?> zzdp2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd zzd2 = new zzd(new zzcu(zzct2, zzdp2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)new zzcs(zzd2, this.zzfqk.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzcn<?> zzcn2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzf zzf2 = new zzf(zzcn2, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, (Object)new zzcs(zzf2, this.zzfqk.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                zzbp zzbp2 = this;
                this.zzfqg = bl ? 10000L : 300000L;
                zzbp2.mHandler.removeMessages(12);
                for (zzh<?> zzh2 : zzbp2.zzfne.keySet()) {
                    zzbp2.mHandler.sendMessageDelayed(zzbp2.mHandler.obtainMessage(12, zzh2), zzbp2.zzfqg);
                }
                break;
            }
            case 2: {
                zzj zzj2 = (zzj)message.obj;
                zzbp zzbp3 = this;
                for (zzh<?> zzh3 : zzj2.zzagn()) {
                    zzbr<?> zzbr2 = zzbp3.zzfne.get(zzh3);
                    if (zzbr2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzj2.zza(zzh3, connectionResult);
                        break block0;
                    }
                    if (zzbr2.isConnected()) {
                        zzj2.zza(zzh3, ConnectionResult.zzfhy);
                        continue;
                    }
                    if (zzbr2.zzaio() != null) {
                        zzj2.zza(zzh3, zzbr2.zzaio());
                        continue;
                    }
                    zzbr2.zza(zzj2);
                }
                break;
            }
            case 3: {
                for (zzbr<?> zzbr3 : this.zzfne.values()) {
                    zzbr3.zzain();
                    zzbr3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzcs zzcs2 = (zzcs)message.obj;
                zzbp zzbp4 = this;
                zzbr<?> zzbr4 = zzbp4.zzfne.get(zzcs2.zzfrx.zzaga());
                if (zzbr4 == null) {
                    zzbp4.zzb(zzcs2.zzfrx);
                    zzbr4 = zzbp4.zzfne.get(zzcs2.zzfrx.zzaga());
                }
                if (zzbr4.zzaam() && zzbp4.zzfqk.get() != zzcs2.zzfrw) {
                    zzcs2.zzfrv.zzs(zzfqe);
                    zzbr4.signOut();
                    break;
                }
                zzbr4.zza(zzcs2.zzfrv);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                zzbp zzbp5 = this;
                zzbr<?> zzbr5 = null;
                for (zzbr<?> zzbr6 : zzbp5.zzfne.values()) {
                    if (zzbr6.getInstanceId() != n) continue;
                    zzbr5 = zzbr6;
                    break;
                }
                if (zzbr5 != null) {
                    zzbr<?> zzbr6;
                    String string2 = zzbp5.zzfke.getErrorString(connectionResult.getErrorCode());
                    zzbr6 = connectionResult.getErrorMessage();
                    zzbr5.zzw(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zzbr6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zzbr6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                zzbp zzbp6 = this;
                if (!(zzbp6.mContext.getApplicationContext() instanceof Application)) break;
                zzk.zza((Application)((Application)zzbp6.mContext.getApplicationContext()));
                zzk.zzagp().zza((zzl)new zzbq(zzbp6));
                if (zzk.zzagp().zzbd(true)) break;
                zzbp6.zzfqg = 300000L;
                break;
            }
            case 7: {
                this.zzb((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzfne.containsKey(message.obj)) break;
                this.zzfne.get(message.obj).resume();
                break;
            }
            case 10: {
                this.zzaih();
                break;
            }
            case 11: {
                if (!this.zzfne.containsKey(message.obj)) break;
                this.zzfne.get(message.obj).zzahx();
                break;
            }
            case 12: {
                if (!this.zzfne.containsKey(message.obj)) break;
                this.zzfne.get(message.obj).zzair();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzh<?> zzh2, int n) {
        zzbr<?> zzbr2 = this.zzfne.get(zzh2);
        if (zzbr2 == null) {
            return null;
        }
        zzcwb zzcwb2 = zzbr2.zzais();
        if (zzcwb2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)n, (Intent)zzcwb2.getSignInIntent(), (int)0x8000000);
    }

    final boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzfke.zza(this.mContext, connectionResult, n);
    }

    public final void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    static /* synthetic */ Handler zza(zzbp zzbp2) {
        return zzbp2.mHandler;
    }

    static /* synthetic */ Context zzb(zzbp zzbp2) {
        return zzbp2.mContext;
    }

    static /* synthetic */ long zzc(zzbp zzbp2) {
        return zzbp2.zzfpe;
    }

    static /* synthetic */ long zzd(zzbp zzbp2) {
        return zzbp2.zzfpd;
    }

    static /* synthetic */ int zza(zzbp zzbp2, int n) {
        zzbp2.zzfqi = n;
        return zzbp2.zzfqi;
    }

    static /* synthetic */ Status zzaii() {
        return zzfqf;
    }

    static /* synthetic */ Object zzaij() {
        return sLock;
    }

    static /* synthetic */ zzak zze(zzbp zzbp2) {
        return zzbp2.zzfql;
    }

    static /* synthetic */ Set zzf(zzbp zzbp2) {
        return zzbp2.zzfqm;
    }

    static /* synthetic */ GoogleApiAvailability zzg(zzbp zzbp2) {
        return zzbp2.zzfke;
    }

    static /* synthetic */ long zzh(zzbp zzbp2) {
        return zzbp2.zzfqg;
    }

    static /* synthetic */ int zzi(zzbp zzbp2) {
        return zzbp2.zzfqi;
    }

    static /* synthetic */ Map zzj(zzbp zzbp2) {
        return zzbp2.zzfne;
    }
}

