/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzab;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzy
implements zzcf {
    private final Context mContext;
    private final zzbd zzfmy;
    private final Looper zzakm;
    private final zzbl zzfmz;
    private final zzbl zzfna;
    private final Map<Api.zzc<?>, zzbl> zzfnb;
    private final Set<zzcx> zzfnc = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzfnd;
    private Bundle zzfne;
    private ConnectionResult zzfnf = null;
    private ConnectionResult zzfng = null;
    private boolean zzfnh = false;
    private final Lock zzfni;
    private int zzfnj = 0;

    public static zzy zza(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcwb, zzcwc> zza2, ArrayList<zzw> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzaax()) {
                zze3 = object;
            }
            if (object.zzaan()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbq.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzafu();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzw>();
        ArrayList<zzw> arrayList2 = new ArrayList<zzw>();
        ArrayList<zzw> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList3.get(i);
            zzw zzw3 = zzw2;
            if (arrayMap5.containsKey(zzw3.zzfgf)) {
                ((ArrayList)object).add(zzw3);
                continue;
            }
            if (arrayMap.containsKey(zzw3.zzfgf)) {
                arrayList2.add(zzw3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzy(context, zzbd2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzr2, zza2, zze3, (ArrayList<zzw>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzy(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzr zzr2, Api.zza<? extends zzcwb, zzcwc> zza2, Api.zze zze3, ArrayList<zzw> arrayList, ArrayList<zzw> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfmy = zzbd2;
        this.zzfni = lock;
        this.zzakm = looper;
        this.zzfnd = zze3;
        this.zzfmz = new zzbl(context, this.zzfmy, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzaa(this, null));
        this.zzfna = new zzbl(context, this.zzfmy, lock, looper, zze2, map, zzr2, map3, zza2, arrayList, new zzab(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfmz);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfna);
        }
        this.zzfnb = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzahc()) {
                t.zzv(new Status(4, null, this.zzahd()));
                return t;
            }
            return this.zzfna.zzd(t);
        }
        return this.zzfmz.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzahc()) {
                t.zzv(new Status(4, null, this.zzahd()));
                return t;
            }
            return this.zzfna.zze(t);
        }
        return this.zzfmz.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzfnb.get(api.zzafu()).equals(this.zzfna)) {
            if (this.zzahc()) {
                return new ConnectionResult(4, this.zzahd());
            }
            return this.zzfna.getConnectionResult(api);
        }
        return this.zzfmz.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzfnj = 2;
        this.zzfnh = false;
        zzy zzy2 = this;
        this.zzfng = null;
        zzy2.zzfnf = null;
        zzy2.zzfmz.connect();
        zzy2.zzfna.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzfng = null;
        this.zzfnf = null;
        this.zzfnj = 0;
        this.zzfmz.disconnect();
        this.zzfna.disconnect();
        this.zzahb();
    }

    @Override
    public final boolean isConnected() {
        this.zzfni.lock();
        try {
            boolean bl = this.zzfmz.isConnected() && (this.zzfna.isConnected() || this.zzahc() || this.zzfnj == 1);
            return bl;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfni.lock();
        try {
            boolean bl = this.zzfnj == 2;
            return bl;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        this.zzfni.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfna.isConnected()) {
                this.zzfnc.add(zzcx2);
                if (this.zzfnj == 0) {
                    this.zzfnj = 1;
                }
                this.zzfng = null;
                this.zzfna.connect();
                return true;
            }
        }
        finally {
            this.zzfni.unlock();
        }
        return false;
    }

    @Override
    public final void zzagz() {
        this.zzfmz.zzagz();
        this.zzfna.zzagz();
    }

    @Override
    public final void zzagg() {
        this.zzfni.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfna.disconnect();
            this.zzfng = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzakm).post((Runnable)new zzz(this));
            } else {
                this.zzahb();
            }
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    private final void zzaha() {
        if (zzy.zzb(this.zzfnf)) {
            if (zzy.zzb(this.zzfng) || this.zzahc()) {
                zzy zzy2 = this;
                switch (zzy2.zzfnj) {
                    case 2: {
                        zzy2.zzfmy.zzj(zzy2.zzfne);
                    }
                    case 1: {
                        zzy2.zzahb();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzy2.zzfnj = 0;
                return;
            }
            if (this.zzfng != null) {
                if (this.zzfnj == 1) {
                    this.zzahb();
                    return;
                }
                this.zza(this.zzfng);
                this.zzfmz.disconnect();
                return;
            }
        } else {
            if (this.zzfnf != null && zzy.zzb(this.zzfng)) {
                this.zzfna.disconnect();
                this.zza(this.zzfnf);
                return;
            }
            if (this.zzfnf != null && this.zzfng != null) {
                ConnectionResult connectionResult = this.zzfnf;
                if (this.zzfna.zzfqj < this.zzfmz.zzfqj) {
                    connectionResult = this.zzfng;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzfnj) {
            case 2: {
                this.zzfmy.zzc(connectionResult);
            }
            case 1: {
                this.zzahb();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzfnj = 0;
    }

    private final void zzahb() {
        Iterator<zzcx> iterator = this.zzfnc.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzaaw();
        }
        this.zzfnc.clear();
    }

    private final void zze(int n, boolean bl) {
        this.zzfmy.zzf(n, bl);
        this.zzfng = null;
        this.zzfnf = null;
    }

    private final boolean zzahc() {
        return this.zzfng != null && this.zzfng.getErrorCode() == 4;
    }

    private final boolean zzf(zzm<? extends Result, ? extends Api.zzb> zzm2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzm2.zzafu();
        zzbq.checkArgument((boolean)this.zzfnb.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzfnb.get(zzc2).equals(this.zzfna);
    }

    @Nullable
    private final PendingIntent zzahd() {
        if (this.zzfnd == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfmy), (Intent)this.zzfnd.getSignInIntent(), (int)0x8000000);
    }

    private final void zzi(Bundle bundle) {
        if (this.zzfne == null) {
            this.zzfne = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfne.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfna.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfmz.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzy zzy2) {
        return zzy2.zzfni;
    }

    static /* synthetic */ void zzb(zzy zzy2) {
        zzy2.zzaha();
    }

    static /* synthetic */ void zza(zzy zzy2, Bundle bundle) {
        zzy2.zzi(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfnf = connectionResult;
        return zzy2.zzfnf;
    }

    static /* synthetic */ boolean zzc(zzy zzy2) {
        return zzy2.zzfnh;
    }

    static /* synthetic */ ConnectionResult zzd(zzy zzy2) {
        return zzy2.zzfng;
    }

    static /* synthetic */ boolean zza(zzy zzy2, boolean bl) {
        zzy2.zzfnh = bl;
        return zzy2.zzfnh;
    }

    static /* synthetic */ void zza(zzy zzy2, int n, boolean bl) {
        zzy2.zze(n, bl);
    }

    static /* synthetic */ zzbl zze(zzy zzy2) {
        return zzy2.zzfna;
    }

    static /* synthetic */ ConnectionResult zzb(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfng = connectionResult;
        return zzy2.zzfng;
    }

    static /* synthetic */ zzbl zzf(zzy zzy2) {
        return zzy2.zzfmz;
    }
}

