/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzdj;
import com.google.android.gms.common.api.internal.zzdk;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;

public final class zzdi<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzfsn = null;
    private zzdi<? extends Result> zzfso = null;
    private volatile ResultCallbacks<? super R> zzfsp = null;
    private PendingResult<R> zzfsq = null;
    private final Object zzfmj = new Object();
    private Status zzfsr = null;
    private final WeakReference<GoogleApiClient> zzfml;
    private final zzdk zzfss;
    private boolean zzfst = false;

    public zzdi(WeakReference<GoogleApiClient> weakReference) {
        zzbq.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfml = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfml.get();
        this.zzfss = new zzdk(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzfmj;
        synchronized (object) {
            zzbq.zza((this.zzfsn == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzfsp == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfsn = resultTransform;
            zzdi<R> zzdi2 = new zzdi<R>(this.zzfml);
            this.zzfso = zzdi2;
            this.zzajg();
            return zzdi2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzfmj;
        synchronized (object) {
            zzbq.zza((this.zzfsp == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbq.zza((this.zzfsn == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfsp = resultCallbacks;
            this.zzajg();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzfmj;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzfsn != null) {
                    zzcv.zzaie().submit(new zzdj(this, (Result)r));
                } else if (this.zzaji()) {
                    this.zzfsp.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzdi.zzd(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzfmj;
        synchronized (object) {
            this.zzfsq = pendingResult;
            this.zzajg();
            return;
        }
    }

    private final void zzajg() {
        if (this.zzfsn == null && this.zzfsp == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfml.get();
        if (!this.zzfst && this.zzfsn != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzfst = true;
        }
        if (this.zzfsr != null) {
            this.zzy(this.zzfsr);
            return;
        }
        if (this.zzfsq != null) {
            this.zzfsq.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzfmj;
        synchronized (object) {
            this.zzfsr = status;
            this.zzy(this.zzfsr);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzy(Status status) {
        Object object = this.zzfmj;
        synchronized (object) {
            if (this.zzfsn != null) {
                Status status2 = this.zzfsn.onFailure(status);
                zzbq.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzaji()) {
                this.zzfsp.onFailure(status);
            }
            return;
        }
    }

    final void zzajh() {
        this.zzfsp = null;
    }

    private final boolean zzaji() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfml.get();
        return this.zzfsp != null && googleApiClient != null;
    }

    private static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzdi zzdi2) {
        return zzdi2.zzfsn;
    }

    static /* synthetic */ zzdk zzd(zzdi zzdi2) {
        return zzdi2.zzfss;
    }

    static /* synthetic */ void zza(zzdi zzdi2, Result result) {
        zzdi.zzd(result);
    }

    static /* synthetic */ WeakReference zze(zzdi zzdi2) {
        return zzdi2.zzfml;
    }

    static /* synthetic */ Object zzf(zzdi zzdi2) {
        return zzdi2.zzfmj;
    }

    static /* synthetic */ zzdi zzg(zzdi zzdi2) {
        return zzdi2.zzfso;
    }

    static /* synthetic */ void zza(zzdi zzdi2, Status status) {
        zzdi2.zzd(status);
    }
}

