/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzaf;
import com.google.android.gms.common.api.internal.zzag;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbfx;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzad
implements zzcf {
    private final Map<Api.zzc<?>, zzac<?>> zzfno = new HashMap();
    private final Map<Api.zzc<?>, zzac<?>> zzfnp = new HashMap();
    private final Map<Api<?>, Boolean> zzfnq;
    private final zzbp zzfjy;
    private final zzbd zzfnr;
    private final Lock zzfni;
    private final Looper zzakm;
    private final zze zzfns;
    private final Condition zzfnt;
    private final zzr zzfnn;
    private final boolean zzfnu;
    private final boolean zzfnv;
    private final Queue<zzm<?, ?>> zzfnw = new LinkedList();
    private boolean zzfnx;
    private Map<zzh<?>, ConnectionResult> zzfny;
    private Map<zzh<?>, ConnectionResult> zzfnz;
    private zzag zzfoa;
    private ConnectionResult zzfob;

    public zzad(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcwb, zzcwc> zza2, ArrayList<zzw> arrayList, zzbd zzbd2, boolean bl) {
        this.zzfni = lock;
        this.zzakm = looper;
        this.zzfnt = lock.newCondition();
        this.zzfns = zze2;
        this.zzfnr = zzbd2;
        this.zzfnq = map2;
        this.zzfnn = zzr2;
        this.zzfnu = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzafu(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw zzw3 = zzw2;
            hashMap2.put(zzw3.zzfgf, zzw3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzafv()) {
                bl4 = true;
                if (!this.zzfnq.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzw zzw4 = (zzw)hashMap2.get(api);
            zzac zzac2 = new zzac(context, api, looper, zze3, zzw4, zzr2, zza2);
            this.zzfno.put(entry.getKey(), zzac2);
            if (!zze3.zzaan()) continue;
            this.zzfnp.put(entry.getKey(), zzac2);
        }
        this.zzfnv = bl4 && !bl3 && !bl2;
        this.zzfjy = zzbp.zzaif();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzfnu && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzfnw.add(t);
            return t;
        }
        this.zzfnr.zzfpx.zzb(t);
        return this.zzfno.get(t.zzafu()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzafu();
        if (this.zzfnu && this.zzg(t)) {
            return t;
        }
        this.zzfnr.zzfpx.zzb(t);
        return this.zzfno.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzafu();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzv(new Status(4, null, this.zzfjy.zza(this.zzfno.get(zzc2).zzagb(), System.identityHashCode(this.zzfnr))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzfni.lock();
        try {
            if (this.zzfnx) {
                return;
            }
            this.zzfnx = true;
            this.zzfny = null;
            this.zzfnz = null;
            this.zzfoa = null;
            this.zzfob = null;
            this.zzfjy.zzagn();
            this.zzfjy.zza(this.zzfno.values()).addOnCompleteListener((Executor)new zzbfx(this.zzakm), (OnCompleteListener)new zzaf(this, null));
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfnt.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfii;
        }
        if (this.zzfob != null) {
            return this.zzfob;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfnt.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfii;
        }
        if (this.zzfob != null) {
            return this.zzfob;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzfni.lock();
        try {
            this.zzfnx = false;
            this.zzfny = null;
            this.zzfnz = null;
            if (this.zzfoa != null) {
                this.zzfoa.cancel();
                this.zzfoa = null;
            }
            this.zzfob = null;
            while (!this.zzfnw.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzfnw.remove();
                ((zzs)zzm2).zza((zzdo)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfnt.signalAll();
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzafu());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzfni.lock();
        try {
            zzac<?> zzac2 = this.zzfno.get(zzc2);
            if (this.zzfny != null && zzac2 != null) {
                ConnectionResult connectionResult = this.zzfny.get(zzac2.zzagb());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzfni.lock();
        try {
            boolean bl = this.zzfny != null && this.zzfob == null;
            return bl;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfni.lock();
        try {
            boolean bl = this.zzfny == null && this.zzfnx;
            return bl;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    private final boolean zzahf() {
        this.zzfni.lock();
        try {
            if (!this.zzfnx || !this.zzfnu) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzfnp.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        this.zzfni.lock();
        try {
            if (this.zzfnx && !this.zzahf()) {
                this.zzfjy.zzagn();
                this.zzfoa = new zzag(this, zzcx2);
                this.zzfjy.zza(this.zzfnp.values()).addOnCompleteListener((Executor)new zzbfx(this.zzakm), (OnCompleteListener)this.zzfoa);
                return true;
            }
            return false;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void zzagg() {
        this.zzfni.lock();
        try {
            this.zzfjy.zzagg();
            if (this.zzfoa != null) {
                this.zzfoa.cancel();
                this.zzfoa = null;
            }
            if (this.zzfnz == null) {
                this.zzfnz = new ArrayMap(this.zzfnp.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzac<?> zzac2 : this.zzfnp.values()) {
                this.zzfnz.put(zzac2.zzagb(), connectionResult);
            }
            if (this.zzfny != null) {
                this.zzfny.putAll(this.zzfnz);
            }
            return;
        }
        finally {
            this.zzfni.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzagz() {
    }

    private final void zzahg() {
        if (this.zzfnn == null) {
            this.zzfnr.zzfps = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzfnn.zzakk());
        Map<Api<?>, zzt> map = this.zzfnn.zzakm();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzefe);
        }
        this.zzfnr.zzfps = hashSet;
    }

    private final void zzahh() {
        while (!this.zzfnw.isEmpty()) {
            this.zze(this.zzfnw.remove());
        }
        this.zzfnr.zzj(null);
    }

    private final boolean zza(zzac<?> zzac2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzfnq.get(zzac2.zzafz()) != false && zzac2.zzahe().zzafv() && this.zzfns.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzahi() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzac<?> zzac2 : this.zzfno.values()) {
            int n3;
            Api api = zzac2.zzafz();
            zzh zzh2 = zzac2.zzagb();
            ConnectionResult connectionResult3 = this.zzfny.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzfnq.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzfns.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzfnu) {
                n3 = api.zzafs().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzafs().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzad zzad2) {
        return zzad2.zzfni;
    }

    static /* synthetic */ boolean zzb(zzad zzad2) {
        return zzad2.zzfnx;
    }

    static /* synthetic */ Map zza(zzad zzad2, Map map) {
        zzad2.zzfny = map;
        return zzad2.zzfny;
    }

    static /* synthetic */ Map zzc(zzad zzad2) {
        return zzad2.zzfno;
    }

    static /* synthetic */ Map zzd(zzad zzad2) {
        return zzad2.zzfny;
    }

    static /* synthetic */ boolean zze(zzad zzad2) {
        return zzad2.zzfnv;
    }

    static /* synthetic */ boolean zza(zzad zzad2, zzac zzac2, ConnectionResult connectionResult) {
        return zzad2.zza(zzac2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzad zzad2, ConnectionResult connectionResult) {
        zzad2.zzfob = connectionResult;
        return zzad2.zzfob;
    }

    static /* synthetic */ ConnectionResult zzf(zzad zzad2) {
        return zzad2.zzahi();
    }

    static /* synthetic */ Map zzg(zzad zzad2) {
        return zzad2.zzfnz;
    }

    static /* synthetic */ ConnectionResult zzh(zzad zzad2) {
        return zzad2.zzfob;
    }

    static /* synthetic */ void zzi(zzad zzad2) {
        zzad2.zzahg();
    }

    static /* synthetic */ void zzj(zzad zzad2) {
        zzad2.zzahh();
    }

    static /* synthetic */ boolean zza(zzad zzad2, boolean bl) {
        zzad2.zzfnx = false;
        return false;
    }

    static /* synthetic */ zzbd zzk(zzad zzad2) {
        return zzad2.zzfnr;
    }

    static /* synthetic */ Condition zzl(zzad zzad2) {
        return zzad2.zzfnt;
    }

    static /* synthetic */ Map zzb(zzad zzad2, Map map) {
        zzad2.zzfnz = map;
        return zzad2.zzfnz;
    }

    static /* synthetic */ Map zzm(zzad zzad2) {
        return zzad2.zzfnp;
    }
}

