/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzap;
import com.google.android.gms.common.internal.zzbp;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzs<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzfje = new zzt();
    private final Object zzfjf = new Object();
    private zzu<R> zzfjg;
    private WeakReference<GoogleApiClient> zzfjh;
    private final CountDownLatch zzaof = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzfji = new ArrayList();
    private ResultCallback<? super R> zzfjj;
    private final AtomicReference<zzdm> zzfjk = new AtomicReference();
    private R zzfhr;
    private Status mStatus;
    private zzv zzfjl;
    private volatile boolean zzfjm;
    private boolean zzaj;
    private boolean zzfjn;
    private zzap zzfjo;
    private volatile zzdg<R> zzfjp;
    private boolean zzfjq = false;

    @Deprecated
    zzs() {
        this.zzfjg = new zzu(Looper.getMainLooper());
        this.zzfjh = new WeakReference<Object>(null);
    }

    protected zzs(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfjg = new zzu(looper);
        this.zzfjh = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzs(Looper looper) {
        this.zzfjg = new zzu(looper);
        this.zzfjh = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzaof.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzbp.zza((!this.zzfjm ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbp.zza((this.zzfjp == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzaof.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzu(Status.zzfhw);
        }
        zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzbp.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzbp.zza((!this.zzfjm ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbp.zza((this.zzfjp == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzaof.await(l, timeUnit)) {
                this.zzu(Status.zzfhy);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzu(Status.zzfhw);
        }
        zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzfjf;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfjj = null;
                return;
            }
            zzbp.zza((!this.zzfjm ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((this.zzfjp == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfjg.zza(resultCallback, (R)this.get());
            } else {
                this.zzfjj = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzfjf;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfjj = null;
                return;
            }
            zzbp.zza((!this.zzfjm ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((this.zzfjp == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfjg.zza(resultCallback, (R)this.get());
            } else {
                this.zzfjj = resultCallback;
                long l2 = timeUnit.toMillis(l);
                zzs zzs2 = this;
                zzu<R> zzu2 = this.zzfjg;
                zzu2.sendMessageDelayed(zzu2.obtainMessage(2, zzs2), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbp.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzfjf;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzq(this.mStatus);
            } else {
                this.zzfji.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzfjf;
        synchronized (object) {
            if (this.zzaj || this.zzfjm) {
                return;
            }
            if (this.zzfjo != null) {
                try {
                    this.zzfjo.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzs.zzd(this.zzfhr);
            this.zzaj = true;
            this.zzc(this.zzb(Status.zzfhz));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzagf() {
        Object object = this.zzfjf;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfjh.get() == null || !this.zzfjq) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzfjf;
        synchronized (object) {
            return this.zzaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbp.zza((!this.zzfjm ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzfjf;
        synchronized (object) {
            zzbp.zza((this.zzfjp == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbp.zza((this.zzfjj == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbp.zza((!this.zzaj ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfjq = true;
            this.zzfjp = new zzdg(this.zzfjh);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfjp).then(resultTransform);
            if (this.isReady()) {
                this.zzfjg.zza(this.zzfjp, this.get());
            } else {
                this.zzfjj = this.zzfjp;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzfjf;
        synchronized (object) {
            if (!this.zzfjn && !this.zzaj) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzs.zzd(r);
                return;
            }
            zzbp.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbp.zza((!this.zzfjm ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzu(Status status) {
        Object object = this.zzfjf;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzfjn = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzdm zzdm2) {
        this.zzfjk.set(zzdm2);
    }

    @Override
    public final Integer zzafs() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzap zzap2) {
        Object object = this.zzfjf;
        synchronized (object) {
            this.zzfjo = zzap2;
            return;
        }
    }

    public final void zzagg() {
        this.zzfjq = this.zzfjq || zzfje.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzfjf;
        synchronized (object) {
            zzbp.zza((!this.zzfjm ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzfhr;
            this.zzfhr = null;
            this.zzfjj = null;
            this.zzfjm = true;
        }
        zzs zzs2 = this;
        zzdm zzdm2 = zzs2.zzfjk.getAndSet(null);
        if (zzdm2 != null) {
            zzdm2.zzc(zzs2);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzfhr = r;
        this.zzfjo = null;
        this.zzaof.countDown();
        this.mStatus = this.zzfhr.getStatus();
        if (this.zzaj) {
            this.zzfjj = null;
        } else if (this.zzfjj == null) {
            if (this.zzfhr instanceof Releasable) {
                this.zzfjl = new zzv(this, null);
            }
        } else {
            this.zzfjg.removeMessages(2);
            this.zzfjg.zza(this.zzfjj, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzfji;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzq(this.mStatus);
        }
        this.zzfji.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ Result zza(zzs zzs2) {
        return zzs2.zzfhr;
    }
}

