/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzbx;
import com.google.android.gms.internal.zzbam;
import com.google.android.gms.internal.zzbar;
import com.google.android.gms.internal.zzbat;
import com.google.android.gms.internal.zzbav;
import com.google.android.gms.internal.zzbbj;
import com.google.android.gms.internal.zzbbt;
import com.google.android.gms.internal.zzbdb;
import com.google.android.gms.internal.zzbde;
import com.google.android.gms.internal.zzbdf;
import com.google.android.gms.internal.zzbdg;
import com.google.android.gms.internal.zzbdh;
import com.google.android.gms.internal.zzbdy;
import com.google.android.gms.internal.zzbef;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbdd<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzbbj {
    private final Queue<zzbam> zzaEn = new LinkedList<zzbam>();
    private final Api.zze zzaCy;
    private final Api.zzb zzaEo;
    private final zzbat<O> zzaAK;
    private final zzbbt zzaEp;
    private final Set<zzbav> zzaEq = new HashSet<zzbav>();
    private final Map<zzbdy<?>, zzbef> zzaEr = new HashMap();
    private final int zzaEs;
    private final zzbej zzaEt;
    private boolean zzaDA;
    private ConnectionResult zzaEu = null;
    private /* synthetic */ zzbdb zzaEm;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbdd(zzbdb zzbdb2, GoogleApi googleApi) {
        this.zzaEm = zzbdb2;
        this.zzaCy = googleApi.zza(zzbdb.zza(zzbdb2).getLooper(), this);
        if (this.zzaCy instanceof zzbx) {
            zzbx zzbx2 = (zzbx)this.zzaCy;
            this.zzaEo = null;
        } else {
            this.zzaEo = this.zzaCy;
        }
        this.zzaAK = googleApi.zzph();
        this.zzaEp = new zzbbt();
        this.zzaEs = googleApi.getInstanceId();
        if (this.zzaCy.zzmv()) {
            this.zzaEt = googleApi.zza(zzbdb.zzb(zzbdb2), zzbdb.zza(zzbdb2));
            return;
        }
        this.zzaEt = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbdb.zza(this.zzaEm).getLooper()) {
            this.zzqq();
            return;
        }
        zzbdb.zza(this.zzaEm).post((Runnable)new zzbde(this));
    }

    @WorkerThread
    private final void zzqq() {
        this.zzqt();
        this.zzi(ConnectionResult.zzazX);
        this.zzqv();
        for (zzbef zzbef2 : this.zzaEr.values()) {
            try {
                zzbef2.zzaBu.zzb(this.zzaEo, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzaCy.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbdd zzbdd2 = this;
        while (zzbdd2.zzaCy.isConnected() && !zzbdd2.zzaEn.isEmpty()) {
            zzbam zzbam2 = zzbdd2.zzaEn.remove();
            zzbdd2.zzb(zzbam2);
        }
        this.zzqw();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbdb.zza(this.zzaEm).getLooper()) {
            this.zzqr();
            return;
        }
        zzbdb.zza(this.zzaEm).post((Runnable)new zzbdf(this));
    }

    @WorkerThread
    private final void zzqr() {
        this.zzqt();
        this.zzaDA = true;
        this.zzaEp.zzpQ();
        zzbdb.zza(this.zzaEm).sendMessageDelayed(Message.obtain((Handler)zzbdb.zza(this.zzaEm), (int)9, this.zzaAK), zzbdb.zzc(this.zzaEm));
        zzbdb.zza(this.zzaEm).sendMessageDelayed(Message.obtain((Handler)zzbdb.zza(this.zzaEm), (int)11, this.zzaAK), zzbdb.zzd(this.zzaEm));
        zzbdb.zza(this.zzaEm, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        this.zzaCy.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbdb.zza(this.zzaEm).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbdb.zza(this.zzaEm).post((Runnable)new zzbdg(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        if (this.zzaEt != null) {
            this.zzaEt.zzqI();
        }
        this.zzqt();
        zzbdb.zza(this.zzaEm, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzt(zzbdb.zzqo());
            return;
        }
        if (this.zzaEn.isEmpty()) {
            this.zzaEu = connectionResult;
            return;
        }
        Object object = zzbdb.zzqp();
        synchronized (object) {
            if (zzbdb.zze(this.zzaEm) != null && zzbdb.zzf(this.zzaEm).contains(this.zzaAK)) {
                zzbdb.zze(this.zzaEm).zzb(connectionResult, this.zzaEs);
                return;
            }
        }
        if (!this.zzaEm.zzc(connectionResult, this.zzaEs)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzaDA = true;
            }
            if (this.zzaDA) {
                zzbdb.zza(this.zzaEm).sendMessageDelayed(Message.obtain((Handler)zzbdb.zza(this.zzaEm), (int)9, this.zzaAK), zzbdb.zzc(this.zzaEm));
                return;
            }
            object = String.valueOf(this.zzaAK.zzpr());
            this.zzt(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zzbam zzbam2) {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        if (this.zzaCy.isConnected()) {
            this.zzb(zzbam2);
            this.zzqw();
            return;
        }
        this.zzaEn.add(zzbam2);
        if (this.zzaEu != null && this.zzaEu.hasResolution()) {
            this.onConnectionFailed(this.zzaEu);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        this.zzt(zzbdb.zzaEc);
        this.zzaEp.zzpP();
        for (zzbdy<?> zzbdy2 : this.zzaEr.keySet()) {
            this.zza(new zzbar(zzbdy2, (TaskCompletionSource<Void>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzaCy.disconnect();
    }

    public final Api.zze zzpJ() {
        return this.zzaCy;
    }

    public final Map<zzbdy<?>, zzbef> zzqs() {
        return this.zzaEr;
    }

    @WorkerThread
    public final void zzqt() {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        this.zzaEu = null;
    }

    @WorkerThread
    public final ConnectionResult zzqu() {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        return this.zzaEu;
    }

    @WorkerThread
    private final void zzb(zzbam zzbam2) {
        zzbam2.zza(this.zzaEp, this.zzmv());
        try {
            zzbam2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzaCy.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzt(Status status) {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        Iterator iterator = this.zzaEn.iterator();
        while (iterator.hasNext()) {
            ((zzbam)iterator.next()).zzp(status);
        }
        this.zzaEn.clear();
    }

    @WorkerThread
    public final void resume() {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        if (this.zzaDA) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzqv() {
        if (this.zzaDA) {
            zzbdb.zza(this.zzaEm).removeMessages(11, this.zzaAK);
            zzbdb.zza(this.zzaEm).removeMessages(9, this.zzaAK);
            this.zzaDA = false;
        }
    }

    @WorkerThread
    public final void zzqd() {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        if (this.zzaDA) {
            this.zzqv();
            Status status = zzbdb.zzg(this.zzaEm).isGooglePlayServicesAvailable(zzbdb.zzb(this.zzaEm)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzt(status);
            this.zzaCy.disconnect();
        }
    }

    private final void zzqw() {
        zzbdb.zza(this.zzaEm).removeMessages(12, this.zzaAK);
        zzbdb.zza(this.zzaEm).sendMessageDelayed(zzbdb.zza(this.zzaEm).obtainMessage(12, this.zzaAK), zzbdb.zzh(this.zzaEm));
    }

    @WorkerThread
    public final void zzqx() {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        if (this.zzaCy.isConnected() && this.zzaEr.size() == 0) {
            if (this.zzaEp.zzpO()) {
                this.zzqw();
                return;
            }
            this.zzaCy.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        if (this.zzaCy.isConnected() || this.zzaCy.isConnecting()) {
            return;
        }
        if (this.zzaCy.zzpe() && zzbdb.zzi(this.zzaEm) != 0) {
            zzbdb.zza(this.zzaEm, zzbdb.zzg(this.zzaEm).isGooglePlayServicesAvailable(zzbdb.zzb(this.zzaEm)));
            if (zzbdb.zzi(this.zzaEm) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbdb.zzi(this.zzaEm), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbdh zzbdh2 = new zzbdh(this.zzaEm, this.zzaCy, this.zzaAK);
        if (this.zzaCy.zzmv()) {
            this.zzaEt.zza(zzbdh2);
        }
        this.zzaCy.zza(zzbdh2);
    }

    @WorkerThread
    public final void zza(zzbav zzbav2) {
        zzbo.zza((Handler)zzbdb.zza(this.zzaEm));
        this.zzaEq.add(zzbav2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzbav> iterator = this.zzaEq.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzaAK, connectionResult);
        }
        this.zzaEq.clear();
    }

    final boolean isConnected() {
        return this.zzaCy.isConnected();
    }

    public final boolean zzmv() {
        return this.zzaCy.zzmv();
    }

    public final int getInstanceId() {
        return this.zzaEs;
    }

    final zzctk zzqy() {
        if (this.zzaEt == null) {
            return null;
        }
        return this.zzaEt.zzqy();
    }

    static /* synthetic */ void zzc(zzbdd zzbdd2) {
        zzbdd2.zzqq();
    }

    static /* synthetic */ void zzd(zzbdd zzbdd2) {
        zzbdd2.zzqr();
    }
}

