/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzbas;
import com.google.android.gms.internal.zzbat;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbbw;
import com.google.android.gms.internal.zzbdb;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbdj;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.internal.zzbeq;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzayW;
    private final O zzaAJ;
    private final zzbat<O> zzaAK;
    private final Looper zzrM;
    private final int mId;
    private final GoogleApiClient zzaAL;
    private final zzbem zzaAM;
    private final Account zzajb;
    protected final zzbdb zzaAN;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbo.zzb((Object)context, (Object)"Null context is not permitted.");
        zzbo.zzb(api, (Object)"Api must not be null.");
        zzbo.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzayW = api;
        this.zzaAJ = null;
        this.zzrM = looper;
        this.zzaAK = zzbat.zzb(api);
        this.zzaAL = new zzbdj(this);
        this.zzaAN = zzbdb.zzay(this.mContext);
        this.mId = this.zzaAN.zzqm();
        this.zzaAM = new zzbas();
        this.zzajb = null;
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzbem zzbem2) {
        this(context, api, null, new zzd().zza(looper).zza(zzbem2).zzpj());
    }

    @MainThread
    private GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbo.zzb((Object)activity, (Object)"Null activity is not permitted.");
        zzbo.zzb(api, (Object)"Api must not be null.");
        zzbo.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzayW = api;
        this.zzaAJ = null;
        this.zzrM = zza2.zzaAQ;
        this.zzaAK = zzbat.zza(this.zzayW, this.zzaAJ);
        this.zzaAL = new zzbdj(this);
        this.zzaAN = zzbdb.zzay(this.mContext);
        this.mId = this.zzaAN.zzqm();
        this.zzaAM = zza2.zzaAP;
        this.zzajb = zza2.account;
        zzbbw.zza(activity, this.zzaAN, this.zzaAK);
        this.zzaAN.zzb(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbo.zzb((Object)context, (Object)"Null context is not permitted.");
        zzbo.zzb(api, (Object)"Api must not be null.");
        zzbo.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzayW = api;
        this.zzaAJ = o;
        this.zzrM = zza2.zzaAQ;
        this.zzaAK = zzbat.zza(this.zzayW, this.zzaAJ);
        this.zzaAL = new zzbdj(this);
        this.zzaAN = zzbdb.zzay(this.mContext);
        this.mId = this.zzaAN.zzqm();
        this.zzaAM = zza2.zzaAP;
        this.zzajb = zza2.account;
        this.zzaAN.zzb(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzbem zzbem2) {
        this(activity, api, null, new zzd().zza(zzbem2).zza(activity.getMainLooper()).zzpj());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzbem zzbem2) {
        this(context, api, o, new zzd().zza(zzbem2).zzpj());
    }

    private final <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzpC();
        this.zzaAN.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzbeq<A, TResult> zzbeq2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzaAN.zza(this, n, zzbeq2, taskCompletionSource, this.zzaAM);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzbeq<A, TResult> zzbeq2) {
        return this.zza(0, zzbeq2);
    }

    public final <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzbeq<A, TResult> zzbeq2) {
        return this.zza(1, zzbeq2);
    }

    public final <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbdd<O> zzbdd2) {
        zzq zzq2 = new GoogleApiClient.Builder(this.mContext).zze(this.zzajb).zzpn();
        return this.zzayW.zzpc().zza(this.mContext, looper, zzq2, this.zzaAJ, zzbdd2, zzbdd2);
    }

    public final Api<O> zzpg() {
        return this.zzayW;
    }

    public final zzbat<O> zzph() {
        return this.zzaAK;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzpi() {
        return this.zzaAL;
    }

    public final Looper getLooper() {
        return this.zzrM;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    public zzbej zza(Context context, Handler handler) {
        return new zzbej(context, handler);
    }

    public static final class zza {
        public static final zza zzaAO = new zzd().zzpj();
        public final zzbem zzaAP;
        public final Account account;
        public final Looper zzaAQ;

        private zza(zzbem zzbem2, Account account, Looper looper) {
            this.zzaAP = zzbem2;
            this.account = account;
            this.zzaAQ = looper;
        }

        /* synthetic */ zza(zzbem zzbem2, Account account, Looper looper, zzc zzc2) {
            this(zzbem2, null, looper);
        }
    }
}

