/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zza;
import com.google.android.gms.internal.zzban;
import com.google.android.gms.internal.zzbao;
import com.google.android.gms.internal.zzbap;
import com.google.android.gms.internal.zzbaq;
import com.google.android.gms.internal.zzbas;
import com.google.android.gms.internal.zzbau;
import com.google.android.gms.internal.zzbav;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbdb;
import com.google.android.gms.internal.zzbdc;
import com.google.android.gms.internal.zzbdx;
import com.google.android.gms.internal.zzbec;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbel;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.internal.zzbex;
import com.google.android.gms.internal.zzctj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzbda
implements Handler.Callback {
    public static final Status zzaEc = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzaEd = new Status(4, "The user must be signed in to make this API call.");
    private long zzaDC = 5000L;
    private long zzaDB = 120000L;
    private long zzaEe = 10000L;
    private static final Object zzuH = new Object();
    private static zzbda zzaEf;
    private final Context mContext;
    private final GoogleApiAvailability zzaBd;
    private int zzaEg = -1;
    private final AtomicInteger zzaEh = new AtomicInteger(1);
    private final AtomicInteger zzaEi = new AtomicInteger(0);
    private final Map<zzbas<?>, zzbdc<?>> zzaCB = new ConcurrentHashMap(5, 0.75f, 1);
    private zzbbv zzaEj = null;
    private final Set<zzbas<?>> zzaEk = new zza();
    private final Set<zzbas<?>> zzaEl = new zza();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbda zzay(Context context) {
        Object object = zzuH;
        synchronized (object) {
            if (zzaEf == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzaEf = new zzbda(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzaEf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbda zzqk() {
        Object object = zzuH;
        synchronized (object) {
            zzbo.zzb((Object)zzaEf, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzaEf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzql() {
        Object object = zzuH;
        synchronized (object) {
            if (zzaEf != null) {
                zzbda zzbda2 = zzaEf;
                zzbda2.zzaEi.incrementAndGet();
                zzbda2.mHandler.sendMessageAtFrontOfQueue(zzbda2.mHandler.obtainMessage(10));
            }
            return;
        }
    }

    private zzbda(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzaBd = googleApiAvailability;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
    }

    public final int zzqm() {
        return this.zzaEh.getAndIncrement();
    }

    public final void zzb(GoogleApi<?> googleApi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzc(GoogleApi<?> googleApi) {
        zzbas<?> zzbas2 = googleApi.zzph();
        zzbdc<Object> zzbdc2 = this.zzaCB.get(zzbas2);
        if (zzbdc2 == null) {
            zzbdc2 = new zzbdc(this, googleApi);
            this.zzaCB.put(zzbas2, zzbdc2);
        }
        if (zzbdc2.zzmv()) {
            this.zzaEl.add(zzbas2);
        }
        zzbdc2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzbbv zzbbv2) {
        Object object = zzuH;
        synchronized (object) {
            if (this.zzaEj != zzbbv2) {
                this.zzaEj = zzbbv2;
                this.zzaEk.clear();
                this.zzaEk.addAll((Collection<zzbas<?>>)zzbbv2.zzpR());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzbbv zzbbv2) {
        Object object = zzuH;
        synchronized (object) {
            if (this.zzaEj == zzbbv2) {
                this.zzaEj = null;
                this.zzaEk.clear();
            }
            return;
        }
    }

    public final Task<Void> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzbau zzbau2 = new zzbau(iterable);
        for (GoogleApi<?> googleApi : iterable) {
            zzbdc<?> zzbdc2 = this.zzaCB.get(googleApi.zzph());
            if (zzbdc2 != null && zzbdc2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)zzbau2));
            return zzbau2.getTask();
        }
        zzbau2.zzpu();
        return zzbau2.getTask();
    }

    public final void zzps() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    final void zzpl() {
        this.zzaEi.incrementAndGet();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
    }

    @WorkerThread
    private final void zzqn() {
        for (zzbas<?> zzbas2 : this.zzaEl) {
            this.zzaCB.remove(zzbas2).signOut();
        }
        this.zzaEl.clear();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, zzbax<? extends Result, Api.zzb> zzbax2) {
        zzban<zzbax<? extends Result, Api.zzb>> zzban2 = new zzban<zzbax<? extends Result, Api.zzb>>(n, zzbax2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzbec(zzban2, this.zzaEi.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, TResult> void zza(GoogleApi<O> googleApi, int n, zzbep<Api.zzb, TResult> zzbep2, TaskCompletionSource<TResult> taskCompletionSource, zzbel zzbel2) {
        zzbap<TResult> zzbap2 = new zzbap<TResult>(n, zzbep2, taskCompletionSource, zzbel2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzbec(zzbap2, this.zzaEi.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzbed<Api.zzb, ?> zzbed2, @NonNull zzbex<Api.zzb, ?> zzbex2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzbao zzbao2 = new zzbao(new zzbee(zzbed2, zzbex2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)new zzbec(zzbao2, this.zzaEi.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzbdx<?> zzbdx2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzbaq zzbaq2 = new zzbaq(zzbdx2, (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, (Object)new zzbec(zzbaq2, this.zzaEi.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                zzbda zzbda2 = this;
                this.zzaEe = bl ? 10000L : 300000L;
                zzbda2.mHandler.removeMessages(12);
                for (zzbas<?> zzbas2 : zzbda2.zzaCB.keySet()) {
                    zzbda2.mHandler.sendMessageDelayed(zzbda2.mHandler.obtainMessage(12, zzbas2), zzbda2.zzaEe);
                }
                break;
            }
            case 2: {
                zzbau zzbau2 = (zzbau)message.obj;
                zzbda zzbda3 = this;
                for (zzbas<?> zzbas3 : zzbau2.zzpt()) {
                    zzbdc<?> zzbdc2 = zzbda3.zzaCB.get(zzbas3);
                    if (zzbdc2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzbau2.zza(zzbas3, connectionResult);
                        break block0;
                    }
                    if (zzbdc2.isConnected()) {
                        zzbau2.zza(zzbas3, ConnectionResult.zzazX);
                        continue;
                    }
                    if (zzbdc2.zzqu() != null) {
                        zzbau2.zza(zzbas3, zzbdc2.zzqu());
                        continue;
                    }
                    zzbdc2.zza(zzbau2);
                }
                break;
            }
            case 3: {
                for (zzbdc<?> zzbdc3 : this.zzaCB.values()) {
                    zzbdc3.zzqt();
                    zzbdc3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzbec zzbec2 = (zzbec)message.obj;
                zzbda zzbda4 = this;
                zzbdc<?> zzbdc4 = zzbda4.zzaCB.get(zzbec2.zzaET.zzph());
                if (zzbdc4 == null) {
                    zzbda4.zzc(zzbec2.zzaET);
                    zzbdc4 = zzbda4.zzaCB.get(zzbec2.zzaET.zzph());
                }
                if (zzbdc4.zzmv() && zzbda4.zzaEi.get() != zzbec2.zzaES) {
                    zzbec2.zzaER.zzp(zzaEc);
                    zzbdc4.signOut();
                    break;
                }
                zzbdc4.zza(zzbec2.zzaER);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                zzbda zzbda5 = this;
                zzbdc<?> zzbdc5 = null;
                for (zzbdc<?> zzbdc6 : zzbda5.zzaCB.values()) {
                    if (zzbdc6.getInstanceId() != n) continue;
                    zzbdc5 = zzbdc6;
                    break;
                }
                if (zzbdc5 != null) {
                    zzbdc<?> zzbdc6;
                    String string2 = String.valueOf(zzbda5.zzaBd.getErrorString(connectionResult.getErrorCode()));
                    zzbdc6 = String.valueOf(connectionResult.getErrorMessage());
                    zzbdc5.zzt(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zzbdc6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zzbdc6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                zzbda zzbda6 = this;
                if (!(zzbda6.mContext.getApplicationContext() instanceof Application)) break;
                zzbav.zza((Application)((Application)zzbda6.mContext.getApplicationContext()));
                zzbav.zzpv().zza((zzbaw)new zzbdb(zzbda6));
                if (zzbav.zzpv().zzab(true)) break;
                zzbda6.zzaEe = 300000L;
                break;
            }
            case 7: {
                this.zzc((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzaCB.containsKey(message.obj)) break;
                this.zzaCB.get(message.obj).resume();
                break;
            }
            case 10: {
                this.zzqn();
                break;
            }
            case 11: {
                if (!this.zzaCB.containsKey(message.obj)) break;
                this.zzaCB.get(message.obj).zzqd();
                break;
            }
            case 12: {
                if (!this.zzaCB.containsKey(message.obj)) break;
                this.zzaCB.get(message.obj).zzqx();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzbas<?> zzbas2, int n) {
        zzbdc<?> zzbdc2 = this.zzaCB.get(zzbas2);
        if (zzbdc2 == null) {
            return null;
        }
        zzctj zzctj2 = zzbdc2.zzqy();
        if (zzctj2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)n, (Intent)zzctj2.zzmH(), (int)0x8000000);
    }

    final boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzaBd.zza(this.mContext, connectionResult, n);
    }

    public final void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    static /* synthetic */ Handler zza(zzbda zzbda2) {
        return zzbda2.mHandler;
    }

    static /* synthetic */ Context zzb(zzbda zzbda2) {
        return zzbda2.mContext;
    }

    static /* synthetic */ long zzc(zzbda zzbda2) {
        return zzbda2.zzaDC;
    }

    static /* synthetic */ long zzd(zzbda zzbda2) {
        return zzbda2.zzaDB;
    }

    static /* synthetic */ int zza(zzbda zzbda2, int n) {
        zzbda2.zzaEg = n;
        return zzbda2.zzaEg;
    }

    static /* synthetic */ Status zzqo() {
        return zzaEd;
    }

    static /* synthetic */ Object zzqp() {
        return zzuH;
    }

    static /* synthetic */ zzbbv zze(zzbda zzbda2) {
        return zzbda2.zzaEj;
    }

    static /* synthetic */ Set zzf(zzbda zzbda2) {
        return zzbda2.zzaEk;
    }

    static /* synthetic */ GoogleApiAvailability zzg(zzbda zzbda2) {
        return zzbda2.zzaBd;
    }

    static /* synthetic */ long zzh(zzbda zzbda2) {
        return zzbda2.zzaEe;
    }

    static /* synthetic */ int zzi(zzbda zzbda2) {
        return zzbda2.zzaEg;
    }

    static /* synthetic */ Map zzj(zzbda zzbda2) {
        return zzbda2.zzaCB;
    }
}

