/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzad;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbcg;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcq;
import com.google.android.gms.internal.zzbcu;
import com.google.android.gms.internal.zzbcw;
import com.google.android.gms.internal.zzbdb;
import com.google.android.gms.internal.zzbec;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbef;
import com.google.android.gms.internal.zzbeg;
import com.google.android.gms.internal.zzbeh;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbew;
import com.google.android.gms.internal.zzbfb;
import com.google.android.gms.internal.zzbfc;
import com.google.android.gms.internal.zzbfd;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfu;
import com.google.android.gms.internal.zzbfz;
import com.google.android.gms.internal.zzbge;
import com.google.android.gms.internal.zzbgh;
import com.google.android.gms.internal.zzbha;
import com.google.android.gms.internal.zzcuw;
import com.google.android.gms.internal.zzcux;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzbeb
extends GoogleApiClient
implements zzbfc {
    private final Lock zzaCx;
    private boolean zzaBj;
    private final zzad zzaDA;
    private zzbfb zzaDB = null;
    private final int zzaBd;
    private final Context mContext;
    private final Looper zzrP;
    final Queue<zzbck<?, ?>> zzaCL = new LinkedList();
    private volatile boolean zzaDC;
    private long zzaDD = 120000L;
    private long zzaDE = 5000L;
    private final zzbeg zzaDF;
    private final GoogleApiAvailability zzaBf;
    private zzbew zzaDG;
    final Map<Api.zzc<?>, Api.zze> zzaDH;
    Set<Scope> zzaDI = new HashSet<Scope>();
    private zzq zzaCC;
    private Map<Api<?>, Boolean> zzaCF;
    private Api.zza<? extends zzcuw, zzcux> zzaBg;
    private final zzbfm zzaDJ = new zzbfm();
    private final ArrayList<zzbcu> zzaDK;
    private Integer zzaDL = null;
    Set<zzbge> zzaDM = null;
    final zzbgh zzaDN;
    private final zzae zzaDO = new zzbec(this);

    public zzbeb(Context context, Lock lock, Looper looper, zzq zzq2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcuw, zzcux> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzbcu> arrayList, boolean bl) {
        this.mContext = context;
        this.zzaCx = lock;
        this.zzaBj = false;
        this.zzaDA = new zzad(looper, this.zzaDO);
        this.zzrP = looper;
        this.zzaDF = new zzbeg(this, looper);
        this.zzaBf = googleApiAvailability;
        this.zzaBd = n;
        if (this.zzaBd >= 0) {
            this.zzaDL = n2;
        }
        this.zzaCF = map;
        this.zzaDH = map2;
        this.zzaDK = arrayList;
        this.zzaDN = new zzbgh(this.zzaDH);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzaDA.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzaDA.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzaCC = zzq2;
        this.zzaBg = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbck<R, A>> T zzd(@NonNull T t) {
        zzbr.zzb((t.zzpb() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzpe() != null ? t.zzpe().getName() : "the API";
        zzbr.zzb((boolean)this.zzaDH.containsKey(t.zzpb()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzaCx.lock();
        try {
            if (this.zzaDB == null) {
                this.zzaCL.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzaDB.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zze(@NonNull T t) {
        zzbr.zzb((t.zzpb() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzpe() != null ? t.zzpe().getName() : "the API";
        zzbr.zzb((boolean)this.zzaDH.containsKey(t.zzpb()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzaCx.lock();
        try {
            if (this.zzaDB == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzaDC) {
                this.zzaCL.add(t);
                while (!this.zzaCL.isEmpty()) {
                    object = this.zzaCL.remove();
                    this.zzaDN.zzb((zzbcq<? extends Result>)object);
                    ((zzbck)object).zzr(Status.zzaBq);
                }
                object = t;
                return (T)object;
            }
            object = this.zzaDB.zze(t);
            return (T)object;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final <L> zzbfi<L> zzp(@NonNull L l) {
        this.zzaCx.lock();
        try {
            Looper looper = this.zzrP;
            L l2 = l;
            zzbfi<L> zzbfi2 = this.zzaDJ.zza(l2, looper, "NO_TYPE");
            return zzbfi2;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzaDH.get(zzc2);
        zzbr.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzaDH.containsKey(api.zzpb());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!this.isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzaDH.get(api.zzpb());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzaCx.lock();
                    if (!this.isConnected() && !this.zzaDC) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzaDH.containsKey(api.zzpb())) break block6;
                    connectionResult = this.zzaDB.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzaDC) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzazZ;
                    this.zzaCx.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzqe());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzaCx.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzaCx.lock();
        try {
            if (this.zzaBd >= 0) {
                zzbr.zza((this.zzaDL != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaDL == null) {
                this.zzaDL = zzbeb.zza(this.zzaDH.values(), false);
            } else if (this.zzaDL == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.zzaDL);
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzaCx.lock();
        try {
            zzbr.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzap(n);
            this.zzqa();
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbr.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzaCx.lock();
        try {
            if (this.zzaBd >= 0) {
                zzbr.zza((this.zzaDL != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaDL == null) {
                this.zzaDL = zzbeb.zza(this.zzaDH.values(), false);
            } else if (this.zzaDL == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzap(this.zzaDL);
            this.zzaDA.zzrz();
            ConnectionResult connectionResult = this.zzaDB.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbr.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbr.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzaCx.lock();
        try {
            if (this.zzaDL == null) {
                this.zzaDL = zzbeb.zza(this.zzaDH.values(), false);
            } else if (this.zzaDL == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzap(this.zzaDL);
            this.zzaDA.zzrz();
            ConnectionResult connectionResult = this.zzaDB.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzaCx.lock();
        try {
            this.zzaDN.release();
            if (this.zzaDB != null) {
                this.zzaDB.disconnect();
            }
            this.zzaDJ.release();
            for (zzbck zzbck2 : this.zzaCL) {
                zzbck2.zza(null);
                zzbck2.cancel();
            }
            this.zzaCL.clear();
            if (this.zzaDB == null) {
                return;
            }
            this.zzqc();
            this.zzaDA.zzry();
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbr.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbr.zza((this.zzaDL != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzbfz zzbfz2 = new zzbfz(this);
        if (this.zzaDH.containsKey(zzbha.zzajT)) {
            this.zza(this, zzbfz2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbed zzbed2 = new zzbed(this, atomicReference, zzbfz2);
            zzbee zzbee2 = new zzbee(this, zzbfz2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbha.API).addConnectionCallbacks(zzbed2).addOnConnectionFailedListener(zzbee2).setHandler(this.zzaDF).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzbfz2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzbfz zzbfz2, boolean bl) {
        zzbha.zzaIA.zzd(googleApiClient).setResultCallback(new zzbef(this, zzbfz2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzbfd zzbfd2 = new zzbfd((Activity)fragmentActivity);
        zzbeb zzbeb2 = this;
        if (zzbeb2.zzaBd >= 0) {
            zzbcg.zza(zzbfd2).zzal(zzbeb2.zzaBd);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzaDB != null && this.zzaDB.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzaDB != null && this.zzaDB.isConnecting();
    }

    private final void zzap(int n) {
        if (this.zzaDL == null) {
            this.zzaDL = n;
        } else if (this.zzaDL != n) {
            String string2 = String.valueOf(zzbeb.zzaq(n));
            String string3 = String.valueOf(zzbeb.zzaq(this.zzaDL));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzaDB != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzaDH.values()) {
            if (zze2.zzmt()) {
                bl = true;
            }
            if (!zze2.zzmE()) continue;
            bl2 = true;
        }
        switch (this.zzaDL) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzaBj) {
                    this.zzaDB = new zzbdb(this.mContext, this.zzaCx, this.zzrP, this.zzaBf, this.zzaDH, this.zzaCC, this.zzaCF, this.zzaBg, this.zzaDK, this, true);
                    return;
                }
                this.zzaDB = zzbcw.zza(this.mContext, this, this.zzaCx, this.zzrP, this.zzaBf, this.zzaDH, this.zzaCC, this.zzaCF, this.zzaBg, this.zzaDK);
                return;
            }
        }
        if (this.zzaBj && !bl2) {
            this.zzaDB = new zzbdb(this.mContext, this.zzaCx, this.zzrP, this.zzaBf, this.zzaDH, this.zzaCC, this.zzaCF, this.zzaBg, this.zzaDK, this, false);
            return;
        }
        this.zzaDB = new zzbej(this.mContext, this, this.zzaCx, this.zzrP, this.zzaBf, this.zzaDH, this.zzaCC, this.zzaCF, this.zzaBg, this.zzaDK, this);
    }

    private final void zzqa() {
        this.zzaDA.zzrz();
        this.zzaDB.connect();
    }

    private final void resume() {
        this.zzaCx.lock();
        try {
            if (this.zzaDC) {
                this.zzqa();
            }
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    private final void zzqb() {
        this.zzaCx.lock();
        try {
            if (this.zzqc()) {
                this.zzqa();
            }
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    final boolean zzqc() {
        if (!this.zzaDC) {
            return false;
        }
        this.zzaDC = false;
        this.zzaDF.removeMessages(2);
        this.zzaDF.removeMessages(1);
        if (this.zzaDG != null) {
            this.zzaDG.unregister();
            this.zzaDG = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaDA.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzaDA.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaDA.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaDA.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzaDA.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaDA.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzm(Bundle bundle) {
        while (!this.zzaCL.isEmpty()) {
            this.zze(this.zzaCL.remove());
        }
        this.zzaDA.zzn(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zze.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzqc();
        }
        if (!this.zzaDC) {
            this.zzaDA.zzk(connectionResult);
            this.zzaDA.zzry();
        }
    }

    @Override
    public final void zze(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzbeb zzbeb2 = this;
            if (!zzbeb2.zzaDC) {
                zzbeb2.zzaDC = true;
                if (zzbeb2.zzaDG == null) {
                    zzbeb2.zzaDG = GoogleApiAvailability.zza(zzbeb2.mContext.getApplicationContext(), new zzbeh(zzbeb2));
                }
                zzbeb2.zzaDF.sendMessageDelayed(zzbeb2.zzaDF.obtainMessage(1), zzbeb2.zzaDD);
                zzbeb2.zzaDF.sendMessageDelayed(zzbeb2.zzaDF.obtainMessage(2), zzbeb2.zzaDE);
            }
        }
        this.zzaDN.zzqK();
        this.zzaDA.zzaA(n);
        this.zzaDA.zzry();
        if (n == 2) {
            this.zzqa();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzrP;
    }

    @Override
    public final boolean zza(zzbfu zzbfu2) {
        return this.zzaDB != null && this.zzaDB.zza(zzbfu2);
    }

    @Override
    public final void zzpj() {
        if (this.zzaDB != null) {
            this.zzaDB.zzpj();
        }
    }

    @Override
    public final void zza(zzbge zzbge2) {
        this.zzaCx.lock();
        try {
            if (this.zzaDM == null) {
                this.zzaDM = new HashSet<zzbge>();
            }
            this.zzaDM.add(zzbge2);
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void zzb(zzbge zzbge2) {
        this.zzaCx.lock();
        try {
            if (this.zzaDM == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzaDM.remove(zzbge2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzqd()) {
                this.zzaDB.zzpC();
            }
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    final boolean zzqd() {
        this.zzaCx.lock();
        try {
            if (this.zzaDM == null) {
                return false;
            }
            boolean bl = !this.zzaDM.isEmpty();
            return bl;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    final String zzqe() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzaDC);
        printWriter.append(" mWorkQueue.size()=").print(this.zzaCL.size());
        PrintWriter printWriter2 = printWriter;
        zzbgh zzbgh2 = this.zzaDN;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzbgh2.zzaFn.size());
        if (this.zzaDB != null) {
            this.zzaDB.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzmt()) {
                bl2 = true;
            }
            if (!zze2.zzmE()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzaq(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzbeb zzbeb2) {
        zzbeb2.resume();
    }

    static /* synthetic */ void zzb(zzbeb zzbeb2) {
        zzbeb2.zzqb();
    }

    static /* synthetic */ void zza(zzbeb zzbeb2, GoogleApiClient googleApiClient, zzbfz zzbfz2, boolean bl) {
        zzbeb2.zza(googleApiClient, zzbfz2, true);
    }

    static /* synthetic */ Context zzc(zzbeb zzbeb2) {
        return zzbeb2.mContext;
    }
}

