/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzaaf;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzaaf<BatchResult> {
    private int zzayM;
    private boolean zzayN;
    private boolean zzayO;
    private final PendingResult<?>[] zzayP;
    private final Object zzrJ = new Object();

    private Batch(List<PendingResult<?>> list, GoogleApiClient googleApiClient) {
        super(googleApiClient);
        this.zzayM = list.size();
        this.zzayP = new PendingResult[this.zzayM];
        if (list.isEmpty()) {
            this.zzb(new BatchResult(Status.zzazx, this.zzayP));
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PendingResult<?> pendingResult = list.get(i);
            this.zzayP[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzy(Status status) {
                    Object object = Batch.this.zzrJ;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzayO = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzayN = true;
                        }
                        Batch.this.zzayM--;
                        if (Batch.this.zzayM == 0) {
                            if (Batch.this.zzayO) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzayN ? new Status(13) : Status.zzazx;
                                Batch.this.zzb(new BatchResult(status2, Batch.this.zzayP));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzayP) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzayP);
    }

    @Override
    public /* synthetic */ Result zzc(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzayR = new ArrayList();
        private GoogleApiClient zzanE;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzanE = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzayR.size());
            this.zzayR.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzayR, this.zzanE);
        }
    }
}

