/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzcn;
import com.google.android.gms.internal.ads.zzct;
import com.google.android.gms.internal.ads.zzdc;
import com.google.android.gms.internal.ads.zzfbb;
import com.google.android.gms.internal.ads.zzfbd;
import com.google.android.gms.internal.ads.zzfbj;
import com.google.android.gms.internal.ads.zzfbo;
import com.google.android.gms.internal.ads.zzfbp;
import com.google.android.gms.internal.ads.zzfbq;
import com.google.android.gms.internal.ads.zzfbr;
import com.google.android.gms.internal.ads.zzfbs;
import com.google.android.gms.internal.ads.zzfbt;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfbu {
    private final Context zza;
    private final Executor zzb;
    private final zzfbb zzc;
    private final zzfbd zzd;
    private final zzfbt zze;
    private final zzfbt zzf;
    private Task<zzdc> zzg;
    private Task<zzdc> zzh;

    @VisibleForTesting
    zzfbu(Context context, Executor executor, zzfbb zzfbb2, zzfbd zzfbd2, zzfbr zzfbr2, zzfbs zzfbs2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfbb2;
        this.zzd = zzfbd2;
        this.zze = zzfbr2;
        this.zzf = zzfbs2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzfbu zza(@NonNull Context object, @NonNull Executor executor, @NonNull zzfbb zzfbb2, @NonNull zzfbd zzfbd2) {
        void var3_6;
        void var2_5;
        void var1_4;
        zzfbr zzfbr2 = new zzfbr();
        zzfbs zzfbs2 = new zzfbs();
        zzfbu zzfbu2 = new zzfbu((Context)object, (Executor)var1_4, (zzfbb)var2_5, (zzfbd)var3_6, zzfbr2, zzfbs2);
        if (zzfbu2.zzd.zzb()) {
            zzfbo zzfbo2 = new zzfbo(zzfbu2);
            zzfbu2.zzg = zzfbu2.zzg(zzfbo2);
        } else {
            zzfbu2.zzg = Tasks.forResult((Object)zzfbu2.zze.zza());
        }
        zzfbp zzfbp2 = new zzfbp(zzfbu2);
        zzfbu2.zzh = zzfbu2.zzg(zzfbp2);
        return zzfbu2;
    }

    public final zzdc zzb() {
        return zzfbu.zzh(this.zzg, this.zze.zza());
    }

    public final zzdc zzc() {
        return zzfbu.zzh(this.zzh, this.zzf.zza());
    }

    private final Task<zzdc> zzg(@NonNull Callable<zzdc> task) {
        Executor executor = this.zzb;
        task = Tasks.call((Executor)executor, task);
        executor = this.zzb;
        zzfbq zzfbq2 = new zzfbq(this);
        return task.addOnFailureListener(executor, (OnFailureListener)zzfbq2);
    }

    private static zzdc zzh(@NonNull Task<zzdc> task, @NonNull zzdc zzdc2) {
        if (!task.isSuccessful()) {
            return zzdc2;
        }
        return (zzdc)task.getResult();
    }

    final /* synthetic */ void zzd(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzd(2025, -1L, exception);
    }

    final /* synthetic */ zzdc zze() throws Exception {
        zzfbu zzfbu2 = zzfbu2.zza;
        PackageManager packageManager = zzfbu2.getPackageManager();
        String string2 = zzfbu2.getPackageName();
        packageManager = packageManager.getPackageInfo(string2, 0);
        return zzfbj.zza((Context)zzfbu2, zzfbu2.getPackageName(), Integer.toString(packageManager.versionCode));
    }

    final /* synthetic */ zzdc zzf() throws Exception {
        Object object = ((zzfbu)object).zza;
        zzcn zzcn2 = zzdc.zzj();
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient((Context)object);
        advertisingIdClient.start();
        advertisingIdClient = advertisingIdClient.getInfo();
        object = advertisingIdClient.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzcn2.zzX((String)object);
            zzcn2.zzZ(advertisingIdClient.isLimitAdTrackingEnabled());
            zzcn2.zzY(zzct.zzf);
        }
        return (zzdc)zzcn2.zzah();
    }
}

