/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.internal.ads.zzbba;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbfq;

public final class zza {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean zzc(Context context, Uri uri, zzv zzv2, zzt zzt2) {
        int n;
        try {
            n = zzs.zzc().zzs(context, uri);
            if (zzv2 != null) {
                zzv2.zzf();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zze.zzi((String)activityNotFoundException.getMessage());
            n = 6;
        }
        if (zzt2 != null) {
            zzt2.zzb(n);
        }
        return n == 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zza(Context context, Intent intent, zzv zzv2, @Nullable zzt zzt2, boolean bl) {
        if (bl) {
            return zza.zzc(context, intent.getData(), zzv2, zzt2);
        }
        try {
            String string2 = "Launching an intent: ";
            String string3 = String.valueOf(intent.toURI());
            int n = string3.length();
            string2 = n != 0 ? string2.concat(string3) : (string3 = new String(string2));
            zze.zza(string2);
            zzs.zzc();
            zzr.zzO(context, intent);
            if (zzv2 != null) {
                zzv2.zzf();
            }
            if (zzt2 != null) {
                zzt2.zza(true);
            }
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zze.zzi((String)activityNotFoundException.getMessage());
            if (zzt2 != null) {
                zzt2.zza(false);
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzb(Context object, @Nullable zzc object2, zzv zzv2, @Nullable zzt zzt2) {
        if (object2 == null) {
            zze.zzi((String)"No intent data for launcher overlay.");
            return false;
        }
        zzbfq.zza((Context)object);
        String[] stringArray = ((zzc)((Object)object2)).zzh;
        if (stringArray != null) {
            return zza.zza((Context)object, (Intent)stringArray, zzv2, zzt2, ((zzc)((Object)object2)).zzj);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zzb)) {
            zze.zzi((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zzc)) {
            intent.setDataAndType(Uri.parse((String)((zzc)((Object)object2)).zzb), ((zzc)((Object)object2)).zzc);
        } else {
            intent.setData(Uri.parse((String)((zzc)((Object)object2)).zzb));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zzd)) {
            intent.setPackage(((zzc)((Object)object2)).zzd);
        }
        if (!TextUtils.isEmpty((CharSequence)((zzc)((Object)object2)).zze)) {
            stringArray = ((zzc)((Object)object2)).zze.split("/", 2);
            if (stringArray.length < 2) {
                object = String.valueOf(((zzc)((Object)object2)).zze);
                object2 = "Could not parse component name from open GMSG: ";
                object = ((String)object).length() != 0 ? ((String)object2).concat((String)object) : new String((String)object2);
                zze.zzi((String)object);
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = ((zzc)((Object)object2)).zzf))) {
            int n;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zze.zzi((String)"Could not parse intent flags.");
                n = 0;
            }
            intent.addFlags(n);
        }
        zzbfi zzbfi2 = zzbfq.zzcK;
        if (((Boolean)zzbba.zzc().zzb(zzbfi2)).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
            return zza.zza((Context)object, intent, zzv2, zzt2, ((zzc)((Object)((Object)object2))).zzj);
        }
        zzbfi2 = zzbfq.zzcJ;
        if ((Boolean)zzbba.zzc().zzb(zzbfi2) == false) return zza.zza((Context)object, intent, zzv2, zzt2, ((zzc)((Object)((Object)object2))).zzj);
        zzs.zzc();
        zzr.zzu((Context)object, intent);
        return zza.zza((Context)object, intent, zzv2, zzt2, ((zzc)((Object)object2)).zzj);
    }
}

