/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsPreflightCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorsPreflightCheck.class);
    private static final String preflightAttributeValue = "PRE_FLIGHT";
    private static final List<String> CORS_PRE_FLIGHT_HEADERS = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("Access-Control-Request-Method");
            this.add("Access-Control-Request-Headers");
            this.add("Origin");
        }
    };

    public static boolean isPreflight(HttpServletRequest request) {
        String corsRequestType = (String)request.getAttribute("cors.request.type");
        LOGGER.debug("[waffle.util.CorsPreflightCheck] Request is CORS preflight; continue filter chain");
        String method = request.getMethod();
        if (method == null || !method.equalsIgnoreCase("OPTIONS")) {
            return false;
        }
        LOGGER.debug("[waffle.util.CorsPreflightCheck] check for PRE_FLIGHT Attribute");
        if (corsRequestType != null && corsRequestType.equalsIgnoreCase(preflightAttributeValue)) {
            return true;
        }
        LOGGER.debug("[waffle.util.CorsPreflightCheck] check headers");
        for (String header : CORS_PRE_FLIGHT_HEADERS) {
            String headerValue = request.getHeader(header);
            LOGGER.debug("[waffle.util.CorsPreflightCheck] {} {} ", (Object)header);
            if (headerValue != null) continue;
            return false;
        }
        LOGGER.debug("[waffle.util.CorsPreflightCheck] is preflight");
        return true;
    }
}

