/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.shapes;

import com.aspose.psd.Matrix;
import com.aspose.psd.Pen;
import com.aspose.psd.PointF;
import com.aspose.psd.RectangleF;
import com.aspose.psd.Shape;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.NotImplementedException;
import com.aspose.psd.internal.gL.aN;
import com.aspose.psd.system.SerializableAttribute;

@SerializableAttribute
public abstract class RectangleProjectedShape
extends Shape {
    private final PointF a = new PointF();
    private PointF b = new PointF();
    private PointF c = new PointF();
    private PointF d = new PointF();

    public RectangleProjectedShape() {
    }

    public RectangleProjectedShape(RectangleF rectangle) {
        rectangle.getLocation().CloneTo(this.a);
        this.b = new PointF(rectangle.getRight(), rectangle.getTop());
        this.d = new PointF(rectangle.getRight(), rectangle.getBottom());
        this.c = new PointF(rectangle.getLeft(), rectangle.getBottom());
    }

    public PointF getLeftTop() {
        return this.a;
    }

    public PointF getRightTop() {
        return this.b;
    }

    public PointF getLeftBottom() {
        return this.c;
    }

    public PointF getRightBottom() {
        return this.d;
    }

    @Override
    public PointF getCenter() {
        return aN.a(new PointF[]{this.a, this.b, this.c, this.d});
    }

    @Override
    public RectangleF getBounds() {
        return aN.b(new PointF[]{this.a, this.b, this.c, this.d});
    }

    public double getRectangleWidth() {
        return aN.a(this.a.Clone(), this.b.Clone());
    }

    public double getRectangleHeight() {
        return aN.a(this.a.Clone(), this.c.Clone());
    }

    @Override
    public boolean hasSegments() {
        return aN.a(this.a.Clone(), this.b.Clone()) > 0.0 && aN.a(this.a.Clone(), this.c.Clone()) > 0.0;
    }

    @Override
    public RectangleF getBounds(Matrix matrix) {
        return aN.a(new PointF[]{this.a, this.b, this.c, this.d}, matrix);
    }

    @Override
    public RectangleF getBounds(Matrix matrix, Pen pen) {
        throw new NotImplementedException();
    }

    @Override
    public void transform(Matrix transform) {
        if (transform == null) {
            throw new ArgumentNullException("transform");
        }
        PointF[] pointFArray = new PointF[]{this.a, this.b, this.c, this.d};
        transform.transformPoints(pointFArray);
        pointFArray[0].CloneTo(this.a);
        pointFArray[1].CloneTo(this.b);
        pointFArray[2].CloneTo(this.c);
        pointFArray[3].CloneTo(this.d);
    }
}

