/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.tsp.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.psd.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cms.Evidence;
import com.aspose.psd.internal.bouncycastle.asn1.cms.TimeStampAndCRL;
import com.aspose.psd.internal.bouncycastle.asn1.cms.TimeStampedData;
import com.aspose.psd.internal.bouncycastle.asn1.cms.TimeStampedDataParser;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.psd.internal.bouncycastle.tsp.TSPException;
import com.aspose.psd.internal.bouncycastle.tsp.TimeStampToken;
import com.aspose.psd.internal.bouncycastle.tsp.TimeStampTokenInfo;
import com.aspose.psd.internal.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import com.aspose.psd.internal.bouncycastle.tsp.cms.a;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class b {
    private final TimeStampAndCRL[] a;
    private final a b;

    b(TimeStampedData timeStampedData) {
        this.b = new a(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.a = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    b(TimeStampedDataParser timeStampedDataParser) throws IOException {
        this.b = new a(timeStampedDataParser.getMetaData());
        Evidence evidence = timeStampedDataParser.getTemporalEvidence();
        this.a = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampToken a(TimeStampAndCRL timeStampAndCRL) throws CMSException {
        ContentInfo contentInfo = timeStampAndCRL.getTimeStampToken();
        try {
            TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
            return timeStampToken;
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse token data: " + iOException.getMessage(), iOException);
        }
        catch (TSPException tSPException) {
            if (tSPException.getCause() instanceof CMSException) {
                throw (CMSException)tSPException.getCause();
            }
            throw new CMSException("token data invalid: " + tSPException.getMessage(), tSPException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("token data invalid: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    void a(DigestCalculator digestCalculator) throws CMSException {
        this.b.a(digestCalculator);
    }

    DigestCalculator a(DigestCalculatorProvider digestCalculatorProvider) throws OperatorCreationException {
        try {
            TimeStampToken timeStampToken = this.a(this.a[0]);
            TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = timeStampTokenInfo.getMessageImprintAlgOID();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(new AlgorithmIdentifier(aSN1ObjectIdentifier));
            this.a(digestCalculator);
            return digestCalculator;
        }
        catch (CMSException cMSException) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + cMSException.getMessage(), cMSException);
        }
    }

    TimeStampToken[] a() throws CMSException {
        TimeStampToken[] timeStampTokenArray = new TimeStampToken[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            timeStampTokenArray[i2] = this.a(this.a[i2]);
        }
        return timeStampTokenArray;
    }

    TimeStampAndCRL[] b() {
        return this.a;
    }

    byte[] b(DigestCalculator digestCalculator) throws CMSException {
        TimeStampAndCRL timeStampAndCRL = this.a[this.a.length - 1];
        OutputStream outputStream = digestCalculator.getOutputStream();
        try {
            outputStream.write(timeStampAndCRL.getEncoded("DER"));
            outputStream.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw new CMSException("exception calculating hash: " + iOException.getMessage(), iOException);
        }
    }

    void a(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray) throws ImprintDigestInvalidException, CMSException {
        byte[] byArray2 = byArray;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            try {
                TimeStampToken timeStampToken = this.a(this.a[i2]);
                if (i2 > 0) {
                    TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
                    DigestCalculator digestCalculator = digestCalculatorProvider.get(timeStampTokenInfo.getHashAlgorithm());
                    digestCalculator.getOutputStream().write(this.a[i2 - 1].getEncoded("DER"));
                    byArray2 = digestCalculator.getDigest();
                }
                this.a(timeStampToken, byArray2);
                continue;
            }
            catch (IOException iOException) {
                throw new CMSException("exception calculating hash: " + iOException.getMessage(), iOException);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("cannot create digest: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
    }

    void a(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        byte[] byArray2;
        byte[] byArray3 = byArray;
        try {
            byArray2 = timeStampToken.getEncoded();
        }
        catch (IOException iOException) {
            throw new CMSException("exception encoding timeStampToken: " + iOException.getMessage(), iOException);
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            try {
                TimeStampToken timeStampToken2 = this.a(this.a[i2]);
                if (i2 > 0) {
                    TimeStampTokenInfo timeStampTokenInfo = timeStampToken2.getTimeStampInfo();
                    DigestCalculator digestCalculator = digestCalculatorProvider.get(timeStampTokenInfo.getHashAlgorithm());
                    digestCalculator.getOutputStream().write(this.a[i2 - 1].getEncoded("DER"));
                    byArray3 = digestCalculator.getDigest();
                }
                this.a(timeStampToken2, byArray3);
                if (!Arrays.areEqual(timeStampToken2.getEncoded(), byArray2)) continue;
                return;
            }
            catch (IOException iOException) {
                throw new CMSException("exception calculating hash: " + iOException.getMessage(), iOException);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("cannot create digest: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
        throw new ImprintDigestInvalidException("passed in token not associated with timestamps present", timeStampToken);
    }

    private void a(TimeStampToken timeStampToken, byte[] byArray) throws ImprintDigestInvalidException {
        TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
        byte[] byArray2 = timeStampTokenInfo.getMessageImprintDigest();
        if (!Arrays.areEqual(byArray, byArray2)) {
            throw new ImprintDigestInvalidException("hash calculated is different from MessageImprintDigest found in TimeStampToken", timeStampToken);
        }
    }

    String c() {
        return this.b.a();
    }

    String d() {
        return this.b.b();
    }

    AttributeTable e() {
        return new AttributeTable(this.b.c());
    }
}

