/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra;

import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class PolynomialGF2mSmallM {
    private GF2mField a;
    private int b;
    private int[] c;
    public static final char RANDOM_IRREDUCIBLE_POLYNOMIAL = 'I';

    public PolynomialGF2mSmallM(GF2mField gF2mField) {
        this.a = gF2mField;
        this.b = -1;
        this.c = new int[1];
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int n2, char c2, SecureRandom secureRandom) {
        this.a = gF2mField;
        switch (c2) {
            case 'I': {
                this.c = this.a(n2, secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException(" Error: type " + c2 + " is not defined for GF2smallmPolynomial");
            }
        }
        this.a();
    }

    private int[] a(int n2, SecureRandom secureRandom) {
        int n3;
        int[] nArray = new int[n2 + 1];
        nArray[n2] = 1;
        nArray[0] = this.a.getRandomNonZeroElement(secureRandom);
        for (n3 = 1; n3 < n2; ++n3) {
            nArray[n3] = this.a.getRandomElement(secureRandom);
        }
        while (!this.b(nArray)) {
            n3 = RandUtils.nextInt(secureRandom, n2);
            if (n3 == 0) {
                nArray[0] = this.a.getRandomNonZeroElement(secureRandom);
                continue;
            }
            nArray[n3] = this.a.getRandomElement(secureRandom);
        }
        return nArray;
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int n2) {
        this.a = gF2mField;
        this.b = n2;
        this.c = new int[n2 + 1];
        this.c[n2] = 1;
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int[] nArray) {
        this.a = gF2mField;
        this.c = PolynomialGF2mSmallM.d(nArray);
        this.a();
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, byte[] byArray) {
        int n2;
        this.a = gF2mField;
        int n3 = 1;
        for (n2 = 8; gF2mField.getDegree() > n2; n2 += 8) {
            ++n3;
        }
        if (byArray.length % n3 != 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.c = new int[byArray.length / n3];
        n3 = 0;
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            for (int i3 = 0; i3 < n2; i3 += 8) {
                int n4 = i2;
                this.c[n4] = this.c[n4] ^ (byArray[n3++] & 0xFF) << i3;
            }
            if (this.a.isElementOfThisField(this.c[i2])) continue;
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        if (this.c.length != 1 && this.c[this.c.length - 1] == 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.a();
    }

    public PolynomialGF2mSmallM(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.a = polynomialGF2mSmallM.a;
        this.b = polynomialGF2mSmallM.b;
        this.c = IntUtils.clone(polynomialGF2mSmallM.c);
    }

    public PolynomialGF2mSmallM(GF2mVector gF2mVector) {
        this(gF2mVector.getField(), gF2mVector.getIntArrayForm());
    }

    public int getDegree() {
        int n2 = this.c.length - 1;
        if (this.c[n2] == 0) {
            return -1;
        }
        return n2;
    }

    public int getHeadCoefficient() {
        if (this.b == -1) {
            return 0;
        }
        return this.c[this.b];
    }

    private static int a(int[] nArray) {
        int n2 = PolynomialGF2mSmallM.c(nArray);
        if (n2 == -1) {
            return 0;
        }
        return nArray[n2];
    }

    public int getCoefficient(int n2) {
        if (n2 < 0 || n2 > this.b) {
            return 0;
        }
        return this.c[n2];
    }

    public byte[] getEncoded() {
        int n2;
        int n3 = 1;
        for (n2 = 8; this.a.getDegree() > n2; n2 += 8) {
            ++n3;
        }
        byte[] byArray = new byte[this.c.length * n3];
        n3 = 0;
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            for (int i3 = 0; i3 < n2; i3 += 8) {
                byArray[n3++] = (byte)(this.c[i2] >>> i3);
            }
        }
        return byArray;
    }

    public int evaluateAt(int n2) {
        int n3 = this.c[this.b];
        for (int i2 = this.b - 1; i2 >= 0; --i2) {
            n3 = this.a.mult(n3, n2) ^ this.c[i2];
        }
        return n3;
    }

    public PolynomialGF2mSmallM add(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = this.a(this.c, polynomialGF2mSmallM.c);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    public void addToThis(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.c = this.a(this.c, polynomialGF2mSmallM.c);
        this.a();
    }

    private int[] a(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int[] nArray4;
        if (nArray.length < nArray2.length) {
            nArray4 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
            nArray3 = nArray;
        } else {
            nArray4 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
            nArray3 = nArray2;
        }
        for (int i2 = nArray3.length - 1; i2 >= 0; --i2) {
            nArray4[i2] = this.a.add(nArray4[i2], nArray3[i2]);
        }
        return nArray4;
    }

    public PolynomialGF2mSmallM addMonomial(int n2) {
        int[] nArray = new int[n2 + 1];
        nArray[n2] = 1;
        int[] nArray2 = this.a(this.c, nArray);
        return new PolynomialGF2mSmallM(this.a, nArray2);
    }

    public PolynomialGF2mSmallM multWithElement(int n2) {
        if (!this.a.isElementOfThisField(n2)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        int[] nArray = this.a(this.c, n2);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    public void multThisWithElement(int n2) {
        if (!this.a.isElementOfThisField(n2)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        this.c = this.a(this.c, n2);
        this.a();
    }

    private int[] a(int[] nArray, int n2) {
        int n3 = PolynomialGF2mSmallM.c(nArray);
        if (n3 == -1 || n2 == 0) {
            return new int[1];
        }
        if (n2 == 1) {
            return IntUtils.clone(nArray);
        }
        int[] nArray2 = new int[n3 + 1];
        for (int i2 = n3; i2 >= 0; --i2) {
            nArray2[i2] = this.a.mult(nArray[i2], n2);
        }
        return nArray2;
    }

    public PolynomialGF2mSmallM multWithMonomial(int n2) {
        int[] nArray = PolynomialGF2mSmallM.b(this.c, n2);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    private static int[] b(int[] nArray, int n2) {
        int n3 = PolynomialGF2mSmallM.c(nArray);
        if (n3 == -1) {
            return new int[1];
        }
        int[] nArray2 = new int[n3 + n2 + 1];
        System.arraycopy(nArray, 0, nArray2, n2, n3 + 1);
        return nArray2;
    }

    public PolynomialGF2mSmallM[] div(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[][] nArray = this.b(this.c, polynomialGF2mSmallM.c);
        return new PolynomialGF2mSmallM[]{new PolynomialGF2mSmallM(this.a, nArray[0]), new PolynomialGF2mSmallM(this.a, nArray[1])};
    }

    private int[][] b(int[] nArray, int[] nArray2) {
        int n2 = PolynomialGF2mSmallM.c(nArray2);
        int n3 = PolynomialGF2mSmallM.c(nArray) + 1;
        if (n2 == -1) {
            throw new ArithmeticException("Division by zero.");
        }
        int[][] nArrayArray = new int[][]{new int[1], new int[n3]};
        int n4 = PolynomialGF2mSmallM.a(nArray2);
        n4 = this.a.inverse(n4);
        nArrayArray[0][0] = 0;
        System.arraycopy(nArray, 0, nArrayArray[1], 0, nArrayArray[1].length);
        while (n2 <= PolynomialGF2mSmallM.c(nArrayArray[1])) {
            int[] nArray3 = new int[]{this.a.mult(PolynomialGF2mSmallM.a(nArrayArray[1]), n4)};
            int[] nArray4 = this.a(nArray2, nArray3[0]);
            int n5 = PolynomialGF2mSmallM.c(nArrayArray[1]) - n2;
            nArray4 = PolynomialGF2mSmallM.b(nArray4, n5);
            nArray3 = PolynomialGF2mSmallM.b(nArray3, n5);
            nArrayArray[0] = this.a(nArray3, nArrayArray[0]);
            nArrayArray[1] = this.a(nArray4, nArrayArray[1]);
        }
        return nArrayArray;
    }

    public PolynomialGF2mSmallM gcd(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = this.c(this.c, polynomialGF2mSmallM.c);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    private int[] c(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        if (PolynomialGF2mSmallM.c(nArray3) == -1) {
            return nArray4;
        }
        while (PolynomialGF2mSmallM.c(nArray4) != -1) {
            int[] nArray5 = this.e(nArray3, nArray4);
            nArray3 = new int[nArray4.length];
            System.arraycopy(nArray4, 0, nArray3, 0, nArray3.length);
            nArray4 = new int[nArray5.length];
            System.arraycopy(nArray5, 0, nArray4, 0, nArray4.length);
        }
        int n2 = this.a.inverse(PolynomialGF2mSmallM.a(nArray3));
        return this.a(nArray3, n2);
    }

    public PolynomialGF2mSmallM multiply(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = this.d(this.c, polynomialGF2mSmallM.c);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    private int[] d(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int[] nArray4;
        if (PolynomialGF2mSmallM.c(nArray) < PolynomialGF2mSmallM.c(nArray2)) {
            nArray4 = nArray2;
            nArray3 = nArray;
        } else {
            nArray4 = nArray;
            nArray3 = nArray2;
        }
        nArray4 = PolynomialGF2mSmallM.d(nArray4);
        nArray3 = PolynomialGF2mSmallM.d(nArray3);
        if (nArray3.length == 1) {
            return this.a(nArray4, nArray3[0]);
        }
        int n2 = nArray4.length;
        int n3 = nArray3.length;
        int[] nArray5 = new int[n2 + n3 - 1];
        if (n3 != n2) {
            int[] nArray6 = new int[n3];
            int[] nArray7 = new int[n2 - n3];
            System.arraycopy(nArray4, 0, nArray6, 0, nArray6.length);
            System.arraycopy(nArray4, n3, nArray7, 0, nArray7.length);
            nArray6 = this.d(nArray6, nArray3);
            nArray7 = this.d(nArray7, nArray3);
            nArray7 = PolynomialGF2mSmallM.b(nArray7, n3);
            nArray5 = this.a(nArray6, nArray7);
        } else {
            n3 = n2 + 1 >>> 1;
            int n4 = n2 - n3;
            int[] nArray8 = new int[n3];
            int[] nArray9 = new int[n3];
            int[] nArray10 = new int[n4];
            int[] nArray11 = new int[n4];
            System.arraycopy(nArray4, 0, nArray8, 0, nArray8.length);
            System.arraycopy(nArray4, n3, nArray10, 0, nArray10.length);
            System.arraycopy(nArray3, 0, nArray9, 0, nArray9.length);
            System.arraycopy(nArray3, n3, nArray11, 0, nArray11.length);
            int[] nArray12 = this.a(nArray8, nArray10);
            int[] nArray13 = this.a(nArray9, nArray11);
            int[] nArray14 = this.d(nArray8, nArray9);
            int[] nArray15 = this.d(nArray12, nArray13);
            int[] nArray16 = this.d(nArray10, nArray11);
            nArray15 = this.a(nArray15, nArray14);
            nArray15 = this.a(nArray15, nArray16);
            nArray16 = PolynomialGF2mSmallM.b(nArray16, n3);
            nArray5 = this.a(nArray15, nArray16);
            nArray5 = PolynomialGF2mSmallM.b(nArray5, n3);
            nArray5 = this.a(nArray5, nArray14);
        }
        return nArray5;
    }

    private boolean b(int[] nArray) {
        if (nArray[0] == 0) {
            return false;
        }
        int n2 = PolynomialGF2mSmallM.c(nArray) >> 1;
        int[] nArray2 = new int[]{0, 1};
        int[] nArray3 = new int[]{0, 1};
        int n3 = this.a.getDegree();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                nArray2 = this.a(nArray2, nArray2, nArray);
            }
            int[] nArray4 = this.c(this.a(nArray2 = PolynomialGF2mSmallM.d(nArray2), nArray3), nArray);
            if (PolynomialGF2mSmallM.c(nArray4) == 0) continue;
            return false;
        }
        return true;
    }

    public PolynomialGF2mSmallM mod(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = this.e(this.c, polynomialGF2mSmallM.c);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    private int[] e(int[] nArray, int[] nArray2) {
        int n2 = PolynomialGF2mSmallM.c(nArray2);
        if (n2 == -1) {
            throw new ArithmeticException("Division by zero");
        }
        int[] nArray3 = new int[nArray.length];
        int n3 = PolynomialGF2mSmallM.a(nArray2);
        n3 = this.a.inverse(n3);
        System.arraycopy(nArray, 0, nArray3, 0, nArray3.length);
        while (n2 <= PolynomialGF2mSmallM.c(nArray3)) {
            int n4 = this.a.mult(PolynomialGF2mSmallM.a(nArray3), n3);
            int[] nArray4 = PolynomialGF2mSmallM.b(nArray2, PolynomialGF2mSmallM.c(nArray3) - n2);
            nArray4 = this.a(nArray4, n4);
            nArray3 = this.a(nArray4, nArray3);
        }
        return nArray3;
    }

    public PolynomialGF2mSmallM modMultiply(PolynomialGF2mSmallM polynomialGF2mSmallM, PolynomialGF2mSmallM polynomialGF2mSmallM2) {
        int[] nArray = this.a(this.c, polynomialGF2mSmallM.c, polynomialGF2mSmallM2.c);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    public PolynomialGF2mSmallM modSquareMatrix(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        int n2;
        int n3 = polynomialGF2mSmallMArray.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < this.c.length; ++n2) {
            nArray2[n2] = this.a.mult(this.c[n2], this.c[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (n2 >= polynomialGF2mSmallMArray[i2].c.length) continue;
                int n4 = this.a.mult(polynomialGF2mSmallMArray[i2].c[n2], nArray2[i2]);
                nArray[n2] = this.a.add(nArray[n2], n4);
            }
        }
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    private int[] a(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.e(this.d(nArray, nArray2), nArray3);
    }

    public PolynomialGF2mSmallM modSquareRoot(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = IntUtils.clone(this.c);
        int[] nArray2 = this.a(nArray, nArray, polynomialGF2mSmallM.c);
        while (!PolynomialGF2mSmallM.f(nArray2, this.c)) {
            nArray = PolynomialGF2mSmallM.d(nArray2);
            nArray2 = this.a(nArray, nArray, polynomialGF2mSmallM.c);
        }
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    public PolynomialGF2mSmallM modSquareRootMatrix(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        int n2;
        int n3 = polynomialGF2mSmallMArray.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (n2 >= polynomialGF2mSmallMArray[i2].c.length || i2 >= this.c.length) continue;
                int n4 = this.a.mult(polynomialGF2mSmallMArray[i2].c[n2], this.c[i2]);
                nArray[n2] = this.a.add(nArray[n2], n4);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = this.a.sqRoot(nArray[n2]);
        }
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    public PolynomialGF2mSmallM modDiv(PolynomialGF2mSmallM polynomialGF2mSmallM, PolynomialGF2mSmallM polynomialGF2mSmallM2) {
        int[] nArray = this.b(this.c, polynomialGF2mSmallM.c, polynomialGF2mSmallM2.c);
        return new PolynomialGF2mSmallM(this.a, nArray);
    }

    private int[] b(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = PolynomialGF2mSmallM.d(nArray3);
        int[] nArray5 = this.e(nArray2, nArray3);
        int[] nArray6 = new int[]{0};
        int[] nArray7 = this.e(nArray, nArray3);
        while (PolynomialGF2mSmallM.c(nArray5) != -1) {
            int[][] nArray8 = this.b(nArray4, nArray5);
            nArray4 = PolynomialGF2mSmallM.d(nArray5);
            nArray5 = PolynomialGF2mSmallM.d(nArray8[1]);
            int[] nArray9 = this.a(nArray6, this.a(nArray8[0], nArray7, nArray3));
            nArray6 = PolynomialGF2mSmallM.d(nArray7);
            nArray7 = PolynomialGF2mSmallM.d(nArray9);
        }
        int n2 = PolynomialGF2mSmallM.a(nArray4);
        nArray6 = this.a(nArray6, this.a.inverse(n2));
        return nArray6;
    }

    public PolynomialGF2mSmallM modInverse(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = new int[]{1};
        int[] nArray2 = this.b(nArray, this.c, polynomialGF2mSmallM.c);
        return new PolynomialGF2mSmallM(this.a, nArray2);
    }

    public PolynomialGF2mSmallM[] modPolynomialToFracton(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int n2 = polynomialGF2mSmallM.b >> 1;
        int[] nArray = PolynomialGF2mSmallM.d(polynomialGF2mSmallM.c);
        int[] nArray2 = this.e(this.c, polynomialGF2mSmallM.c);
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{1};
        while (PolynomialGF2mSmallM.c(nArray2) > n2) {
            int[][] nArray5 = this.b(nArray, nArray2);
            nArray = nArray2;
            nArray2 = nArray5[1];
            int[] nArray6 = this.a(nArray3, this.a(nArray5[0], nArray4, polynomialGF2mSmallM.c));
            nArray3 = nArray4;
            nArray4 = nArray6;
        }
        return new PolynomialGF2mSmallM[]{new PolynomialGF2mSmallM(this.a, nArray2), new PolynomialGF2mSmallM(this.a, nArray4)};
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PolynomialGF2mSmallM)) {
            return false;
        }
        PolynomialGF2mSmallM polynomialGF2mSmallM = (PolynomialGF2mSmallM)object;
        return this.a.equals(polynomialGF2mSmallM.a) && this.b == polynomialGF2mSmallM.b && PolynomialGF2mSmallM.f(this.c, polynomialGF2mSmallM.c);
    }

    private static boolean f(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = PolynomialGF2mSmallM.c(nArray);
        if (n3 != (n2 = PolynomialGF2mSmallM.c(nArray2))) {
            return false;
        }
        for (int i2 = 0; i2 <= n3; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.a.hashCode();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            n2 = n2 * 31 + this.c[i2];
        }
        return n2;
    }

    public String toString() {
        String string = " Polynomial over " + this.a.toString() + ": \n";
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            string = string + this.a.elementToStr(this.c[i2]) + "Y^" + i2 + "+";
        }
        string = string + ";";
        return string;
    }

    private void a() {
        this.b = this.c.length - 1;
        while (this.b >= 0 && this.c[this.b] == 0) {
            --this.b;
        }
    }

    private static int c(int[] nArray) {
        int n2;
        for (n2 = nArray.length - 1; n2 >= 0 && nArray[n2] == 0; --n2) {
        }
        return n2;
    }

    private static int[] d(int[] nArray) {
        int n2 = PolynomialGF2mSmallM.c(nArray);
        if (n2 == -1) {
            return new int[1];
        }
        if (nArray.length == n2 + 1) {
            return IntUtils.clone(nArray);
        }
        int[] nArray2 = new int[n2 + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2 + 1);
        return nArray2;
    }
}

