/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.interfaces.XMSSMTKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PublicKey;

public class BCXMSSMTPublicKey
implements XMSSMTKey,
PublicKey {
    private final ASN1ObjectIdentifier a;
    private final XMSSMTPublicKeyParameters b;

    public BCXMSSMTPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters) {
        this.a = aSN1ObjectIdentifier;
        this.b = xMSSMTPublicKeyParameters;
    }

    public BCXMSSMTPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        this.a = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
        XMSSPublicKey xMSSPublicKey = XMSSPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
        this.b = new XMSSMTPublicKeyParameters.Builder(new XMSSMTParameters(xMSSMTKeyParams.getHeight(), xMSSMTKeyParams.getLayers(), com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.a))).withPublicSeed(xMSSPublicKey.getPublicSeed()).withRoot(xMSSPublicKey.getRoot()).build();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPublicKey) {
            BCXMSSMTPublicKey bCXMSSMTPublicKey = (BCXMSSMTPublicKey)object;
            return this.a.equals(bCXMSSMTPublicKey.a) && Arrays.areEqual(this.b.toByteArray(), bCXMSSMTPublicKey.b.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode() + 37 * Arrays.hashCode(this.b.toByteArray());
    }

    @Override
    public final String getAlgorithm() {
        return "XMSSMT";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(this.b.getParameters().getHeight(), this.b.getParameters().getLayers(), new AlgorithmIdentifier(this.a)));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(this.b.getPublicSeed(), this.b.getRoot()));
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    CipherParameters getKeyParams() {
        return this.b;
    }

    @Override
    public int getHeight() {
        return this.b.getParameters().getHeight();
    }

    @Override
    public int getLayers() {
        return this.b.getParameters().getLayers();
    }

    @Override
    public String getTreeDigest() {
        return com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.b(this.a);
    }
}

